/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.config;

import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.config.BlockMatcher;

public interface Cfg {
    @NotNull
    public static Cfg get() {
        return ParagliderMod.instance().getConfig();
    }

    public boolean ascendingWinds();

    @NotNull
    public BlockMatcher windSourceMatcher();

    public double paraglidingSpeed();

    public int paragliderDurability();

    public boolean enderDragonDropsVessel();

    public boolean witherDropsVessel();

    public boolean raidGivesVessel();

    public int spawnerSpiritOrbDrops();

    public boolean spiritOrbLoots();

    public int startingHearts();

    public int maxHeartContainers();

    public int maxStamina();

    public int startingStamina();

    public int maxStaminaVessels();

    public boolean paraglidingConsumesStamina();

    public boolean runningConsumesStamina();

    @NotNull
    public TotwCompatConfigOption paragliderInTowersOfTheWild();

    default public boolean isWindSource(@NotNull BlockState state) {
        return this.windSourceMatcher().test(state);
    }

    default public int additionalMaxHealth(int heartContainers) {
        return (this.startingHearts() - 10 + Math.min(this.maxHeartContainers(), heartContainers)) * 2;
    }

    default public int maxStamina(int staminaVessels) {
        int maxStaminaVessels = this.maxStaminaVessels();
        int startingStamina = this.startingStamina();
        if (maxStaminaVessels <= 0) {
            return startingStamina;
        }
        if (maxStaminaVessels <= staminaVessels) {
            this.maxStamina();
        }
        return startingStamina + (int)((double)staminaVessels / (double)maxStaminaVessels * (double)(this.maxStamina() - startingStamina));
    }

    public static enum TotwCompatConfigOption {
        DEFAULT,
        DISABLE,
        PARAGLIDER_ONLY,
        DEKU_LEAF_ONLY;

    }
}

