/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.client.ParagliderClientSettings;
import tictim.paraglider.client.screen.BargainScreen;
import tictim.paraglider.client.screen.StaminaWheelSettingScreen;

public class ParagliderSettingScreen
extends Screen {
    private final Component saveButtonText = Component.m_237115_((String)"paragliderSettings.save");
    private final Component saveButtonTextUnsaved = Component.m_237115_((String)"paragliderSettings.save.unsaved");
    private final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
    @Nullable
    private ParticleSliderWidget particleSliderWidget;
    @Nullable
    private Button saveSettingsButton;
    @Nullable
    private SaveLoadAction saveLoadAction;

    public ParagliderSettingScreen() {
        super((Component)Component.m_237119_());
    }

    public void saveSettings() {
        if (this.particleSliderWidget != null && this.particleSliderWidget.dirty) {
            ParagliderClientSettings.get().setWindParticleFrequency(this.particleSliderWidget.value());
            this.particleSliderWidget.dirty = false;
        }
        SaveLoadAction saveLoadAction = new SaveLoadAction(false, null);
        Util.m_183992_().execute(() -> saveLoadAction.notifySaveResult(ParagliderClientSettings.get().save()));
        this.saveLoadAction = saveLoadAction;
    }

    public void loadSettings() {
        this.enableWidgets(false);
        SaveLoadAction saveLoadAction = new SaveLoadAction(true, b -> this.enableWidgets(true));
        Util.m_183992_().execute(() -> saveLoadAction.notifySaveResult(ParagliderClientSettings.get().load()));
        this.saveLoadAction = saveLoadAction;
    }

    private void enableWidgets(boolean enabled) {
        for (AbstractWidget widget : this.widgets) {
            widget.f_93623_ = enabled;
        }
    }

    protected void m_7856_() {
        this.widgets.clear();
        this.widgets.add((AbstractWidget)Button.m_253074_((Component)Component.m_237115_((String)"paragliderSettings.staminaWheelSettings"), b -> Objects.requireNonNull(this.f_96541_).m_91152_((Screen)new StaminaWheelSettingScreen(this))).m_253046_(128, 20).m_253136_());
        this.particleSliderWidget = new ParticleSliderWidget(128, 20, this.particleSliderWidget);
        this.widgets.add((AbstractWidget)this.particleSliderWidget);
        int totalHeight = (this.widgets.size() - 1) * 10;
        for (AbstractWidget w : this.widgets) {
            totalHeight += w.m_93694_();
        }
        int y = (this.f_96544_ - totalHeight) / 2;
        for (AbstractWidget w : this.widgets) {
            w.m_252865_((this.f_96543_ - w.m_5711_()) / 2);
            w.m_253211_(y);
            y += w.m_93694_() + 10;
        }
        this.saveSettingsButton = Button.m_253074_((Component)this.saveButtonText, b -> this.saveSettings()).m_252987_(this.f_96543_ - 128 - 10, this.f_96544_ - 20 - 10 - 20 - 10 - 20 - 10, 128, 20).m_253136_();
        this.widgets.add((AbstractWidget)this.saveSettingsButton);
        this.widgets.add((AbstractWidget)Button.m_253074_((Component)Component.m_237115_((String)"paragliderSettings.openFolder"), b -> Util.m_137581_().m_137648_(ParagliderClientSettings.get().configPath().getParent().toUri())).m_252987_(this.f_96543_ - 128 - 10, this.f_96544_ - 20 - 10 - 20 - 10, 128, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"paragliderSettings.openFolder.tooltip"))).m_253136_());
        this.widgets.add((AbstractWidget)Button.m_253074_((Component)Component.m_237115_((String)"paragliderSettings.reload"), b -> this.loadSettings()).m_252987_(this.f_96543_ - 128 - 10, this.f_96544_ - 20 - 10, 128, 20).m_253136_());
        for (AbstractWidget widget : this.widgets) {
            this.m_142416_((GuiEventListener)widget);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        if (this.saveSettingsButton != null) {
            this.saveSettingsButton.m_93666_(this.particleSliderWidget != null && this.particleSliderWidget.dirty ? this.saveButtonTextUnsaved : this.saveButtonText);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.saveLoadAction != null) {
            int alpha;
            this.saveLoadAction.update();
            int n = alpha = !this.saveLoadAction.isComplete() ? 255 : BargainScreen.getDialogAlpha(ParagliderUtils.ms() - this.saveLoadAction.saveCompleteTimestamp);
            if (alpha == 0) {
                this.saveLoadAction = null;
            } else {
                Component component = this.saveLoadAction.text();
                Objects.requireNonNull(this.f_96547_);
                graphics.m_280614_(this.f_96547_, component, 5, this.f_96544_ - 9 - 5, alpha << 24 | 0xFFFFFF, true);
            }
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (ParagliderUtils.isActiveAndMatches(this.f_96541_.f_91066_.f_92092_, mouseKey) || ParagliderUtils.getKey(ParagliderMod.instance().getParagliderSettingsKey()).equals((Object)mouseKey)) {
            this.m_7379_();
            return true;
        }
        return false;
    }

    private static final class ParticleSliderWidget
    extends AbstractSliderButton {
        private boolean dirty;
        private static final DecimalFormat fmt = new DecimalFormat("0%");

        public ParticleSliderWidget(int width, int height, @Nullable ParticleSliderWidget prevInstance) {
            super(0, 0, width, height, (Component)Component.m_237119_(), 0.0);
            if (prevInstance != null) {
                this.m_257544_(prevInstance.m_278622_());
                this.m_93666_(prevInstance.m_6035_());
                this.f_93577_ = prevInstance.f_93577_;
                this.dirty = prevInstance.dirty;
            } else {
                this.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"paragliderSettings.windParticleFreq.tooltip")));
                this.f_93577_ = ParagliderClientSettings.get().windParticleFrequency();
                this.m_93666_(ParticleSliderWidget.message(this.f_93577_));
                this.dirty = false;
            }
        }

        public double value() {
            return this.f_93577_;
        }

        protected void m_5695_() {
            this.m_93666_(ParticleSliderWidget.message(this.f_93577_));
        }

        protected void m_5697_() {
            this.dirty = true;
        }

        private static Component message(double value) {
            return Component.m_237110_((String)"paragliderSettings.windParticleFreq", (Object[])new Object[]{fmt.format(value)});
        }
    }

    private static final class SaveLoadAction {
        private final boolean isLoading;
        @Nullable
        private BooleanConsumer callback;
        private volatile State state = State.WAITING;
        private volatile long saveCompleteTimestamp;

        private SaveLoadAction(boolean isLoading, @Nullable BooleanConsumer callback) {
            this.isLoading = isLoading;
            this.callback = callback;
        }

        void update() {
            if (this.callback != null && this.isComplete()) {
                this.callback.accept(this.state == State.SUCCESS);
                this.callback = null;
            }
        }

        void notifySaveResult(boolean success) {
            if (this.state != State.WAITING) {
                return;
            }
            this.state = success ? State.SUCCESS : State.FAIL;
            this.saveCompleteTimestamp = ParagliderUtils.ms();
        }

        boolean isComplete() {
            return this.state != State.WAITING;
        }

        @NotNull
        Component text() {
            return this.isLoading ? this.state.loadText : this.state.saveText;
        }

        static enum State {
            WAITING("paragliderSettings.saving", "paragliderSettings.loading"),
            SUCCESS("paragliderSettings.saving.success", "paragliderSettings.loading.success"),
            FAIL("paragliderSettings.saving.failure", "paragliderSettings.loading.failure", ChatFormatting.RED);

            final Component saveText;
            final Component loadText;

            private State(String saveKey, String loadKey) {
                this.saveText = Component.m_237115_((String)saveKey);
                this.loadText = Component.m_237115_((String)loadKey);
            }

            private State(String saveKey, String loadKey, ChatFormatting fmt) {
                this.saveText = Component.m_237115_((String)saveKey).m_130940_(fmt);
                this.loadText = Component.m_237115_((String)loadKey).m_130940_(fmt);
            }
        }
    }
}

