/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.item.ItemKey;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemPriorityKey
extends ItemKey {
    private final int level;
    private final int nextLevel;
    private static final Map<Integer, ItemPriorityKey> priorityLookup = new HashMap<Integer, ItemPriorityKey>();

    public ItemPriorityKey(int level, int nextLevel, Item.Properties properties) {
        super(properties);
        this.level = level;
        this.nextLevel = nextLevel;
        priorityLookup.put(level, this);
    }

    public ItemPriorityKey getNextKey() {
        return priorityLookup.getOrDefault(this.nextLevel, this);
    }

    @Override
    protected void handleDrawerAttributes(IDrawerAttributesModifiable attrs) {
        if (this.level == 0) {
            attrs.setPriority(ItemPriorityKey.priorityLookup.getOrDefault((Object)Integer.valueOf((int)attrs.getPriority()), (ItemPriorityKey)this).getNextKey().level);
        } else if (this.level == attrs.getPriority()) {
            attrs.setPriority(0);
        } else {
            attrs.setPriority(this.level);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_6144_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        ItemStack nextKey = new ItemStack((ItemLike)this.getNextKey(), 1);
        nextKey.m_41751_(stack.m_41783_());
        return InteractionResultHolder.m_19090_((Object)nextKey);
    }
}

