/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.proxy;

import auviotre.enigmatic.addon.EnigmaticAddons;
import auviotre.enigmatic.addon.client.renderers.DragonBreathArrowRenderer;
import auviotre.enigmatic.addon.client.renderers.EmptyRenderer;
import auviotre.enigmatic.addon.client.renderers.ThrownAstralSpearRenderer;
import auviotre.enigmatic.addon.client.renderers.ThrownEvilDaggerRenderer;
import auviotre.enigmatic.addon.client.renderers.ThrownIchorSpearRenderer;
import auviotre.enigmatic.addon.client.renderers.UltimateDragonFireballRenderer;
import auviotre.enigmatic.addon.client.renderers.layers.ChaosElytraLayer;
import auviotre.enigmatic.addon.client.screens.AntiqueBagScreen;
import auviotre.enigmatic.addon.proxy.CommonProxy;
import auviotre.enigmatic.addon.registries.EnigmaticAddonEntities;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import auviotre.enigmatic.addon.registries.EnigmaticAddonMenus;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    @Override
    public void clientInit() {
        this.initEntityRenderers();
        this.initItemProperties();
        MenuScreens.m_96206_(EnigmaticAddonMenus.ANTIQUE_BAG_MENU, AntiqueBagScreen::new);
    }

    public void initItemProperties() {
        try {
            ItemProperties.register((Item)EnigmaticAddonItems.DISASTER_SWORD, (ResourceLocation)new ResourceLocation("blocking"), (stack, world, living, j) -> living != null && living.m_6117_() && living.m_21211_() == stack ? 1.0f : 0.0f);
            ItemProperties.register((Item)EnigmaticAddonItems.EARTH_PROMISE, (ResourceLocation)new ResourceLocation("broken"), (stack, world, living, j) -> {
                Player player;
                return living instanceof Player && (player = (Player)living).m_36335_().m_41519_(stack.m_41720_()) ? 1.0f : 0.0f;
            });
            ItemProperties.register((Item)EnigmaticAddonItems.ASTRAL_SPEAR, (ResourceLocation)new ResourceLocation("using"), (stack, world, living, j) -> living != null && living.m_21211_() == stack ? 1.0f : 0.0f);
            ItemProperties.register((Item)EnigmaticAddonItems.ICHOR_SPEAR, (ResourceLocation)new ResourceLocation("using"), (stack, world, living, j) -> living != null && living.m_21211_() == stack ? 1.0f : 0.0f);
            ItemProperties.register((Item)EnigmaticAddonItems.DRAGON_BOW, (ResourceLocation)new ResourceLocation("pulling"), (stack, world, living, j) -> living != null && living.m_6117_() && living.m_21211_() == stack ? 1.0f : 0.0f);
            ItemProperties.register((Item)EnigmaticAddonItems.DRAGON_BOW, (ResourceLocation)new ResourceLocation("pull"), (stack, level, living, i) -> living == null ? 0.0f : (living.m_21211_() != stack ? 0.0f : (float)(stack.m_41779_() - living.m_21212_()) / 20.0f));
        }
        catch (Exception exception) {
            EnigmaticAddons.LOGGER.warn("Could not load item models.");
        }
    }

    private void initEntityRenderers() {
        EntityRenderers.m_174036_(EnigmaticAddonEntities.DRAGON_BREATH_ARROW, DragonBreathArrowRenderer::new);
        EntityRenderers.m_174036_(EnigmaticAddonEntities.COBWEB_BALL, EmptyRenderer::new);
        EntityRenderers.m_174036_(EnigmaticAddonEntities.SPLIT_DRAGON_BREATH, EmptyRenderer::new);
        EntityRenderers.m_174036_(EnigmaticAddonEntities.ULTIMATE_DRAGON_FIREBALL, UltimateDragonFireballRenderer::new);
        EntityRenderers.m_174036_(EnigmaticAddonEntities.ICHOR_SPEAR, ThrownIchorSpearRenderer::new);
        EntityRenderers.m_174036_(EnigmaticAddonEntities.ASTRAL_SPEAR, ThrownAstralSpearRenderer::new);
        EntityRenderers.m_174036_(EnigmaticAddonEntities.EVIL_DAGGER, ThrownEvilDaggerRenderer::new);
        EntityRenderers.m_174036_(EnigmaticAddonEntities.DISASTER_CHAOS, EmptyRenderer::new);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void addLayers(EntityRenderersEvent.AddLayers event) {
        this.addPlayerLayer(event, "default");
        this.addPlayerLayer(event, "slim");
    }

    @OnlyIn(value=Dist.CLIENT)
    private <T extends LivingEntity, M extends EntityModel<T>> void addPlayerLayer(EntityRenderersEvent.AddLayers event, String skin) {
        LivingEntityRenderer renderer = event.getSkin(skin);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = renderer;
            livingRenderer.m_115326_(new ChaosElytraLayer(livingRenderer, event.getEntityModels()));
        }
    }
}

