/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.mixin;

import auviotre.enigmatic.addon.EnigmaticAddons;
import auviotre.enigmatic.addon.contents.items.TotemOfMalice;
import auviotre.enigmatic.addon.handlers.OmniconfigAddonHandler;
import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.addon.packets.clients.PacketEvilCage;
import auviotre.enigmatic.addon.packets.clients.PacketMaliceTotem;
import auviotre.enigmatic.addon.registries.EnigmaticAddonDamageTypes;
import auviotre.enigmatic.addon.registries.EnigmaticAddonEffects;
import auviotre.enigmatic.addon.registries.EnigmaticAddonEnchantments;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.FrostWalkerEnchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.extensions.IForgeLivingEntity;
import net.minecraftforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity
implements Attackable,
IForgeLivingEntity {
    public MixinLivingEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Shadow
    public abstract boolean m_142079_();

    @Shadow
    public abstract void m_21153_(float var1);

    @Shadow
    public abstract float m_21233_();

    @Shadow
    public abstract boolean m_21219_();

    @Shadow
    public abstract boolean m_246525_(ItemStack var1, ItemStack var2);

    @Shadow
    public abstract boolean m_7066_(ItemStack var1);

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tickMix(CallbackInfo ci) {
        if (this.m_9236_().f_46443_ && OmniconfigAddonHandler.frostParticle.getValue() && this.m_146890_() && Math.random() > 0.25) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, this.m_20208_(0.6), this.m_20187_() + 0.1, this.m_20262_(0.6), 0.0, -0.05, 0.0);
        }
        if (!this.m_142079_() && this.m_146888_() > 0) {
            this.m_146917_(0);
        }
    }

    @Inject(method={"canFreeze"}, at={@At(value="RETURN")}, cancellable=true)
    public void canFreezeMix(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)((Boolean)cir.getReturnValue() != false && !this.self().m_21023_((MobEffect)EnigmaticAddonEffects.FROZEN_HEART_EFFECT) && !SuperpositionHandler.hasCurio((LivingEntity)this.self(), (Item)EnigmaticAddonItems.FORGOTTEN_ICE) && EnchantmentHelper.m_44836_((Enchantment)EnigmaticAddonEnchantments.FROST_PROTECTION, (LivingEntity)this.self()) < 16 ? 1 : 0));
    }

    @Inject(method={"onChangedBlock"}, at={@At(value="HEAD")})
    public void onChangedBlockMix(BlockPos pos, CallbackInfo ci) {
        if (SuperpositionHandler.hasCurio((LivingEntity)this.self(), (Item)EnigmaticAddonItems.FORGOTTEN_ICE)) {
            FrostWalkerEnchantment.m_45018_((LivingEntity)this.self(), (Level)this.m_9236_(), (BlockPos)pos, (int)1);
        }
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"), index=1, argsOnly=true)
    public DamageSource hurtMix(DamageSource source) {
        Player player;
        Entity entity = source.m_7639_();
        if (entity instanceof Player && SuperpositionHandler.isTheCursedOne((Player)(player = (Player)entity)) && SuperpositionHandler.hasItem((Player)player, (Item)EnigmaticAddonItems.FALSE_JUSTICE)) {
            return player.m_269291_().m_268998_(EnigmaticAddonDamageTypes.FALSE_JUSTICE, source.m_7640_(), (Entity)player);
        }
        return source;
    }

    @Inject(method={"checkTotemDeathProtection"}, at={@At(value="RETURN")}, cancellable=true)
    public void checkMix(DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity livingEntity;
        if (!((Boolean)cir.getReturnValue()).booleanValue() && !source.m_269533_(DamageTypeTags.f_268738_) && (livingEntity = this.self()) instanceof Player && SuperpositionHandler.isTheCursedOne((Player)(player = (Player)livingEntity))) {
            ItemStack stack = ItemStack.f_41583_;
            if (SuperpositionHandler.hasItem((Player)player, (Item)EnigmaticAddonItems.TOTEM_OF_MALICE)) {
                ItemStack itemStack = SuperAddonHandler.getItem(player, (Item)EnigmaticAddonItems.TOTEM_OF_MALICE);
                stack = itemStack.m_41777_();
                TotemOfMalice.hurtAndBreak(itemStack, (LivingEntity)player);
            } else if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.TOTEM_OF_MALICE)) {
                ItemStack curioStack = SuperpositionHandler.getCurioStack((LivingEntity)player, (Item)EnigmaticAddonItems.TOTEM_OF_MALICE);
                stack = curioStack.m_41777_();
                TotemOfMalice.hurtAndBreak(curioStack, (LivingEntity)player);
            }
            if (!stack.m_41619_()) {
                PacketDistributor.PacketTarget packet = PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(this.m_20185_(), this.m_20186_(), this.m_20189_(), 64.0, this.m_9236_().m_46472_()));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_6278_(Stats.f_12982_.m_12902_((Object)EnigmaticAddonItems.TOTEM_OF_MALICE), 1);
                    CriteriaTriggers.f_10551_.m_74431_(serverPlayer, stack);
                    EnigmaticAddons.packetInstance.send(packet, (Object)new PacketMaliceTotem(this.m_20185_(), this.m_20186_(), this.m_20189_()));
                }
                float damage = this.m_21233_() * (1.5f + (float)SuperpositionHandler.getCurseAmount((ItemStack)stack) * 0.5f);
                List entities = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(8.0));
                for (LivingEntity entity : entities) {
                    if (entity == player) continue;
                    Vec3 delta = entity.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82490_(0.5);
                    float modifier = Math.min(1.0f, 0.8f / entity.m_20270_((Entity)this));
                    Vec3 vec = new Vec3(delta.f_82479_, 0.0, delta.f_82481_).m_82541_().m_82490_((double)modifier);
                    entity.m_246865_(new Vec3(vec.f_82479_, entity.m_20096_() ? (double)(1.2f * modifier) : 0.0, vec.f_82481_));
                    entity.m_6469_(entity.m_269291_().m_269298_(EnigmaticAddonDamageTypes.EVIL_CURSE, (Entity)player), damage);
                    entity.f_19802_ = 0;
                    EnigmaticAddons.packetInstance.send(packet, (Object)new PacketEvilCage(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_20205_() / 2.0f, entity.m_20206_(), 0));
                }
                this.m_21153_(this.m_21233_());
                this.m_21219_();
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"canStandOnFluid"}, at={@At(value="RETURN")}, cancellable=true)
    public void canStandOnFluidMix(FluidState fluidState, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue() && SuperpositionHandler.hasCurio((LivingEntity)this.self(), (Item)EnigmaticAddonItems.SCORCHED_CHARM)) {
            cir.setReturnValue((Object)fluidState.m_205070_(FluidTags.f_13132_));
        }
    }
}

