/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.handlers;

import auviotre.enigmatic.addon.api.events.LivingCurseBoostEvent;
import auviotre.enigmatic.addon.contents.objects.bookbag.AntiqueBagCapability;
import auviotre.enigmatic.addon.contents.objects.bookbag.IAntiqueBagHandler;
import auviotre.enigmatic.addon.handlers.AddonHookHandler;
import auviotre.enigmatic.addon.handlers.OmniconfigAddonHandler;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.mutable.MutableBoolean;
import top.theillusivec4.curios.api.CuriosApi;

public class SuperAddonHandler {
    public static final UUID SCROLL_SLOT_UUID = UUID.fromString("6baf05e3-a59c-43d8-9154-613ff87073e2");

    public static boolean isCurseBoosted(LivingEntity entity) {
        if (!OmniconfigAddonHandler.EnableCurseBoost.getValue()) {
            return false;
        }
        return entity.getPersistentData().m_128471_("CurseBoost");
    }

    public static void setCurseBoosted(LivingEntity entity, Boolean flag, Player player) {
        Mob mob;
        if (!OmniconfigAddonHandler.EnableCurseBoost.getValue()) {
            return;
        }
        if (entity instanceof Mob && (mob = (Mob)entity).m_21525_()) {
            return;
        }
        LivingCurseBoostEvent event = AddonHookHandler.onLivingCurseBoosted(entity, player);
        if (!event.isCanceled()) {
            entity.getPersistentData().m_128379_("CurseBoost", flag.booleanValue());
        }
    }

    @Nullable
    public static <T> LazyOptional<T> getCapability(Player player, Capability<T> capability) {
        return player == null ? null : player.getCapability(capability);
    }

    public static boolean unlockSpecialSlot(String slot, Player player) {
        if (!slot.equals("scroll")) {
            throw new IllegalArgumentException("Slot type '" + slot + "' is not supported!");
        }
        MutableBoolean success = new MutableBoolean(false);
        UUID id = SCROLL_SLOT_UUID;
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.getStacksHandler(slot).ifPresent(stacks -> {
            if (!stacks.getModifiers().containsKey(id)) {
                stacks.addPermanentModifier(new AttributeModifier(id, "MasterSlot", 1.0, AttributeModifier.Operation.ADDITION));
                success.setTrue();
            }
        }));
        return success.getValue();
    }

    @Nullable
    public static ItemStack getChaosElytra(LivingEntity living) {
        ItemStack stack = living.m_6844_(EquipmentSlot.CHEST);
        return stack.m_150930_((Item)EnigmaticAddonItems.CHAOS_ELYTRA) ? stack : SuperpositionHandler.getCurioStack((LivingEntity)living, (Item)EnigmaticAddonItems.CHAOS_ELYTRA);
    }

    public static ItemStack getItem(Player player, Item item) {
        for (NonNullList stacks : player.m_150109_().f_35979_) {
            for (ItemStack itemstack : stacks) {
                if (itemstack.m_41619_() || !itemstack.m_150930_(item)) continue;
                return itemstack;
            }
        }
        return ItemStack.f_41583_;
    }

    private static boolean hasBlessRing(Player player) {
        return player.getPersistentData().m_128471_("BlessNextSpawn") || SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.BLESS_RING);
    }

    public static boolean isTheBlessedOne(Player player) {
        return SuperAddonHandler.hasBlessRing(player) && !SuperpositionHandler.isTheCursedOne((Player)player);
    }

    public static boolean isOKOne(Player player) {
        return SuperAddonHandler.hasBlessRing(player) || SuperpositionHandler.isTheCursedOne((Player)player);
    }

    public static boolean isPunishedOne(LivingEntity entity) {
        Player player;
        return entity instanceof Player && SuperAddonHandler.hasBlessRing(player = (Player)entity) && SuperpositionHandler.isTheCursedOne((Player)player);
    }

    public static ItemStack findBookInBag(Player player, Item book) {
        if (!SuperpositionHandler.hasItem((Player)player, (Item)EnigmaticAddonItems.ANTIQUE_BAG) && !player.m_36327_().m_18949_(Set.of(EnigmaticAddonItems.ANTIQUE_BAG))) {
            return ItemStack.f_41583_;
        }
        LazyOptional<IAntiqueBagHandler> capability = SuperAddonHandler.getCapability(player, AntiqueBagCapability.INVENTORY);
        if (capability != null && capability.isPresent()) {
            IAntiqueBagHandler bagHandler = (IAntiqueBagHandler)capability.orElseThrow(() -> new IllegalArgumentException("Lazy optional must not be empty"));
            return bagHandler.findBook(book);
        }
        return ItemStack.f_41583_;
    }

    public static AABB getBoundingBoxAroundEntity(Entity entity, double x, double y, double z) {
        return new AABB(entity.m_20185_() - x, entity.m_20186_() - y, entity.m_20189_() - z, entity.m_20185_() + x, entity.m_20186_() + y, entity.m_20189_() + z);
    }

    @Nullable
    public static LootPoolSingletonContainer.Builder<?> createOptionalLootEntry(Item item, int weight, float minCount, float maxCount) {
        return !OmniconfigAddonHandler.isItemEnabled(item) ? null : LootItem.m_79579_((ItemLike)item).m_79707_(weight).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)minCount, (float)maxCount)));
    }

    @Nullable
    public static LootPoolSingletonContainer.Builder<?> createOptionalLootEntry(Item item, int weight) {
        return !OmniconfigAddonHandler.isItemEnabled(item) ? null : LootItem.m_79579_((ItemLike)item).m_79707_(weight);
    }

    public static List<ResourceLocation> getIceDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(BuiltInLootTables.f_78688_);
        return lootChestList;
    }

    public static List<ResourceLocation> getJungleDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(BuiltInLootTables.f_78686_);
        return lootChestList;
    }

    public static List<ResourceLocation> getEngineDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(BuiltInLootTables.f_78742_);
        lootChestList.add(BuiltInLootTables.f_78690_);
        lootChestList.add(BuiltInLootTables.f_78691_);
        lootChestList.add(BuiltInLootTables.f_78763_);
        lootChestList.add(BuiltInLootTables.f_78762_);
        return lootChestList;
    }

    public static List<ResourceLocation> getNetherDungeons() {
        ArrayList<ResourceLocation> lootChestList = new ArrayList<ResourceLocation>();
        lootChestList.add(BuiltInLootTables.f_78760_);
        lootChestList.add(BuiltInLootTables.f_78697_);
        lootChestList.add(BuiltInLootTables.f_78698_);
        lootChestList.add(BuiltInLootTables.f_78699_);
        lootChestList.add(BuiltInLootTables.f_78700_);
        return lootChestList;
    }
}

