/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.objects.bookbag;

import auviotre.enigmatic.addon.contents.objects.bookbag.IAntiqueBagHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class AntiqueBagCapability {
    public static final Capability<IAntiqueBagHandler> INVENTORY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IAntiqueBagHandler>(){});
    public static final ResourceLocation ID_INVENTORY = new ResourceLocation("enigmaticaddons", "antique_bag");

    public static ICapabilityProvider createProvider(LivingEntity livingEntity) {
        return new Provider(livingEntity);
    }

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        final LazyOptional<IAntiqueBagHandler> optional;
        final IAntiqueBagHandler handler;
        final LivingEntity owner;

        Provider(LivingEntity livingEntity) {
            this.owner = livingEntity;
            this.handler = new Wrapper(this.owner);
            this.optional = LazyOptional.of(() -> this.handler);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction facing) {
            return INVENTORY.orEmpty(capability, this.optional);
        }

        public Tag serializeNBT() {
            return this.handler.writeTag();
        }

        public void deserializeNBT(Tag nbt) {
            this.handler.readTag(nbt);
        }
    }

    public static class Wrapper
    implements IAntiqueBagHandler {
        public static final int SLOTS_COUNT = 12;
        IItemHandlerModifiable inventory = new ItemStackHandler(12);
        LivingEntity owner;

        public Wrapper(LivingEntity livingEntity) {
            this.owner = livingEntity;
            this.reset();
        }

        @Override
        public void reset() {
            this.inventory = new ItemStackHandler(12);
        }

        @Override
        public int getSlots() {
            return 12;
        }

        @Override
        public ItemStack getBook(int index) {
            return this.inventory.getStackInSlot(index);
        }

        @Override
        public void setBook(int index, ItemStack book) {
            this.inventory.setStackInSlot(index, book);
        }

        @Override
        public ItemStack findBook(Item book) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.m_41720_() != book) continue;
                return stack;
            }
            return ItemStack.f_41583_;
        }

        @Override
        public LivingEntity getOwner() {
            return this.owner;
        }

        @Override
        public IItemHandlerModifiable getInventory() {
            return this.inventory;
        }

        @Override
        public void setInventory(IItemHandlerModifiable list) {
            this.inventory = list;
        }

        @Override
        public Tag writeTag() {
            CompoundTag compound = new CompoundTag();
            ListTag tagList = new ListTag();
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                CompoundTag tag = new CompoundTag();
                tag.m_128365_("Item", (Tag)this.inventory.getStackInSlot(i).serializeNBT());
                tag.m_128405_("Slot", i);
                tagList.add((Object)tag);
            }
            compound.m_128365_("AntiqueBag", (Tag)tagList);
            return compound;
        }

        @Override
        public void readTag(Tag nbt) {
            ListTag tagList = ((CompoundTag)nbt).m_128437_("AntiqueBag", 10);
            if (!tagList.isEmpty()) {
                ItemStackHandler itemStackHandler = new ItemStackHandler(12);
                for (int i = 0; i < tagList.size(); ++i) {
                    CompoundTag tag = tagList.m_128728_(i);
                    int slotId = tag.m_128451_("Slot");
                    ItemStack stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"));
                    itemStackHandler.setStackInSlot(slotId, stack);
                }
                this.setInventory((IItemHandlerModifiable)itemStackHandler);
            }
        }
    }
}

