/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.ICursed;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class TotemOfMalice
extends ItemBaseCurio
implements ICursed,
Vanishable {
    public static final List<ResourceLocation> extraRaiderList = new ArrayList<ResourceLocation>();
    public static Omniconfig.DoubleParameter raiderBoost;
    public static Omniconfig.DoubleParameter raiderResistance;

    public TotemOfMalice() {
        super(ItemBaseCurio.getDefaultProperties().m_41497_(Rarity.EPIC).m_41503_(3));
    }

    @SubscribeConfig
    public static void onConfig(@NotNull OmniconfigWrapper builder) {
        builder.pushPrefix("TotemofMalice");
        raiderBoost = builder.comment("The damage modifier to the Raiders.").max(400.0).min(0.0).getDouble("RaiderDamageBoost", 1.5);
        raiderResistance = builder.comment("The damage resistance to the Raiders.").max(400.0).min(0.0).getDouble("RaiderDamageResistance", 0.5);
        extraRaiderList.clear();
        String[] list = builder.config.getStringList("TotemofMaliceExtraRaiderList", "Balance Options", new String[0], "List of entities that will be affected as Raider by the Totem of Malice. Examples: minecraft:witch. Changing this option required game restart to take effect.");
        Arrays.stream(list).forEach(entry -> extraRaiderList.add(new ResourceLocation(entry)));
        builder.popPrefix();
    }

    public static boolean isEnable(Player player) {
        return SuperpositionHandler.isTheCursedOne((Player)player) && (SuperpositionHandler.hasItem((Player)player, (Item)EnigmaticAddonItems.TOTEM_OF_MALICE) || SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.TOTEM_OF_MALICE));
    }

    public static void hurtAndBreak(ItemStack stack, LivingEntity entity) {
        if (!(entity.m_9236_().m_5776_() || entity instanceof Player && ((Player)entity).m_150110_().f_35937_)) {
            int damage = TotemOfMalice.getTotemDamage(stack);
            int level = stack.getEnchantmentLevel(Enchantments.f_44986_);
            if (++damage >= 3 + level) {
                stack.m_41774_(1);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.m_36246_(Stats.f_12983_.m_12902_((Object)stack.m_41720_()));
                }
            }
            entity.f_19802_ = 60;
            TotemOfMalice.setTotemDamage(stack, damage);
        }
    }

    public static int getTotemDamage(ItemStack stack) {
        return !stack.m_41782_() ? 0 : stack.m_41783_().m_128451_("TotemMDamage");
    }

    public static void setTotemDamage(ItemStack stack, int damage) {
        stack.m_41784_().m_128405_("TotemMDamage", Math.max(0, damage));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> list, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.totemofMalice1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.totemofMalice2", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{String.format("%.0f", 100.0 * raiderBoost.getValue()) + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.totemofMalice3", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{String.format("%.0f", 100.0 * raiderResistance.getValue()) + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.totemofMalice4");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.totemofMalice5");
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        ItemLoreHelper.indicateCursedOnesOnly(list);
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment != Enchantments.f_44962_;
    }

    public boolean m_142522_(ItemStack stack) {
        return TotemOfMalice.getTotemDamage(stack) > 0;
    }

    public int m_142158_(ItemStack stack) {
        int level = stack.getEnchantmentLevel(Enchantments.f_44986_);
        return Math.round(13.0f - (float)TotemOfMalice.getTotemDamage(stack) * 13.0f / (3.0f + (float)level));
    }

    public int m_142159_(ItemStack stack) {
        int level = stack.getEnchantmentLevel(Enchantments.f_44986_);
        float stackMaxDamage = 3.0f + (float)level;
        float f = Math.max(0.0f, (stackMaxDamage - (float)TotemOfMalice.getTotemDamage(stack)) / stackMaxDamage);
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }
}

