/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.ISpellstone;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ExperienceHelper;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemSpellstoneCurio;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotContext;

public class RevivalLeaf
extends ItemSpellstoneCurio
implements ISpellstone {
    public static Omniconfig.IntParameter spellstoneCooldown;
    public static Omniconfig.IntParameter naturalRegenerationSpeed;
    public static Omniconfig.DoubleParameter skillRadius;
    public static Omniconfig.IntParameter poisonTime;
    public static Omniconfig.IntParameter poisonLevel;
    public static Omniconfig.IntParameter regenerationTime;
    public static Omniconfig.IntParameter regenerationLevel;

    public RevivalLeaf() {
        super(ItemSpellstoneCurio.getDefaultProperties().m_41497_(Rarity.RARE));
        this.immunityList.add(DamageTypes.f_268493_);
        this.resistanceList.put(DamageTypes.f_268631_, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageTypes.f_268468_, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageTypes.f_268546_, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageTypes.f_268434_, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageTypes.f_268684_, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageTypes.f_268534_, () -> Float.valueOf(1.5f));
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("RevivalLeaf");
        spellstoneCooldown = builder.comment("Active ability cooldown for Revival Leaf. Measured in ticks. 20 ticks equal to 1 second.").getInt("Cooldown", 320);
        naturalRegenerationSpeed = builder.comment("The time required for each 0.5HP treatment from the natural regeneration of the Revival Leaf. Measured in ticks.").min(5.0).getInt("NaturalRegenerationTick", 40);
        skillRadius = builder.comment("The effect radius of Revival Leaf' ability.").getDouble("AbilityRadius", 5.0);
        poisonTime = builder.comment("Amount of ticks for which bearer of the leaf will apply Poison effect to entities they attack. 20 ticks equals to 1 second.").getInt("PoisonTime", 160);
        poisonLevel = builder.comment("Level of Poison that bearer of the leaf will apply to entities they attack.").max(3.0).getInt("PoisonLevel", 1);
        regenerationTime = builder.comment("Amount of ticks for which bearer of the leaf will apply Regeneration effect to entities nearby when ability activated.").getInt("RegenerationTime", 180);
        regenerationLevel = builder.comment("Level of Regeneration that bearer of the leaf will apply to entities nearby when ability activated.").max(3.0).getInt("RegenerationLevel", 1);
        builder.popPrefix();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.revivalLeaf1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.revivalLeaf2");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.revivalLeafCooldown", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{Float.valueOf((float)this.getCooldown((Player)Minecraft.m_91087_().f_91074_) / 20.0f)});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.revivalLeaf3");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.revivalLeaf4");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.revivalLeaf5");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.revivalLeaf6");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.revivalLeaf7");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.revivalLeaf8");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.revivalLeaf9");
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
        try {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.currentKeybind", (ChatFormatting)ChatFormatting.LIGHT_PURPLE, (Object[])new Object[]{((Component)KeyMapping.m_90842_((String)"key.spellstoneAbility").get()).getString().toUpperCase()});
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public int getCooldown(Player player) {
        return player != null && reducedCooldowns.test(player) ? 200 : spellstoneCooldown.getValue();
    }

    public void triggerActiveAbility(Level world, ServerPlayer player, ItemStack stack) {
        if (!SuperpositionHandler.hasSpellstoneCooldown((Player)player)) {
            int level = ExperienceHelper.getPlayerXPLevel((Player)player);
            int playerXP = ExperienceHelper.getPlayerXP((Player)player);
            if (playerXP > 10) {
                ExperienceHelper.drainPlayerXP((Player)player, (int)Math.min(Mth.m_14167_((float)(5.0f * player.m_217043_().m_188501_())) + level, playerXP));
                world.m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, (float)(0.8 + Math.random() * 0.2));
                SuperpositionHandler.setSpellstoneCooldown((Player)player, (int)this.getCooldown((Player)player));
                List genericMobs = player.m_9236_().m_45976_(LivingEntity.class, SuperpositionHandler.getBoundingBoxAroundEntity((Entity)player, (double)skillRadius.getValue()));
                for (LivingEntity mob : genericMobs) {
                    if (level > 25) {
                        float maxHealth = mob.m_21233_();
                        mob.m_5634_(Math.min(0.2f, (float)(level - 25) * 0.01f) * maxHealth);
                    }
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19605_, regenerationTime.getValue() + Math.min(playerXP * level / 2, regenerationTime.getValue()), regenerationLevel.getValue(), false, true));
                }
            }
        }
    }

    public void curioTick(SlotContext context, ItemStack stack) {
        LivingEntity entity = context.entity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_21220_().isEmpty()) {
                for (MobEffectInstance activeEffect : new ArrayList(player.m_21220_())) {
                    if (activeEffect.m_19544_() != MobEffects.f_19612_ && activeEffect.m_19544_() != MobEffects.f_19615_ && activeEffect.m_19544_() != MobEffects.f_19614_) continue;
                    player.m_21195_(activeEffect.m_19544_());
                }
            }
            BlockPos blockPos = player.m_20183_();
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)level;
                for (int i = -3; i < 3; ++i) {
                    for (int j = -3; j < 3; ++j) {
                        for (int k = -3; k < 3; ++k) {
                            Block center;
                            BlockPos offset = blockPos.m_7918_(i, j, k);
                            BlockState state = world.m_8055_(offset);
                            Block block = state.m_60734_();
                            if (block instanceof CropBlock) {
                                CropBlock cropBlock = (CropBlock)block;
                                if (cropBlock.m_7419_() <= cropBlock.m_52305_(state) || random.nextInt(16) != 0) continue;
                                cropBlock.m_213898_(state, world, offset, player.m_217043_());
                                center = offset.m_252807_();
                                if (random.nextInt(12) != 0) continue;
                                world.m_8767_((ParticleOptions)ParticleTypes.f_123748_, center.f_82479_, center.f_82480_, center.f_82481_, 1, 0.2, 0.2, 0.2, 0.0);
                                continue;
                            }
                            center = state.m_60734_();
                            if (!(center instanceof StemBlock)) continue;
                            StemBlock stemBlock = (StemBlock)center;
                            stemBlock.m_213898_(state, world, offset, player.m_217043_());
                            center = offset.m_252807_();
                            if (random.nextInt(12) != 0) continue;
                            world.m_8767_((ParticleOptions)ParticleTypes.f_123748_, center.f_82479_, center.f_82480_, center.f_82481_, 1, 0.2, 0.2, 0.2, 0.0);
                        }
                    }
                }
            }
        }
        if (entity.f_19797_ % naturalRegenerationSpeed.getValue() == 0 && entity.m_21223_() < entity.m_21233_()) {
            entity.m_5634_(Math.max(0.5f, entity.m_21233_() / 100.0f));
        }
    }
}

