/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.HunterGuidebook;
import com.aizistral.enigmaticlegacy.items.generic.ItemBase;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

public class OdeToLiving
extends ItemBase
implements Vanishable {
    public static Omniconfig.IntParameter cooldown;
    public static Omniconfig.PerhapsParameter synergyDamageReduction;

    public OdeToLiving() {
        super(OdeToLiving.getDefaultProperties().m_41487_(1).m_41497_(Rarity.RARE));
    }

    @SubscribeConfig
    public static void onConfig(@NotNull OmniconfigWrapper builder) {
        builder.pushPrefix("OdetoLivingBeings");
        cooldown = builder.comment("Active ability cooldown for Ode to Living Beings. Measured in ticks. 20 ticks equal to 1 second.").max(32768.0).getInt("Cooldown", 1200);
        synergyDamageReduction = builder.comment("The percentage subtracted from damage redirected by Guide to Feral Hunt, if this is also possessed.").max(100.0).getPerhaps("SynergyDamageReduction", 75);
        builder.popPrefix();
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        NeutralMob neutral;
        if (target instanceof NeutralMob && (neutral = (NeutralMob)target).m_21660_() && !player.m_36335_().m_41519_((Item)this)) {
            if (!player.m_9236_().f_46443_) {
                boolean flag;
                boolean bl = flag = target instanceof Animal && neutral.m_5448_() == player;
                if (flag) {
                    neutral.m_21662_();
                }
                ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123750_, target.m_20185_(), target.m_20188_(), target.m_20189_(), 5, (double)target.m_20205_(), 0.1, (double)target.m_20205_(), 0.1);
            }
            if (!player.m_150110_().f_35937_) {
                player.m_36335_().m_41524_((Item)this, cooldown.getValue());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> list, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.livingOde1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.livingOde2");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.livingOde3");
            if (Minecraft.m_91087_().f_91074_ != null && SuperpositionHandler.isTheCursedOne((Player)Minecraft.m_91087_().f_91074_)) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.animalGuidebook4");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.animalGuidebook5");
            }
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.livingOde6");
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
    }

    @Mod.EventBusSubscriber(modid="enigmaticaddons", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class PetEvent {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onPetHurt(@NotNull LivingHurtEvent event) {
            Player player;
            LivingEntity owner;
            TamableAnimal pet;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof TamableAnimal && (pet = (TamableAnimal)livingEntity).m_21824_() && (owner = pet.m_269323_()) instanceof Player && SuperpositionHandler.hasItem((Player)(player = (Player)owner), (Item)EnigmaticItems.HUNTER_GUIDEBOOK) && SuperpositionHandler.hasItem((Player)player, (Item)EnigmaticAddonItems.LIVING_ODE) && owner.m_9236_() == pet.m_9236_() && owner.m_20270_((Entity)pet) <= (float)HunterGuidebook.effectiveDistance.getValue()) {
                event.setCanceled(true);
                owner.m_6469_(event.getSource(), event.getAmount() * synergyDamageReduction.getValue().asModifierInverted());
            }
        }
    }
}

