/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.contents.entities.ThrownIchorSpear;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBase;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class IchorSpear
extends ItemBase
implements Vanishable {
    public static final AbstractProjectileDispenseBehavior DISPENSE_BEHAVIOR = new AbstractProjectileDispenseBehavior(){

        protected Projectile m_6895_(Level level, Position position, ItemStack stack) {
            ThrownIchorSpear spear = new ThrownIchorSpear(level, position.m_7096_(), position.m_7098_(), position.m_7094_());
            spear.f_36705_ = AbstractArrow.Pickup.ALLOWED;
            return spear;
        }

        protected float m_7104_() {
            return super.m_7104_() / 1.1f;
        }

        protected void m_6823_(BlockSource source) {
            source.m_7727_().m_5594_(null, source.m_7961_(), SoundEvents.f_12520_, SoundSource.BLOCKS, 0.8f, 0.6f);
        }
    };
    public static Omniconfig.IntParameter baseDamage;
    public static Omniconfig.IntParameter duration;
    public static Omniconfig.IntParameter amplifier;

    public IchorSpear() {
        super(ItemBase.getDefaultProperties().m_41497_(Rarity.RARE));
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("IchorSpear");
        baseDamage = builder.comment("The damage of thrown ichor spear").getInt("BaseDamage", 4);
        duration = builder.comment("The duration of the ichor corrosion effect. Measures in ticks.").getInt("EffectDuration", 600);
        amplifier = builder.comment("The amplifier of the ichor corrosion effect.").min(1.0).getInt("EffectAmplifier", 1);
        builder.popPrefix();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.ichorSpear");
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int tickCount) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int duration = this.m_8105_(stack) - tickCount;
            if (duration >= 5) {
                if (!level.f_46443_) {
                    stack.m_41622_(1, (LivingEntity)player, consumer -> consumer.m_21190_(entity.m_7655_()));
                    ThrownIchorSpear spear = new ThrownIchorSpear((LivingEntity)player, level);
                    if (player.m_150110_().f_35937_) {
                        spear.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    float strength = Math.min(3.5f, (float)duration * 0.1f + 0.6f);
                    float pitch = Math.min(0.65f + (float)duration * 0.02f, 1.1f);
                    spear.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, strength, 1.0f);
                    level.m_7967_((Entity)spear);
                    level.m_6269_(null, (Entity)spear, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, pitch);
                }
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                    if (stack.m_41619_()) {
                        player.m_150109_().m_36057_(stack);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                player.m_6674_(player.m_7655_());
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemInHand);
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }
}

