/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.EnigmaticAddons;
import auviotre.enigmatic.addon.contents.entities.ThrownEvilDagger;
import auviotre.enigmatic.addon.packets.clients.PacketEvilCage;
import auviotre.enigmatic.addon.registries.EnigmaticAddonDamageTypes;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.ICursed;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBase;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class EvilDagger
extends ItemBase
implements Vanishable,
ICursed {
    public static Omniconfig.IntParameter cooldown;
    public static Omniconfig.IntParameter curseHurtInterval;
    public static Omniconfig.DoubleParameter curseHurtAmount;
    public static Omniconfig.PerhapsParameter curseDamageRatio;
    public static Omniconfig.PerhapsParameter curseModifierRatio;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    private static final Multimap<Attribute, AttributeModifier> EVIL_CURSE_MODIFIER;

    public EvilDagger() {
        super(ItemBase.getDefaultProperties().m_41486_().m_41497_(Rarity.EPIC).m_41503_(640));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 5.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-1.6f, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    @SubscribeConfig
    public static void onConfig(@NotNull OmniconfigWrapper builder) {
        builder.pushPrefix("TheCurseCarver");
        cooldown = builder.comment("The cooldown of usage. Measured as tick.").max(32768.0).min(20.0).getInt("Cooldown", 240);
        curseHurtInterval = builder.comment("The hurt interval time of cursed target. Measured as ticks.").max(40.0).min(1.0).getInt("CurseHurtInterval", 4);
        curseHurtAmount = builder.comment("The hurt damage amount of cursed target.").max(32768.0).min(0.0).getDouble("CurseHurtAmount", 2.0);
        curseDamageRatio = builder.comment("The hurt damage amount of cursed target.").max(100.0).min(10.0).getPerhaps("CurseDamageRatio", 20);
        curseModifierRatio = builder.comment("The hurt damage amount of cursed target.").max(100.0).min(10.0).getPerhaps("CurseModifierRatio", 20);
        builder.popPrefix();
    }

    public static void EvilCursing(LivingEntity entity) {
        if (entity.getPersistentData().m_128471_("EvilCrashed")) {
            entity.m_21204_().m_22178_(EVIL_CURSE_MODIFIER);
            entity.getPersistentData().m_128473_("EvilCurseThreshold");
            return;
        }
        int percent = (int)(entity.m_21223_() * 100.0f / entity.m_21233_());
        int threshold = Math.max(entity.getPersistentData().m_128451_("EvilCurseThreshold"), 1);
        Vec3 location = entity.m_20182_();
        float width = entity.m_20205_() / 2.0f;
        if (percent > threshold) {
            if (entity.f_19797_ % curseHurtInterval.getValue() == 0) {
                EnigmaticAddons.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(location.f_82479_, location.f_82480_, location.f_82481_, 64.0, entity.m_9236_().m_46472_())), (Object)new PacketEvilCage(location.f_82479_, location.f_82480_, location.f_82481_, width, entity.m_20206_(), 0));
                entity.m_6469_(entity.m_269291_().m_269298_(EnigmaticAddonDamageTypes.EVIL_CURSE, null), (float)curseHurtAmount.getValue());
                entity.m_20256_(Vec3.f_82478_);
                entity.f_19812_ = true;
            }
        } else if (percent <= threshold) {
            entity.getPersistentData().m_128379_("EvilCrashed", true);
            entity.m_20256_(new Vec3(0.0, -1.0, 0.0));
            float damage = entity.m_21233_() * curseDamageRatio.getValue().asModifier() / 5.0f;
            ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, location.f_82479_, location.f_82480_, location.f_82481_, 5, (double)width, (double)entity.m_20206_(), (double)width, 0.0);
            entity.m_6469_(entity.m_269291_().m_269298_(EnigmaticAddonDamageTypes.EVIL_CURSE, null), (float)Math.max((double)damage, curseHurtAmount.getValue() * 2.0));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.evilDagger1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.evilDagger2");
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        ItemLoreHelper.indicateCursedOnesOnly(list);
        if (stack.m_41793_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (SuperpositionHandler.isTheCursedOne((Player)player) && stack.m_41776_() > stack.m_41773_() + 80) {
            player.m_36335_().m_41524_((Item)this, player.m_150110_().f_35937_ ? 15 : cooldown.getValue());
            stack.m_41622_(80, (LivingEntity)player, consumer -> consumer.m_21190_(player.m_7655_()));
            int curseAmount = SuperpositionHandler.getCurseAmount((ItemStack)stack);
            if (!level.f_46443_) {
                ThrownEvilDagger dagger = new ThrownEvilDagger((LivingEntity)player, level);
                dagger.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.25f, 0.0f);
                dagger.m_20242_(true);
                dagger.setCurseAmount(curseAmount);
                level.m_7967_((Entity)dagger);
                for (int i = 0; i < (stack.getEnchantmentLevel(Enchantments.f_44959_) > 0 ? 4 : 2); ++i) {
                    dagger = new ThrownEvilDagger((LivingEntity)player, level);
                    dagger.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 3.0f, 9.6f);
                    dagger.m_20242_(true);
                    dagger.setCurseAmount(curseAmount);
                    level.m_7967_((Entity)dagger);
                }
            }
            player.m_6674_(hand);
            level.m_6269_(null, (Entity)player, SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 2.0f);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity entity, LivingEntity user) {
        Player player;
        stack.m_41622_(1, user, consumer -> consumer.m_21166_(EquipmentSlot.MAINHAND));
        if (user instanceof Player && SuperpositionHandler.isTheCursedOne((Player)(player = (Player)user))) {
            int curseAmount = SuperpositionHandler.getCurseAmount((ItemStack)stack);
            int threshold = entity.getPersistentData().m_128451_("EvilCurseThreshold");
            if (threshold > 0) {
                entity.getPersistentData().m_128405_("EvilCurseThreshold", Math.max(threshold - 1 - curseAmount, 1));
            }
        }
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        if (state.m_60800_((BlockGetter)level, pos) != 0.0f) {
            stack.m_41622_(2, entity, user -> user.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public boolean m_6832_(ItemStack self, ItemStack stack) {
        return stack.m_150930_((Item)EnigmaticItems.EVIL_INGOT) || super.m_6832_(self, stack);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(slot);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return (super.canApplyAtEnchantingTable(Items.f_42383_.m_7968_(), enchantment) || enchantment == Enchantments.f_44959_) && enchantment != Enchantments.f_44983_;
    }

    static {
        EVIL_CURSE_MODIFIER = ImmutableMultimap.of((Object)Attributes.f_22281_, (Object)new AttributeModifier(UUID.fromString("637f51eb-218e-46aa-bcd3-10380acfd2d6"), "Evil Curse Modifier", -0.25, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }
}

