/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.ICursed;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ExperienceHelper;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.aizistral.enigmaticlegacy.items.XPScroll;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.enigmaticlegacy.registries.EnigmaticSounds;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;

public class CursedXPScroll
extends ItemBaseCurio
implements ICursed {
    public static Omniconfig.DoubleParameter damageBoostLimit;
    public static Omniconfig.DoubleParameter speedBoostLimit;
    public static Omniconfig.DoubleParameter KRBoostLimit;
    public static Omniconfig.IntParameter XPLevelUpperLimit;

    public CursedXPScroll() {
        super(ItemBaseCurio.getDefaultProperties().m_41497_(Rarity.RARE));
    }

    @SubscribeConfig
    public static void onConfig(@NotNull OmniconfigWrapper builder) {
        builder.pushPrefix("ScrollofIgnoranceCurse");
        damageBoostLimit = builder.comment("Damage Amplification Limit of Scroll of Ignorance Curse. Defined as percentage.").max(1000.0).getDouble("DamageBoostLimit", 100.0);
        speedBoostLimit = builder.comment("Speed Amplification Limit of Scroll of Ignorance Curse. Defined as percentage.").max(1000.0).getDouble("SpeedBoostLimit", 50.0);
        KRBoostLimit = builder.comment("Knockback Resistance Limit Modifier of Scroll of Ignorance Curse. Defined as percentage.").max(1000.0).getDouble("KnockbackResistanceBoostLimit", 160.0);
        XPLevelUpperLimit = builder.comment("The Max Level of stored experience of Scroll of Ignorance Curse, which provides attribute amplification.").max(1000.0).getInt("XPLevelUpperLimit", 1000);
        builder.popPrefix();
    }

    public static int getLevel(ItemStack stack) {
        return ExperienceHelper.getLevelForExperience((int)ItemNBTHelper.getInt((ItemStack)stack, (String)"XPStored", (int)0));
    }

    public static double getLevelModifier(ItemStack stack) {
        return Mth.m_14008_((double)((double)CursedXPScroll.getLevel(stack) / (double)XPLevelUpperLimit.getValue()), (double)0.0, (double)1.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        MutableComponent cMode = !ItemNBTHelper.getBoolean((ItemStack)stack, (String)"IsActive", (boolean)false) ? Component.m_237115_((String)"tooltip.enigmaticlegacy.xpTomeDeactivated") : (ItemNBTHelper.getBoolean((ItemStack)stack, (String)"AbsorptionMode", (boolean)true) ? Component.m_237115_((String)"tooltip.enigmaticlegacy.xpTomeAbsorption") : Component.m_237115_((String)"tooltip.enigmaticlegacy.xpTomeExtraction"));
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.xpTome1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.xpTome2");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.xpTome3");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.xpTome4");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.xpTome5");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.xpTome10");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.xpTome11", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{(int)(XPScroll.xpCollectionRange.getValue() * 1.5)});
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.xpTomeMode", null, (Object[])new Object[]{cMode.getString()});
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.xpTomeStoredXP");
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.xpTomeUnits", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{ItemNBTHelper.getInt((ItemStack)stack, (String)"XPStored", (int)0), CursedXPScroll.getLevel(stack)});
        try {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.currentKeybind", (ChatFormatting)ChatFormatting.LIGHT_PURPLE, (Object[])new Object[]{((Component)KeyMapping.m_90842_((String)"key.xpScroll").get()).getString().toUpperCase()});
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (!Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.indicateCursedOnesOnly(list);
        }
        this.addAttributes(list, stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void addAttributes(List<Component> list, ItemStack stack) {
        double level = CursedXPScroll.getLevelModifier(stack);
        if (level == 0.0) {
            return;
        }
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        ItemLoreHelper.addLocalizedFormattedString(list, (String)"curios.modifiers.scroll", (ChatFormatting)ChatFormatting.GOLD);
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.damage", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{"+" + String.format("%.1f", level * damageBoostLimit.getValue()) + "%"});
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.speed", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{"+" + String.format("%.1f", level * speedBoostLimit.getValue()) + "%"});
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.knockback_resistance", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{"+" + String.format("%.1f", level * KRBoostLimit.getValue()) + "%"});
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        tooltips.clear();
        return tooltips;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand handIn) {
        ItemStack stack = player.m_21120_(handIn);
        this.trigger(world, stack, player, handIn, true);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void trigger(Level world, ItemStack stack, Player player, InteractionHand hand, boolean swing) {
        if (!player.m_6047_()) {
            if (ItemNBTHelper.getBoolean((ItemStack)stack, (String)"AbsorptionMode", (boolean)true)) {
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)"AbsorptionMode", (boolean)false);
                world.m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * (double)0.2f));
            } else {
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)"AbsorptionMode", (boolean)true);
                world.m_5594_(null, player.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * (double)0.2f));
            }
        } else if (ItemNBTHelper.getBoolean((ItemStack)stack, (String)"IsActive", (boolean)false)) {
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)"IsActive", (boolean)false);
            world.m_5594_(null, player.m_20183_(), EnigmaticSounds.CHARGED_OFF, SoundSource.PLAYERS, (float)((double)0.8f + Math.random() * (double)0.2f), (float)((double)0.8f + Math.random() * (double)0.2f));
        } else {
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)"IsActive", (boolean)true);
            world.m_5594_(null, player.m_20183_(), EnigmaticSounds.CHARGED_ON, SoundSource.PLAYERS, (float)((double)0.8f + Math.random() * (double)0.2f), (float)((double)0.8f + Math.random() * (double)0.2f));
        }
        if (swing) {
            player.m_6674_(hand);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)"IsActive", (boolean)false);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Player player;
        LivingEntity entity = slotContext.entity();
        double level = CursedXPScroll.getLevelModifier(stack);
        if (entity instanceof Player && SuperAddonHandler.isOKOne(player = (Player)entity) && level > 0.0) {
            HashMultimap attributes = HashMultimap.create();
            attributes.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(UUID.fromString("DC1A2466-36E9-A205-F278-1A8257934E09"), "Cursed XP Bonus", level / 100.0 * speedBoostLimit.getValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
            attributes.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(UUID.fromString("1413353D-4D00-953F-B40B-8A17AF92411F"), "Cursed XP Bonus", level / 100.0 * KRBoostLimit.getValue(), AttributeModifier.Operation.MULTIPLY_TOTAL));
            return attributes;
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }

    public boolean canEquip(SlotContext context, ItemStack stack) {
        if (super.canEquip(context, stack)) {
            Player player;
            LivingEntity entity = context.entity();
            return entity instanceof Player && SuperpositionHandler.isTheCursedOne((Player)(player = (Player)entity));
        }
        return false;
    }

    public void curioTick(SlotContext context, ItemStack stack) {
        ItemStack itemstack = SuperpositionHandler.getCurioStack((LivingEntity)context.entity(), (Item)EnigmaticAddonItems.CURSED_XP_SCROLL);
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!context.entity().m_9236_().f_46443_ && ItemNBTHelper.getBoolean((ItemStack)itemstack, (String)"IsActive", (boolean)false)) {
                Level world = player.m_9236_();
                int xpPortion = this.getXPPortion(player);
                if (ItemNBTHelper.getBoolean((ItemStack)itemstack, (String)"AbsorptionMode", (boolean)true)) {
                    if (ExperienceHelper.getPlayerXP((Player)player) >= xpPortion) {
                        ExperienceHelper.drainPlayerXP((Player)player, (int)xpPortion);
                        ItemNBTHelper.setInt((ItemStack)itemstack, (String)"XPStored", (int)(ItemNBTHelper.getInt((ItemStack)itemstack, (String)"XPStored", (int)0) + xpPortion));
                    } else if (ExperienceHelper.getPlayerXP((Player)player) > 0 & ExperienceHelper.getPlayerXP((Player)player) < xpPortion) {
                        exp = ExperienceHelper.getPlayerXP((Player)player);
                        ExperienceHelper.drainPlayerXP((Player)player, (int)exp);
                        ItemNBTHelper.setInt((ItemStack)itemstack, (String)"XPStored", (int)(ItemNBTHelper.getInt((ItemStack)itemstack, (String)"XPStored", (int)0) + exp));
                    }
                } else {
                    exp = ItemNBTHelper.getInt((ItemStack)itemstack, (String)"XPStored", (int)0);
                    if (exp >= xpPortion) {
                        ItemNBTHelper.setInt((ItemStack)itemstack, (String)"XPStored", (int)(exp - xpPortion));
                        ExperienceHelper.addPlayerXP((Player)player, (int)xpPortion);
                    } else if (exp > 0) {
                        ItemNBTHelper.setInt((ItemStack)itemstack, (String)"XPStored", (int)0);
                        ExperienceHelper.addPlayerXP((Player)player, (int)exp);
                    }
                }
                for (ExperienceOrb experienceOrb : world.m_45976_(ExperienceOrb.class, SuperpositionHandler.getBoundingBoxAroundEntity((Entity)player, (double)(XPScroll.xpCollectionRange.getValue() * 1.5)))) {
                    if (!experienceOrb.m_6084_()) continue;
                    player.f_36101_ = 0;
                    experienceOrb.m_6123_(player);
                }
            }
        }
    }

    public boolean canEquipFromUse(SlotContext context, ItemStack stack) {
        return false;
    }

    private int getXPPortion(Player player) {
        int level = ExperienceHelper.getPlayerXPLevel((Player)player);
        int levelXP = ExperienceHelper.getExperienceForLevel((int)(level + 1)) - ExperienceHelper.getExperienceForLevel((int)level);
        int portion = levelXP / 5;
        if (level > 100) {
            portion *= 1 + level / 100;
        }
        if (portion > 0) {
            return portion;
        }
        Objects.requireNonNull(this);
        return 5;
    }
}

