/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class AdventureCharm
extends ItemBaseCurio {
    public static Omniconfig.BooleanParameter shiftEnable;
    public static Omniconfig.DoubleParameter attackDamageModifier;
    public static Omniconfig.PerhapsParameter attackSpeedMultiplier;

    public AdventureCharm() {
        super(ItemBaseCurio.getDefaultProperties().m_41497_(Rarity.UNCOMMON));
    }

    @SubscribeConfig
    public static void onConfig(@NotNull OmniconfigWrapper builder) {
        builder.pushPrefix("EmblemofAdventurer");
        shiftEnable = builder.comment("Whether to enable Shift effect.").getBoolean("ShiftEnable", true);
        attackDamageModifier = builder.comment("The attack damage boost of Emblem of Adventurer").max(32768.0).getDouble("AttackDamageModifier", 2.0);
        attackSpeedMultiplier = builder.comment("The attack speed multiplier of Emblem of Adventurer. Measures in percentage.").max(100.0).getPerhaps("AttackSpeedMultiplier", 10);
        builder.popPrefix();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.adventureCharm1");
        if (shiftEnable.getValue()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.adventureCharm2");
        }
        if (worldIn != null && worldIn.m_6106_().m_5466_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.despairInsignia");
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        HashMultimap attributes = HashMultimap.create();
        if (slotContext.entity() instanceof Player) {
            CuriosApi.addSlotModifier((Multimap)attributes, (String)"charm", (UUID)UUID.fromString("4f9d6bf4-49b5-47ed-8796-b0c75e53aa91"), (double)1.0, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
        }
        attributes.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(UUID.fromString("6ec66ba8-46e7-487a-8bd1-82eeac5dd4ab"), "Attack Damage Bonus", attackDamageModifier.getValue(), AttributeModifier.Operation.ADDITION));
        attributes.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(UUID.fromString("131a7a69-ba19-47a7-9ad5-7ce2965a8d6b"), "Attack Speed Bonus", (double)attackSpeedMultiplier.getValue().asModifier(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        return attributes;
    }

    public boolean canEquip(SlotContext context, ItemStack stack) {
        return super.canEquip(context, stack) && !SuperpositionHandler.hasCurio((LivingEntity)context.entity(), (Item)EnigmaticAddonItems.DESPAIR_INSIGNIA);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void onEquip(SlotContext context, ItemStack prevStack, ItemStack stack) {
        Player player;
        int index = context.index();
        LivingEntity entity = context.entity();
        if (entity instanceof Player && (player = (Player)entity).m_9236_().m_6106_().m_5466_()) {
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.setEquippedCurio(context.identifier(), context.index(), EnigmaticAddonItems.DESPAIR_INSIGNIA.m_7968_()));
        }
    }
}

