/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.entities;

import auviotre.enigmatic.addon.registries.EnigmaticAddonEffects;
import auviotre.enigmatic.addon.registries.EnigmaticAddonEntities;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DragonBreathArrow
extends AbstractArrow {
    private final Set<MobEffectInstance> effects;

    public DragonBreathArrow(EntityType<? extends DragonBreathArrow> type, Level world) {
        super(type, world);
        this.m_36781_(this.m_36789_() * 2.0);
        this.effects = Sets.newHashSet();
    }

    public DragonBreathArrow(LivingEntity entity, Level world) {
        super(EnigmaticAddonEntities.DRAGON_BREATH_ARROW, entity, world);
        this.m_36781_(this.m_36789_() * 2.0);
        this.effects = Sets.newHashSet();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            Vec3 movement = this.m_20184_();
            double dx = movement.f_82479_;
            double dy = movement.f_82480_;
            double dz = movement.f_82481_;
            double length = movement.m_82553_() * 1.25;
            int i = 0;
            while ((double)i < length) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123799_, this.m_20208_(0.0) + dx * (double)i / length, this.m_20187_() + dy * (double)i / length, this.m_20262_(0.0) + dz * (double)i / length, -dx * 0.1, -dy * 0.1, -dz * 0.1);
                ++i;
            }
            if (!this.m_20068_() && !this.m_36797_()) {
                this.m_20334_(movement.f_82479_, movement.f_82480_ + 0.02, movement.f_82481_);
            }
        } else if (this.f_36703_) {
            this.summonAreaEffect();
        }
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        if (!this.m_9236_().f_46443_ && hitResult.m_6662_() == HitResult.Type.ENTITY && !this.m_150171_(((EntityHitResult)hitResult).m_82443_())) {
            this.m_146884_(this.m_20318_(0.0f).m_82549_(this.m_20184_().m_82490_(0.5)));
            this.summonAreaEffect();
        }
    }

    protected void m_5790_(EntityHitResult hitResult) {
        super.m_5790_(hitResult);
        hitResult.m_82443_().f_19802_ = 0;
    }

    private void summonAreaEffect() {
        float speed = (float)this.m_20184_().m_82553_();
        float dmg = (float)Mth.m_14165_((double)Mth.m_14008_((double)(Math.sqrt(speed) * this.m_36789_()), (double)0.0, (double)2.147483647E9)) / 4.0f;
        List entities = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(4.0, 2.0, 4.0));
        AreaEffectCloud effectCloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        Entity owner = this.m_19749_();
        if (owner instanceof LivingEntity) {
            LivingEntity livingOwner = (LivingEntity)owner;
            effectCloud.m_19718_(livingOwner);
        }
        effectCloud.m_19724_((ParticleOptions)ParticleTypes.f_123799_);
        effectCloud.m_19712_(1.5f);
        effectCloud.m_19734_(100);
        effectCloud.m_19732_(0.1f);
        effectCloud.m_146785_(-1);
        effectCloud.m_19740_(1);
        effectCloud.m_19716_(new MobEffectInstance((MobEffect)EnigmaticAddonEffects.DRAGON_BREATH_EFFECT, 1, Mth.m_14143_((float)dmg)));
        if (!this.effects.isEmpty()) {
            for (MobEffectInstance effect : this.effects) {
                MobEffectInstance effectInstance = new MobEffectInstance(effect.m_19544_(), effect.m_19557_() / 5, effect.m_19564_());
                effectCloud.m_19716_(effectInstance);
            }
        }
        if (!entities.isEmpty()) {
            for (LivingEntity entity : entities) {
                if (!(this.m_20280_((Entity)entity) < 12.0) || entity == this.m_19749_()) continue;
                effectCloud.m_6034_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                break;
            }
        }
        this.m_9236_().m_7967_((Entity)effectCloud);
        this.m_146870_();
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public void addEffect(MobEffectInstance instance) {
        this.effects.add(instance);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (!this.effects.isEmpty()) {
            ListTag tags = new ListTag();
            for (MobEffectInstance effect : this.effects) {
                tags.add((Object)effect.m_19555_(new CompoundTag()));
            }
            tag.m_128365_("CustomPotionEffects", (Tag)tags);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.effects.addAll(PotionUtils.m_43573_((CompoundTag)tag));
    }
}

