/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.structure.modifiers;

import com.legacy.structure_gel.api.config.StructureConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.world.ModifiableStructureInfo;
import net.minecraftforge.common.world.StructureModifier;

public record StructureConfigModifier(HolderLookup.RegistryLookup<Biome> biomeRegistry) implements StructureModifier
{
    public static final Map<ResourceKey<Structure>, StructureConfig> CONFIGS = new HashMap<ResourceKey<Structure>, StructureConfig>();
    public static final Codec<StructureConfigModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.retrieveRegistryLookup((ResourceKey)Registries.f_256952_).forGetter(StructureConfigModifier::biomeRegistry)).apply((Applicative)instance, StructureConfigModifier::new));

    public void modify(Holder<Structure> structure, StructureModifier.Phase phase, ModifiableStructureInfo.StructureInfo.Builder builder) {
        if (phase == StructureModifier.Phase.MODIFY) {
            Optional opKey = structure.m_203543_();
            if (opKey.isEmpty()) {
                return;
            }
            ResourceKey key = (ResourceKey)opKey.get();
            StructureConfig config = CONFIGS.get(key);
            if (config == null) {
                return;
            }
            Optional<HolderSet<Biome>> newBiomes = config.getBiomes((HolderGetter<Biome>)this.biomeRegistry);
            if (newBiomes.isPresent()) {
                builder.getStructureSettings().setBiomes(newBiomes.get());
            }
        }
    }

    public Codec<? extends StructureModifier> codec() {
        return CODEC;
    }
}

