/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StructureBlockEntity.class})
public class StructureBlockEntityMixin {
    @Inject(at={@At(value="RETURN")}, method={"detectSize"}, cancellable=true)
    private void detectSizeHook(CallbackInfoReturnable<Boolean> callback) {
        StructureBlockEntity me;
        if (!((Boolean)callback.getReturnValue()).booleanValue() && (me = (StructureBlockEntity)this).m_59908_() == StructureMode.SAVE) {
            BlockPos pos = me.m_58899_();
            BlockPos originPos = pos.m_7918_(1, 1, 1);
            Level level = me.m_58904_();
            int maxSize = 48;
            Vec3i bounds = StructureBlockEntityMixin.createBounds(level, originPos, new Vec3i(maxSize, maxSize, maxSize));
            if ((bounds = StructureBlockEntityMixin.createBounds(level, originPos, bounds)).m_123341_() > 0 && bounds.m_123342_() > 0 && bounds.m_123343_() > 0) {
                me.m_59885_(new BlockPos(1, 1, 1));
                me.m_155797_(bounds);
                me.m_6596_();
                BlockState blockstate = level.m_8055_(pos);
                level.m_7260_(pos, blockstate, blockstate, 3);
                callback.setReturnValue((Object)true);
            }
        }
    }

    private static Vec3i createBounds(Level level, BlockPos origin, Vec3i searchBounds) {
        int pz;
        int py;
        int px;
        int maxX = 0;
        block0: for (px = 0; px < searchBounds.m_123341_(); ++px) {
            for (int y = 0; y < searchBounds.m_123342_(); ++y) {
                for (int z = 0; z < searchBounds.m_123343_(); ++z) {
                    BlockPos searchPos = origin.m_7918_(px, y, z);
                    if (!level.m_8055_(searchPos).m_60795_()) continue block0;
                }
            }
        }
        maxX = px;
        int maxY = 0;
        block3: for (py = 0; py < searchBounds.m_123342_(); ++py) {
            for (int x = 0; x < maxX; ++x) {
                for (int z = 0; z < searchBounds.m_123343_(); ++z) {
                    BlockPos searchPos = origin.m_7918_(x, py, z);
                    if (!level.m_8055_(searchPos).m_60795_()) continue block3;
                }
            }
        }
        maxY = py;
        int maxZ = 0;
        block6: for (pz = 0; pz < searchBounds.m_123343_(); ++pz) {
            for (int x = 0; x < maxX; ++x) {
                for (int y = 0; y < maxY; ++y) {
                    BlockPos searchPos = origin.m_7918_(x, y, pz);
                    if (!level.m_8055_(searchPos).m_60795_()) continue block6;
                }
            }
        }
        maxZ = pz;
        return new Vec3i(maxX, maxY, maxZ);
    }
}

