/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.util;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.hash.HashingOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.FriendlyByteBuf;

public class NetworkUtil {
    public static void writeCompressedNbt(FriendlyByteBuf buff, HashFunction hashFunction, CompoundTag tag) {
        byte[] bytes;
        ByteArrayOutputStream byteArrayOutput = new ByteArrayOutputStream();
        HashingOutputStream hasingOutputStream = new HashingOutputStream(hashFunction, (OutputStream)byteArrayOutput);
        try {
            NbtIo.m_128947_((CompoundTag)tag, (OutputStream)hasingOutputStream);
            bytes = byteArrayOutput.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            bytes = new byte[]{};
        }
        buff.writeInt(bytes.length);
        if (bytes.length > 0) {
            buff.writeBytes(bytes);
        }
    }

    public static void writeCompressedNbt(FriendlyByteBuf buff, CompoundTag tag) {
        NetworkUtil.writeCompressedNbt(buff, NetworkUtil.defaultHashFunc(), tag);
    }

    public static CompoundTag readCompressedNbt(FriendlyByteBuf buff, HashFunction hashFunction, Supplier<CompoundTag> defaultVal) {
        int size = buff.readInt();
        if (size > 0) {
            byte[] bytes = new byte[size];
            buff.readBytes(bytes);
            ByteArrayInputStream byteInputStream = new ByteArrayInputStream(bytes);
            HashingInputStream hasingInput = new HashingInputStream(hashFunction, (InputStream)byteInputStream);
            try {
                return NbtIo.m_128939_((InputStream)hasingInput);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return defaultVal.get();
    }

    public static CompoundTag readCompressedNbt(FriendlyByteBuf buff, Supplier<CompoundTag> defaultVal) {
        return NetworkUtil.readCompressedNbt(buff, NetworkUtil.defaultHashFunc(), defaultVal);
    }

    public static CompoundTag readCompressedNbt(FriendlyByteBuf buff) {
        return NetworkUtil.readCompressedNbt(buff, CompoundTag::new);
    }

    private static HashFunction defaultHashFunc() {
        return Hashing.sha1();
    }
}

