/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticdelight.block.custom;

import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class PancakeBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final Integer MAX_SERVINGS = 6;
    public static final IntegerProperty SERVINGS = IntegerProperty.m_61631_((String)"servings", (int)0, (int)(MAX_SERVINGS - 1));
    public final FoodProperties foodProperties;
    protected static final VoxelShape PLATE_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    protected static final VoxelShape[] PANCAKES_SHAPES = new VoxelShape[]{Shapes.m_83148_((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83148_((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83148_((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83148_((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83148_((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0), (BooleanOp)BooleanOp.f_82695_), Shapes.m_83148_((VoxelShape)PLATE_SHAPE, (VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0), (BooleanOp)BooleanOp.f_82695_)};

    public PancakeBlock(FoodProperties foodProperties, BlockBehaviour.Properties properties) {
        super(properties);
        this.foodProperties = foodProperties;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.f_46443_) {
            if (this.consumeServing(level, pos, state, player).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
            if (player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        return this.consumeServing(level, pos, state, player);
    }

    protected InteractionResult consumeServing(Level level, BlockPos pos, BlockState state, Player playerIn) {
        int servingsTaken;
        if (!playerIn.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        if (this.foodProperties != null) {
            playerIn.m_36324_().m_38707_(this.foodProperties.m_38744_(), this.foodProperties.m_38745_());
            for (Pair pair : this.foodProperties.m_38749_()) {
                if (level.f_46443_ || pair.getFirst() == null || !(level.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                playerIn.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
        }
        if ((servingsTaken = ((Integer)state.m_61143_((Property)SERVINGS)).intValue()) < MAX_SERVINGS - 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(servingsTaken + 1)), MAX_SERVINGS - 1);
        } else {
            level.m_46961_(pos, true);
        }
        level.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return PANCAKES_SHAPES[(Integer)state.m_61143_((Property)SERVINGS)];
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SERVINGS});
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return (Integer)blockState.m_61143_((Property)SERVINGS);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }
}

