/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.enhanced_mushrooms.core.registry;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.block.BlueprintBeehiveBlock;
import com.teamabnormals.blueprint.common.block.LogBlock;
import com.teamabnormals.blueprint.common.block.chest.BlueprintChestBlock;
import com.teamabnormals.blueprint.common.block.chest.BlueprintTrappedChestBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintCeilingHangingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintStandingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintWallHangingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintWallSignBlock;
import com.teamabnormals.blueprint.core.api.BlockSetTypeRegistryHelper;
import com.teamabnormals.blueprint.core.api.WoodTypeRegistryHelper;
import com.teamabnormals.blueprint.core.util.PropertyUtil;
import com.teamabnormals.blueprint.core.util.item.CreativeModeTabContentsPopulator;
import com.teamabnormals.blueprint.core.util.registry.BlockSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.ItemSubRegistryHelper;
import com.teamaurora.enhanced_mushrooms.common.block.MushroomStemBlock;
import com.teamaurora.enhanced_mushrooms.common.block.MushroomStemReplacerBlock;
import com.teamaurora.enhanced_mushrooms.core.EnhancedMushrooms;
import com.teamaurora.enhanced_mushrooms.core.other.EMConstants;
import com.teamaurora.enhanced_mushrooms.integration.farmers_delight.EMFDCompat;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="enhanced_mushrooms", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EMBlocks {
    public static final BlockSubRegistryHelper HELPER = (BlockSubRegistryHelper)EnhancedMushrooms.REGISTRY_HELPER.getBlockSubHelper();
    public static final BlockSubRegistryHelper VANILLA_HELPER = (BlockSubRegistryHelper)EnhancedMushrooms.VANILLA_HELPER.getBlockSubHelper();
    public static final RegistryObject<Block> MUSHROOM_STEM_REPLACER = VANILLA_HELPER.createBlockNoItem("mushroom_stem", () -> new MushroomStemReplacerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50182_)));
    public static final RegistryObject<Block> STRIPPED_MUSHROOM_STEM = HELPER.createBlock("stripped_mushroom_stem", () -> new RotatedPillarBlock(EMProperties.MUSHROOM.log()));
    public static final RegistryObject<Block> STRIPPED_MUSHROOM_HYPHAE = HELPER.createBlock("stripped_mushroom_hyphae", () -> new RotatedPillarBlock(EMProperties.MUSHROOM.log()));
    public static final RegistryObject<Block> MUSHROOM_STEM = HELPER.createBlockNoItem("mushroom_stem", () -> new MushroomStemBlock((Supplier<Block>)STRIPPED_MUSHROOM_STEM, EMProperties.MUSHROOM.log()));
    public static final RegistryObject<Block> MUSHROOM_HYPHAE = HELPER.createBlock("mushroom_hyphae", () -> new LogBlock(STRIPPED_MUSHROOM_HYPHAE, EMProperties.MUSHROOM.log()));
    public static final RegistryObject<Block> MUSHROOM_PLANKS = HELPER.createBlock("mushroom_planks", () -> new Block(EMProperties.MUSHROOM.planks()));
    public static final RegistryObject<Block> MUSHROOM_STAIRS = HELPER.createBlock("mushroom_stairs", () -> new StairBlock(() -> ((Block)MUSHROOM_PLANKS.get()).m_49966_(), EMProperties.MUSHROOM.planks()));
    public static final RegistryObject<Block> MUSHROOM_SLAB = HELPER.createBlock("mushroom_slab", () -> new SlabBlock(EMProperties.MUSHROOM.planks()));
    public static final RegistryObject<Block> MUSHROOM_PRESSURE_PLATE = HELPER.createBlock("mushroom_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, EMProperties.MUSHROOM.pressurePlate(), EMProperties.MUSHROOM_BLOCK_SET));
    public static final RegistryObject<Block> MUSHROOM_BUTTON = HELPER.createBlock("mushroom_button", () -> new ButtonBlock(EMProperties.MUSHROOM.button(), EMProperties.MUSHROOM_BLOCK_SET, 30, true));
    public static final RegistryObject<Block> MUSHROOM_FENCE = HELPER.createFuelBlock("mushroom_fence", () -> new FenceBlock(EMProperties.MUSHROOM.planks()), 300);
    public static final RegistryObject<Block> MUSHROOM_FENCE_GATE = HELPER.createFuelBlock("mushroom_fence_gate", () -> new FenceGateBlock(EMProperties.MUSHROOM.planks(), EMProperties.MUSHROOM_WOOD_TYPE), 300);
    public static final RegistryObject<Block> MUSHROOM_DOOR = HELPER.createBlock("mushroom_door", () -> new DoorBlock(EMProperties.MUSHROOM.door(), EMProperties.MUSHROOM_BLOCK_SET));
    public static final RegistryObject<Block> MUSHROOM_TRAPDOOR = HELPER.createBlock("mushroom_trapdoor", () -> new TrapDoorBlock(EMProperties.MUSHROOM.trapdoor(), EMProperties.MUSHROOM_BLOCK_SET));
    public static final Pair<RegistryObject<BlueprintStandingSignBlock>, RegistryObject<BlueprintWallSignBlock>> MUSHROOM_SIGNS = HELPER.createSignBlock("mushroom", EMProperties.MUSHROOM_WOOD_TYPE, EMProperties.MUSHROOM.sign());
    public static final Pair<RegistryObject<BlueprintCeilingHangingSignBlock>, RegistryObject<BlueprintWallHangingSignBlock>> MUSHROOM_HANGING_SIGNS = HELPER.createHangingSignBlock("mushroom", EMProperties.MUSHROOM_WOOD_TYPE, EMProperties.MUSHROOM.hangingSign());
    public static final RegistryObject<Block> MUSHROOM_BOARDS = HELPER.createFuelBlock("mushroom_boards", () -> new RotatedPillarBlock(EMProperties.MUSHROOM.planks()), 300);
    public static final RegistryObject<Block> MUSHROOM_BOOKSHELF = HELPER.createFuelBlock("mushroom_bookshelf", () -> new Block(EMProperties.MUSHROOM.bookshelf()), 300);
    public static final RegistryObject<Block> CHISELED_MUSHROOM_BOOKSHELF = HELPER.createFuelBlock("chiseled_mushroom_bookshelf", () -> new ChiseledBookShelfBlock(EMProperties.MUSHROOM.chiseledBookshelf()), 300);
    public static final RegistryObject<Block> MUSHROOM_LADDER = HELPER.createFuelBlock("mushroom_ladder", () -> new LadderBlock(EMProperties.MUSHROOM.ladder()), 300);
    public static final RegistryObject<Block> MUSHROOM_BEEHIVE = HELPER.createBlock("mushroom_beehive", () -> new BlueprintBeehiveBlock(EMProperties.MUSHROOM.beehive()));
    public static final RegistryObject<BlueprintChestBlock> MUSHROOM_CHEST = HELPER.createChestBlock("mushroom", EMProperties.MUSHROOM.chest());
    public static final RegistryObject<BlueprintTrappedChestBlock> TRAPPED_MUSHROOM_CHEST = HELPER.createTrappedChestBlock("mushroom", EMProperties.MUSHROOM.chest());
    public static final RegistryObject<Block> MUSHROOM_CABINET = HELPER.createFuelBlock("mushroom_cabinet", ItemSubRegistryHelper.areModsLoaded((String[])new String[]{"farmersdelight"}) ? EMFDCompat.CABINET_SUPPLIER : () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_)), 300);

    public static void setupTabEditors() {
        CreativeModeTabContentsPopulator.mod((String)"enhanced_mushrooms").tab(CreativeModeTabs.f_256788_).addItemsBefore((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_256831_}), new Supplier[]{MUSHROOM_STEM, MUSHROOM_HYPHAE, STRIPPED_MUSHROOM_STEM, STRIPPED_MUSHROOM_HYPHAE, MUSHROOM_PLANKS}).addItemsBefore(EMBlocks.modLoaded((ItemLike)Blocks.f_256831_, "woodworks"), new Supplier[]{MUSHROOM_BOARDS}).addItemsBefore((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_256831_}), new Supplier[]{MUSHROOM_STAIRS, MUSHROOM_SLAB, MUSHROOM_FENCE, MUSHROOM_FENCE_GATE, MUSHROOM_DOOR, MUSHROOM_TRAPDOOR, MUSHROOM_PRESSURE_PLATE, MUSHROOM_BUTTON}).tab(CreativeModeTabs.f_256776_).addItemsBefore((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50695_}), new Supplier[]{MUSHROOM_STEM}).tab(CreativeModeTabs.f_256791_).addItemsBefore((Predicate)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_244433_}), new Supplier[]{(Supplier)MUSHROOM_SIGNS.getFirst(), (Supplier)MUSHROOM_HANGING_SIGNS.getFirst()});
        if (ItemSubRegistryHelper.areModsLoaded((String[])new String[]{"farmersdelight"})) {
            CreativeModeTabContentsPopulator.mod((String)"enhanced_mushrooms").predicate(EMFDCompat::fdGroupPredicate).addItemsBefore(EMBlocks.ofID(EMConstants.BAMBOO_CABINET, new String[0]), new Supplier[]{MUSHROOM_CABINET});
        }
        CreativeModeTabContentsPopulator.mod((String)"woodworks_1").tab(CreativeModeTabs.f_256791_).addItemsBefore(EMBlocks.ofID(EMConstants.BAMBOO_LADDER, new String[0]), new Supplier[]{MUSHROOM_LADDER}).addItemsBefore(EMBlocks.ofID(EMConstants.BAMBOO_BEEHIVE, new String[0]), new Supplier[]{MUSHROOM_BEEHIVE}).addItemsBefore(EMBlocks.ofID(EMConstants.BAMBOO_BOOKSHELF, new String[0]), new Supplier[]{MUSHROOM_BOOKSHELF, CHISELED_MUSHROOM_BOOKSHELF}).addItemsBefore(EMBlocks.ofID(EMConstants.BAMBOO_CLOSET, new String[0]), new Supplier[]{MUSHROOM_CHEST}).tab(CreativeModeTabs.f_257028_).addItemsBefore(EMBlocks.ofID(EMConstants.TRAPPED_BAMBOO_CLOSET, new String[0]), new Supplier[]{TRAPPED_MUSHROOM_CHEST});
    }

    public static Predicate<ItemStack> modLoaded(ItemLike item, String ... modids) {
        return stack -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}).test(stack) && BlockSubRegistryHelper.areModsLoaded((String[])modids);
    }

    public static Predicate<ItemStack> ofID(ResourceLocation location, ItemLike fallback, String ... modids) {
        return stack -> (BlockSubRegistryHelper.areModsLoaded((String[])modids) ? Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(location)}) : Ingredient.m_43929_((ItemLike[])new ItemLike[]{fallback})).test(stack);
    }

    public static Predicate<ItemStack> ofID(ResourceLocation location, String ... modids) {
        return stack -> BlockSubRegistryHelper.areModsLoaded((String[])modids) && Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(location)}).test(stack);
    }

    public static class EMProperties {
        public static final BlockSetType MUSHROOM_BLOCK_SET = BlockSetTypeRegistryHelper.register((BlockSetType)new BlockSetType("enhanced_mushrooms:mushroom"));
        public static final WoodType MUSHROOM_WOOD_TYPE = WoodTypeRegistryHelper.registerWoodType((WoodType)new WoodType("enhanced_mushrooms:mushroom", MUSHROOM_BLOCK_SET));
        public static final PropertyUtil.WoodSetProperties MUSHROOM = PropertyUtil.WoodSetProperties.builder((MapColor)MapColor.f_283919_).build();
    }
}

