/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.world.item.enchantment.serialize.entry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonSyntaxException;
import fuzs.universalenchants.world.item.enchantment.data.BuiltInEnchantmentDataManager;
import fuzs.universalenchants.world.item.enchantment.serialize.entry.IncompatibleEntry;
import fuzs.universalenchants.world.item.enchantment.serialize.entry.TypeEntry;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public abstract class DataEntry<T> {
    public abstract void dissolve(Set<T> var1) throws JsonSyntaxException;

    public abstract void serialize(JsonArray var1);

    public static Builder defaultBuilder(class_1887 enchantment) {
        Builder builder = new Builder(enchantment).add(BuiltInEnchantmentDataManager.INSTANCE.getVanillaCategory(enchantment));
        class_7923.field_41176.method_10220().filter(Predicate.not(arg_0 -> ((class_1887)enchantment).method_8188(arg_0))).filter(other -> enchantment != other).forEach(builder::add);
        return builder;
    }

    public static class Builder {
        private final class_1887 enchantment;
        private final List<DataEntry<?>> entries = Lists.newArrayList();
        private final IncompatibleEntry incompatibleEntry = new IncompatibleEntry();

        private Builder(class_1887 enchantment) {
            this.enchantment = enchantment;
            this.entries.add(this.incompatibleEntry);
        }

        public Builder add(class_1792 item) {
            return this.add(item, false);
        }

        public Builder add(class_1792 item, boolean exclude) {
            Objects.requireNonNull(item, "item for enchantment %s is null".formatted(class_7923.field_41176.method_10221((Object)this.enchantment)));
            TypeEntry.ItemEntry entry = new TypeEntry.ItemEntry(item);
            entry.setExclude(exclude);
            this.entries.add(entry);
            return this;
        }

        public Builder add(class_1886 category) {
            return this.add(category, false);
        }

        public Builder add(class_1886 category, boolean exclude) {
            Objects.requireNonNull(category, "category for enchantment %s is null".formatted(class_7923.field_41176.method_10221((Object)this.enchantment)));
            if (!BuiltInEnchantmentDataManager.INSTANCE.testVanillaCategory(category)) {
                throw new IllegalArgumentException("Cannot add custom category %s to enchantment data entry builder for %s".formatted(category, class_7923.field_41176.method_10221((Object)this.enchantment)));
            }
            TypeEntry.CategoryEntry entry = new TypeEntry.CategoryEntry(category);
            entry.setExclude(exclude);
            this.entries.add(entry);
            return this;
        }

        public Builder add(class_6862<class_1792> tag) {
            return this.add(tag, false);
        }

        public Builder add(class_6862<class_1792> tag, boolean exclude) {
            Objects.requireNonNull(tag, "tag for enchantment %s is null".formatted(class_7923.field_41176.method_10221((Object)this.enchantment)));
            TypeEntry.TagEntry entry = new TypeEntry.TagEntry(tag);
            entry.setExclude(exclude);
            this.entries.add(entry);
            return this;
        }

        public Builder add(class_1887 incompatible) {
            Objects.requireNonNull(incompatible, "incompatible enchantment for %s is null".formatted(class_7923.field_41176.method_10221((Object)this.enchantment)));
            this.incompatibleEntry.incompatibles.add(incompatible);
            return this;
        }

        public Builder remove(class_1887 incompatible) {
            Objects.requireNonNull(incompatible, "incompatible enchantment for %s is null".formatted(class_7923.field_41176.method_10221((Object)this.enchantment)));
            this.incompatibleEntry.incompatibles.remove(incompatible);
            return this;
        }

        public List<DataEntry<?>> build() {
            return ImmutableList.copyOf(this.entries);
        }
    }
}

