/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.world.item.enchantment.serialize;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fuzs.universalenchants.world.item.enchantment.data.BuiltInEnchantmentDataManager;
import fuzs.universalenchants.world.item.enchantment.serialize.entry.DataEntry;
import fuzs.universalenchants.world.item.enchantment.serialize.entry.IncompatibleEntry;
import fuzs.universalenchants.world.item.enchantment.serialize.entry.TypeEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class EnchantmentHolder {
    private final class_1887 enchantment;
    private final class_2960 id;
    private final class_1886 vanillaCategory;
    private final class_1886 category;
    private List<TypeEntry> categoryEntries;
    private IncompatibleEntry incompatibleEntry;
    @Nullable
    private Set<class_1792> items;
    @Nullable
    private Set<class_1887> incompatibles;

    public EnchantmentHolder(class_1887 enchantment) {
        this.enchantment = enchantment;
        this.vanillaCategory = BuiltInEnchantmentDataManager.INSTANCE.getVanillaCategory(enchantment);
        this.category = BuiltInEnchantmentDataManager.INSTANCE.getOrBuildCustomCategory(enchantment, this::canEnchant);
        this.id = class_7923.field_41176.method_10221((Object)enchantment);
    }

    public class_2960 id() {
        return this.id;
    }

    public void ensureInvalidated() {
        if (this.items != null || this.incompatibles != null) {
            throw new IllegalStateException("Holder for enchantment %s has not been invalidated".formatted(this.id));
        }
    }

    public void invalidate() {
        this.categoryEntries = null;
        this.incompatibleEntry = null;
        this.items = null;
        this.incompatibles = null;
        BuiltInEnchantmentDataManager.INSTANCE.setEnchantmentCategory(this.enchantment, this.vanillaCategory);
    }

    public void initializeCategoryEntries() {
        if (this.categoryEntries == null) {
            this.categoryEntries = Lists.newArrayList();
        }
    }

    public void submitAll(Collection<DataEntry<?>> dataEntries) {
        for (DataEntry<?> entry : dataEntries) {
            if (entry instanceof TypeEntry) {
                TypeEntry typeEntry = (TypeEntry)entry;
                this.submit(typeEntry);
                continue;
            }
            if (entry instanceof IncompatibleEntry) {
                IncompatibleEntry incompatibleEntry1 = (IncompatibleEntry)entry;
                this.submit(incompatibleEntry1);
                continue;
            }
            throw new IllegalStateException("Unknown data entry type %s".formatted(entry.getClass()));
        }
    }

    public void submit(TypeEntry entry) {
        Objects.requireNonNull(this.categoryEntries, "category entries for enchantment %s is null".formatted(class_7923.field_41176.method_10221((Object)this.enchantment)));
        if (!entry.isEmpty()) {
            this.categoryEntries.add(entry);
        }
    }

    public void submit(IncompatibleEntry entry) {
        if (this.incompatibleEntry != null) {
            throw new IllegalStateException("Incompatible entry on enchantment data holder for %s already set".formatted(class_7923.field_41176.method_10221((Object)this.enchantment)));
        }
        this.incompatibleEntry = entry;
    }

    public void applyEnchantmentCategory() {
        if (this.categoryEntries != null) {
            BuiltInEnchantmentDataManager.INSTANCE.setEnchantmentCategory(this.enchantment, this.category);
        }
    }

    private boolean canEnchant(class_1792 item) {
        if (this.categoryEntries != null) {
            this.dissolveItems();
            return this.items.contains(item);
        }
        return this.vanillaCategory.method_8177(item);
    }

    private void dissolveItems() {
        if (this.items == null) {
            Set include = Sets.newIdentityHashSet();
            Set exclude = Sets.newIdentityHashSet();
            Objects.requireNonNull(this.categoryEntries, "Using invalid enchantment category for enchantment %s, expected vanilla category to be used".formatted(class_7923.field_41176.method_10221((Object)this.enchantment)));
            for (TypeEntry entry : this.categoryEntries) {
                entry.dissolve(entry.isExclude() ? exclude : include);
            }
            include.removeAll(exclude);
            this.items = Collections.unmodifiableSet(include);
        }
    }

    public boolean isCompatibleWith(class_1887 other, boolean fallback) {
        if (this.incompatibleEntry != null) {
            this.dissolveIncompatibles();
            return !this.incompatibles.contains(other);
        }
        return fallback;
    }

    private void dissolveIncompatibles() {
        if (this.incompatibles == null) {
            Objects.requireNonNull(this.incompatibleEntry, "Using invalid enchantment incompatibility check for enchantment %s, expected vanilla check to be used".formatted(class_7923.field_41176.method_10221((Object)this.enchantment)));
            Set<class_1887> incompatibles = this.incompatibleEntry.incompatibles;
            incompatibles.add(this.enchantment);
            this.incompatibles = Collections.unmodifiableSet(incompatibles);
        }
    }
}

