/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.world.item.enchantment.data;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import fuzs.universalenchants.core.CommonAbstractions;
import fuzs.universalenchants.mixin.accessor.EnchantmentAccessor;
import fuzs.universalenchants.world.item.enchantment.data.AdditionalEnchantmentDataProvider;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class BuiltInEnchantmentDataManager {
    private static final class_1304[] ARMOR_SLOTS = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};
    private static final Set<class_1886> SPECIALIZED_ARMOR_CATEGORIES = ImmutableSet.of((Object)class_1886.field_9079, (Object)class_1886.field_9076, (Object)class_1886.field_9071, (Object)class_1886.field_9080);
    public static final BuiltInEnchantmentDataManager INSTANCE = new BuiltInEnchantmentDataManager();
    private final BiMap<class_1887, class_1886> customEnchantmentCategories = HashBiMap.create();
    private final Map<class_1887, class_1886> defaultEnchantmentCategories = Maps.newIdentityHashMap();
    private BiMap<class_1886, class_2960> enchantmentCategoriesIdMap;
    private int lastEnchantmentCategoriesSize;

    private BuiltInEnchantmentDataManager() {
    }

    public class_1886 getVanillaCategory(class_1887 enchantment) {
        class_1886 category = enchantment.field_9083;
        if (this.testVanillaCategory(category)) {
            return category;
        }
        category = this.defaultEnchantmentCategories.get(enchantment);
        Objects.requireNonNull(category, "vanilla category for enchantment %s is missing".formatted(class_7923.field_41176.method_10221((Object)enchantment)));
        return category;
    }

    public void setEnchantmentCategory(class_1887 enchantment, class_1886 category) {
        class_1886 currentCategory = enchantment.field_9083;
        if (this.testVanillaCategory(currentCategory)) {
            this.defaultEnchantmentCategories.put(enchantment, currentCategory);
        }
        ((EnchantmentAccessor)enchantment).universalenchants$setCategory(category);
        if (!this.testVanillaCategory(category)) {
            this.tryUnlockEnchantmentSlots(enchantment);
        }
    }

    private void tryUnlockEnchantmentSlots(class_1887 enchantment) {
        class_1886 vanillaCategory = this.defaultEnchantmentCategories.get(enchantment);
        if (SPECIALIZED_ARMOR_CATEGORIES.contains(vanillaCategory)) {
            ((EnchantmentAccessor)enchantment).universalenchants$setSlots((class_1304[])ARMOR_SLOTS.clone());
        }
        if (enchantment == class_1893.field_9097) {
            ((EnchantmentAccessor)enchantment).universalenchants$setSlots((class_1304[])class_1304.values().clone());
        }
    }

    public class_1886 getOrBuildCustomCategory(class_1887 enchantment, Predicate<class_1792> canApplyTo) {
        return (class_1886)this.customEnchantmentCategories.computeIfAbsent((Object)enchantment, enchantment1 -> CommonAbstractions.INSTANCE.createEnchantmentCategory(BuiltInEnchantmentDataManager.createCategoryName(enchantment1), canApplyTo));
    }

    private static String createCategoryName(class_1887 enchantment) {
        class_2960 id = class_7923.field_41176.method_10221((Object)enchantment);
        return AdditionalEnchantmentDataProvider.ENCHANTMENT_CATEGORY_PREFIX + "%s_%s".formatted(id.method_12836(), id.method_12832()).toUpperCase(Locale.ROOT);
    }

    public boolean testVanillaCategory(class_1886 category) {
        return !this.customEnchantmentCategories.containsValue((Object)category);
    }

    public class_1886 convertToVanillaCategory(class_1886 customCategory) {
        class_1886 vanillaCategory;
        class_1887 enchantment = (class_1887)this.customEnchantmentCategories.inverse().get((Object)customCategory);
        if (enchantment != null && (vanillaCategory = this.defaultEnchantmentCategories.get(enchantment)) != null) {
            return vanillaCategory;
        }
        return customCategory;
    }

    public BiMap<class_1886, class_2960> getEnchantmentCategoriesIdMap() {
        this.tryRebuildCategoriesIdMap();
        return this.enchantmentCategoriesIdMap;
    }

    private void tryRebuildCategoriesIdMap() {
        AdditionalEnchantmentDataProvider.INSTANCE.initialize();
        class_1886[] values = class_1886.values();
        if (this.enchantmentCategoriesIdMap == null || this.lastEnchantmentCategoriesSize != values.length) {
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            for (class_1886 category : values) {
                if (!this.testVanillaCategory(category)) continue;
                String identifier = category.name().replaceAll("\\W", "_").toLowerCase(Locale.ROOT);
                builder.put((Object)category, (Object)new class_2960(identifier));
            }
            this.enchantmentCategoriesIdMap = builder.build();
            this.lastEnchantmentCategoriesSize = values.length;
        }
    }
}

