/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.inventories.InternalInventory;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.AEColor;
import appeng.api.util.IConfigurableObject;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.core.localization.InGameTooltip;
import appeng.core.localization.PlayerMessages;
import appeng.core.localization.Tooltips;
import appeng.helpers.IConfigInvHost;
import appeng.helpers.IPriorityHost;
import appeng.hooks.AEToolItem;
import appeng.items.AEBaseItem;
import appeng.items.contents.NetworkToolMenuHost;
import appeng.items.tools.NetworkToolItem;
import appeng.items.tools.SettingsCategory;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import appeng.util.inv.PlayerInternalInventory;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_151;
import net.minecraft.class_1657;
import net.minecraft.class_1768;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class MemoryCardItem
extends AEBaseItem
implements IMemoryCard,
AEToolItem,
class_1768 {
    private static final int DEFAULT_BASE_COLOR = 0xDDDDDD;
    private static final AEColor[] DEFAULT_COLOR_CODE = new AEColor[]{AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT};

    public MemoryCardItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static Set<SettingsCategory> exportGenericSettings(Object exportFrom, class_2487 output) {
        EnumSet<SettingsCategory> exported = EnumSet.noneOf(SettingsCategory.class);
        if (exportFrom instanceof IUpgradeableObject) {
            IUpgradeableObject upgradeableObject = (IUpgradeableObject)exportFrom;
            MemoryCardItem.storeUpgrades(upgradeableObject, output);
            exported.add(SettingsCategory.UPGRADES);
        }
        if (exportFrom instanceof IConfigurableObject) {
            IConfigurableObject configurableObject = (IConfigurableObject)exportFrom;
            configurableObject.getConfigManager().writeToNBT(output);
            exported.add(SettingsCategory.SETTINGS);
        }
        if (exportFrom instanceof IPriorityHost) {
            IPriorityHost pHost = (IPriorityHost)exportFrom;
            output.method_10569("priority", pHost.getPriority());
            exported.add(SettingsCategory.PRIORITY);
        }
        if (exportFrom instanceof IConfigInvHost) {
            IConfigInvHost configInvHost = (IConfigInvHost)exportFrom;
            configInvHost.getConfig().writeToChildTag(output, "config");
            exported.add(SettingsCategory.CONFIG_INV);
        }
        return exported;
    }

    public static Set<SettingsCategory> importGenericSettings(Object importTo, class_2487 input, @Nullable class_1657 player) {
        IConfigurableObject configurableObject;
        IUpgradeableObject upgradeableObject;
        EnumSet<SettingsCategory> imported = EnumSet.noneOf(SettingsCategory.class);
        if (player != null && importTo instanceof IUpgradeableObject && MemoryCardItem.restoreUpgrades(player, input, upgradeableObject = (IUpgradeableObject)importTo)) {
            imported.add(SettingsCategory.UPGRADES);
        }
        if (importTo instanceof IConfigurableObject && (configurableObject = (IConfigurableObject)importTo).getConfigManager().readFromNBT(input)) {
            imported.add(SettingsCategory.SETTINGS);
        }
        if (importTo instanceof IPriorityHost) {
            IPriorityHost pHost = (IPriorityHost)importTo;
            if (input.method_10573("priority", 3)) {
                pHost.setPriority(input.method_10550("priority"));
                imported.add(SettingsCategory.PRIORITY);
            }
        }
        if (importTo instanceof IConfigInvHost) {
            IConfigInvHost configInvHost = (IConfigInvHost)importTo;
            if (input.method_10545("config")) {
                configInvHost.getConfig().readFromChildTag(input, "config");
                imported.add(SettingsCategory.CONFIG_INV);
            }
        }
        return imported;
    }

    public static void importGenericSettingsAndNotify(Object importTo, class_2487 input, @Nullable class_1657 player) {
        Set<SettingsCategory> imported = MemoryCardItem.importGenericSettings(importTo, input, player);
        if (player != null && !player.method_5770().method_8608()) {
            if (imported.isEmpty()) {
                player.method_7353((class_2561)PlayerMessages.InvalidMachine.text(), true);
            } else {
                class_2561 restored = Tooltips.conjunction(imported.stream().map(SettingsCategory::getLabel).toList());
                player.method_7353((class_2561)PlayerMessages.InvalidMachinePartiallyRestored.text(restored), true);
            }
        }
    }

    private static void storeUpgrades(IUpgradeableObject upgradeableObject, class_2487 output) {
        class_2487 desiredUpgradesTag = new class_2487();
        for (class_1799 upgrade : upgradeableObject.getUpgrades()) {
            class_2960 itemId = class_7923.field_41178.method_10221((Object)upgrade.method_7909());
            if (itemId.equals((Object)class_7923.field_41178.method_10137())) {
                AELog.warn("Cannot save unregistered upgrade to memory card %s", upgrade.method_7909());
                continue;
            }
            String key = itemId.toString();
            desiredUpgradesTag.method_10569(key, desiredUpgradesTag.method_10550(key) + upgrade.method_7947());
        }
        output.method_10566("upgrades", (class_2520)desiredUpgradesTag);
    }

    private static boolean restoreUpgrades(class_1657 player, class_2487 input, IUpgradeableObject upgradeableObject) {
        if (!input.method_10573("upgrades", 10)) {
            return false;
        }
        class_2487 desiredUpgradesTag = input.method_10562("upgrades");
        IdentityHashMap<class_1792, Integer> desiredUpgrades = new IdentityHashMap<class_1792, Integer>();
        for (String itemIdStr : desiredUpgradesTag.method_10541()) {
            class_2960 itemId;
            try {
                itemId = new class_2960(itemIdStr);
            }
            catch (class_151 e) {
                AELog.warn("Memory card contains invalid item id %s", itemIdStr);
                continue;
            }
            class_1792 item = class_7923.field_41178.method_17966(itemId).orElse(null);
            if (item == null) {
                AELog.warn("Memory card contains unknown item id %s", itemId);
                continue;
            }
            int desiredCount = desiredUpgradesTag.method_10550(itemIdStr);
            if (desiredCount <= 0) continue;
            desiredUpgrades.put(item, desiredCount);
        }
        IUpgradeInventory upgrades = upgradeableObject.getUpgrades();
        if (player.method_31549().field_7477) {
            for (int i = 0; i < upgrades.size(); ++i) {
                upgrades.setItemDirect(i, class_1799.field_8037);
            }
            for (Map.Entry entry : desiredUpgrades.entrySet()) {
                upgrades.addItems(new class_1799((class_1935)entry.getKey(), ((Integer)entry.getValue()).intValue()));
            }
            return true;
        }
        ArrayList<InternalInventory> upgradeSources = new ArrayList<InternalInventory>();
        upgradeSources.add(new PlayerInternalInventory(player.method_31548()));
        NetworkToolMenuHost networkTool = NetworkToolItem.findNetworkToolInv(player);
        if (networkTool != null) {
            upgradeSources.add(networkTool.getInventory());
        }
        for (int i = 0; i < upgrades.size(); ++i) {
            class_1799 current = upgrades.getStackInSlot(i);
            if (current.method_7960()) continue;
            Integer desiredCount = desiredUpgrades.getOrDefault(current.method_7909(), 0);
            int totalInstalled = upgradeableObject.getInstalledUpgrades((class_1935)current.method_7909());
            int toRemove = totalInstalled - desiredCount;
            if (toRemove <= 0) continue;
            class_1799 removed = upgrades.extractItem(i, toRemove, false);
            for (InternalInventory upgradeSource : upgradeSources) {
                if (removed.method_7960()) continue;
                removed = upgradeSource.addItems(removed);
            }
            if (removed.method_7960()) continue;
            player.method_7328(removed, false);
        }
        for (Map.Entry entry : desiredUpgrades.entrySet()) {
            int missingAmount = (Integer)entry.getValue() - upgradeableObject.getInstalledUpgrades((class_1935)entry.getKey());
            if (missingAmount <= 0) continue;
            class_1799 potential = new class_1799((class_1935)entry.getKey(), missingAmount);
            class_1799 overflow = upgrades.addItems(potential, true);
            if (!overflow.method_7960()) {
                missingAmount -= overflow.method_7947();
            }
            for (InternalInventory upgradeSource : upgradeSources) {
                class_1799 cards = upgradeSource.removeItems(missingAmount, potential, null);
                if (!cards.method_7960()) {
                    overflow = upgrades.addItems(cards);
                    if (!overflow.method_7960()) {
                        player.method_31548().method_7398(overflow);
                    }
                    missingAmount -= cards.method_7947();
                }
                if (missingAmount > 0) continue;
                break;
            }
            if (missingAmount <= 0 || player.method_37908().method_8608()) continue;
            player.method_7353((class_2561)PlayerMessages.MissingUpgrades.text(((class_1792)entry.getKey()).method_7848(), missingAmount), true);
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> lines, class_1836 advancedTooltips) {
        String firstLineKey = this.getFirstValidTranslationKey(this.getSettingsName(stack) + ".name", this.getSettingsName(stack));
        lines.add((class_2561)Tooltips.of((class_2561)class_2561.method_43471((String)firstLineKey)));
        class_2487 data = this.getData(stack);
        if (data.method_10545("tooltip")) {
            String tooltipKey = this.getFirstValidTranslationKey(data.method_10558("tooltip") + ".name", data.method_10558("tooltip"));
            lines.add((class_2561)Tooltips.of((class_2561)class_2561.method_43471((String)tooltipKey)));
        }
        if (data.method_10545("p2pFreq")) {
            short freq = data.method_10568("p2pFreq");
            class_5250 freqTooltip = Platform.p2p().toColoredHexString(freq).method_27692(class_124.field_1067);
            lines.add((class_2561)Tooltips.of((class_2561)class_2561.method_43469((String)InGameTooltip.P2PFrequency.getTranslationKey(), (Object[])new Object[]{freqTooltip})));
        }
    }

    private String getFirstValidTranslationKey(String ... name) {
        for (String n3 : name) {
            if (!class_1074.method_4663((String)n3)) continue;
            return n3;
        }
        int n = 0;
        String[] stringArray = name;
        int n2 = stringArray.length;
        if (n < n2) {
            String n3;
            n3 = stringArray[n];
            return n3;
        }
        return "";
    }

    @Override
    public void setMemoryCardContents(class_1799 is, String settingsName, class_2487 data) {
        class_2487 c = is.method_7948();
        c.method_10582("Config", settingsName);
        c.method_10566("Data", (class_2520)data);
    }

    @Override
    public String getSettingsName(class_1799 is) {
        class_2487 c = is.method_7948();
        String name = c.method_10558("Config");
        return name.isEmpty() ? GuiText.Blank.getTranslationKey() : name;
    }

    @Override
    public class_2487 getData(class_1799 is) {
        class_2487 c = is.method_7948();
        class_2487 o = c.method_10562("Data");
        return o.method_10553();
    }

    @Override
    public AEColor[] getColorCode(class_1799 is) {
        class_2487 tag = this.getData(is);
        if (tag.method_10573("colorCode", 11)) {
            int[] frequency = tag.method_10561("colorCode");
            AEColor[] colorArray = AEColor.values();
            if (frequency.length == 8) {
                return new AEColor[]{colorArray[frequency[0]], colorArray[frequency[1]], colorArray[frequency[2]], colorArray[frequency[3]], colorArray[frequency[4]], colorArray[frequency[5]], colorArray[frequency[6]], colorArray[frequency[7]]};
            }
        }
        return DEFAULT_COLOR_CODE;
    }

    @Override
    public void notifyUser(class_1657 player, MemoryCardMessages msg) {
        if (player.method_5770().method_8608()) {
            return;
        }
        switch (msg) {
            case SETTINGS_CLEARED: {
                player.method_7353((class_2561)PlayerMessages.SettingCleared.text(), true);
                break;
            }
            case INVALID_MACHINE: {
                player.method_7353((class_2561)PlayerMessages.InvalidMachine.text(), true);
                break;
            }
            case SETTINGS_LOADED: {
                player.method_7353((class_2561)PlayerMessages.LoadedSettings.text(), true);
                break;
            }
            case SETTINGS_SAVED: {
                player.method_7353((class_2561)PlayerMessages.SavedSettings.text(), true);
                break;
            }
            case SETTINGS_RESET: {
                player.method_7353((class_2561)PlayerMessages.ResetSettings.text(), true);
                break;
            }
        }
    }

    @Override
    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        class_1657 player = context.method_8036();
        if (player != null && InteractionUtil.isInAlternateUseMode(player)) {
            class_2680 state;
            class_1269 useResult;
            class_1937 level = context.method_8045();
            if (!level.method_8608() && !(useResult = (state = context.method_8045().method_8320(context.method_8037())).method_26174(context.method_8045(), context.method_8036(), context.method_20287(), new class_3965(context.method_17698(), context.method_8038(), context.method_8037(), context.method_17699()))).method_23665()) {
                this.clearCard(context.method_8036(), context.method_8045(), context.method_20287());
            }
            return class_1269.method_29236((boolean)level.method_8608());
        }
        return class_1269.field_5811;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        if (InteractionUtil.isInAlternateUseMode(player) && !level.field_9236) {
            this.clearCard(player, level, hand);
        }
        return super.method_7836(level, player, hand);
    }

    private void clearCard(class_1657 player, class_1937 level, class_1268 hand) {
        IMemoryCard mem = (IMemoryCard)player.method_5998(hand).method_7909();
        mem.notifyUser(player, MemoryCardMessages.SETTINGS_CLEARED);
        player.method_5998(hand).method_7980(null);
    }

    public int method_7800(class_1799 stack) {
        class_2487 compoundTag = stack.method_7941("display");
        if (compoundTag != null && compoundTag.method_10573("color", 99)) {
            return compoundTag.method_10550("color");
        }
        return 0xDDDDDD;
    }

    public static int getTintColor(class_1799 stack, int tintIndex) {
        class_1792 class_17922;
        if (tintIndex == 1 && (class_17922 = stack.method_7909()) instanceof MemoryCardItem) {
            MemoryCardItem memoryCard = (MemoryCardItem)class_17922;
            return memoryCard.method_7800(stack);
        }
        return 0xFFFFFF;
    }
}

