/*
 * Decompiled with CFR 0.152.
 */
package appeng.init.client;

import appeng.api.client.AEKeyRenderHandler;
import appeng.api.client.AEKeyRendering;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKeyType;
import appeng.client.gui.style.FluidBlitter;
import appeng.util.Platform;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_811;
import org.joml.Matrix4f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitStackRenderHandlers {
    private static final Logger LOG = LoggerFactory.getLogger(InitStackRenderHandlers.class);

    private InitStackRenderHandlers() {
    }

    public static void init() {
        AEKeyRendering.register(AEKeyType.items(), AEItemKey.class, new ItemKeyRenderHandler());
        AEKeyRendering.register(AEKeyType.fluids(), AEFluidKey.class, new FluidKeyRenderHandler());
    }

    private static class ItemKeyRenderHandler
    implements AEKeyRenderHandler<AEItemKey> {
        private ItemKeyRenderHandler() {
        }

        @Override
        public void drawInGui(class_310 minecraft, class_332 guiGraphics, int x, int y, AEItemKey stack) {
            class_4587 poseStack = guiGraphics.method_51448();
            poseStack.method_22903();
            class_1799 displayStack = stack.toStack();
            guiGraphics.method_51427(displayStack, x, y);
            guiGraphics.method_51432(minecraft.field_1772, displayStack, x, y, "");
            poseStack.method_22909();
        }

        @Override
        public void drawOnBlockFace(class_4587 poseStack, class_4597 buffers, AEItemKey what, float scale, int combinedLight, class_1937 level) {
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.0f, 0.01f);
            poseStack.method_34425(new Matrix4f().scale(scale, scale, 0.001f));
            poseStack.method_23760().method_23762().rotateX(-0.7853982f);
            class_310.method_1551().method_1480().method_23178(what.toStack(), class_811.field_4317, combinedLight, class_4608.field_21444, poseStack, buffers, level, 0);
            poseStack.method_22909();
        }

        @Override
        public class_2561 getDisplayName(AEItemKey stack) {
            return stack.toStack().method_7964();
        }

        @Override
        public List<class_2561> getTooltip(AEItemKey stack) {
            try {
                return stack.toStack().method_7950((class_1657)class_310.method_1551().field_1724, (class_1836)(class_310.method_1551().field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070));
            }
            catch (Exception e) {
                LOG.error("Getting the tooltip of item {} crashed!", (Object)stack.getId(), (Object)e);
                return List.of(stack.getDisplayName(), class_2561.method_43470((String)stack.getId().toString()), class_2561.method_43470((String)"GETTING TOOLTIP CRASHED").method_27692(class_124.field_1061));
            }
        }
    }

    private static class FluidKeyRenderHandler
    implements AEKeyRenderHandler<AEFluidKey> {
        private FluidKeyRenderHandler() {
        }

        @Override
        public void drawInGui(class_310 minecraft, class_332 guiGraphics, int x, int y, AEFluidKey what) {
            FluidBlitter.create(what).dest(x, y, 16, 16).blit(guiGraphics);
        }

        @Override
        public void drawOnBlockFace(class_4587 poseStack, class_4597 buffers, AEFluidKey what, float scale, int combinedLight, class_1937 level) {
            FluidVariant variant = what.toVariant();
            int color = FluidVariantRendering.getColor((FluidVariant)variant);
            class_1058 sprite = FluidVariantRendering.getSprite((FluidVariant)variant);
            if (sprite == null) {
                return;
            }
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.0f, 0.01f);
            class_4588 buffer = buffers.getBuffer(class_1921.method_23577());
            float x0 = -(scale -= 0.05f) / 2.0f;
            float y0 = scale / 2.0f;
            float x1 = scale / 2.0f;
            float y1 = -scale / 2.0f;
            Matrix4f transform = poseStack.method_23760().method_23761();
            buffer.method_22918(transform, x0, y1, 0.0f).method_39415(color).method_22913(sprite.method_4594(), sprite.method_4575()).method_22922(class_4608.field_21444).method_22916(combinedLight).method_22914(0.0f, 0.0f, 1.0f).method_1344();
            buffer.method_22918(transform, x1, y1, 0.0f).method_39415(color).method_22913(sprite.method_4577(), sprite.method_4575()).method_22922(class_4608.field_21444).method_22916(combinedLight).method_22914(0.0f, 0.0f, 1.0f).method_1344();
            buffer.method_22918(transform, x1, y0, 0.0f).method_39415(color).method_22913(sprite.method_4577(), sprite.method_4593()).method_22922(class_4608.field_21444).method_22916(combinedLight).method_22914(0.0f, 0.0f, 1.0f).method_1344();
            buffer.method_22918(transform, x0, y0, 0.0f).method_39415(color).method_22913(sprite.method_4594(), sprite.method_4593()).method_22922(class_4608.field_21444).method_22916(combinedLight).method_22914(0.0f, 0.0f, 1.0f).method_1344();
            poseStack.method_22909();
        }

        @Override
        public class_2561 getDisplayName(AEFluidKey stack) {
            return FluidVariantAttributes.getName((FluidVariant)stack.toVariant());
        }

        @Override
        public List<class_2561> getTooltip(AEFluidKey stack) {
            List tooltip = FluidVariantRendering.getTooltip((FluidVariant)stack.toVariant());
            String modName = Platform.formatModName(stack.getModId());
            if (tooltip.isEmpty() || !((class_2561)tooltip.get(tooltip.size() - 1)).getString().equals(modName)) {
                tooltip.add(class_2561.method_43470((String)modName));
            }
            return tooltip;
        }
    }
}

