/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.network;

import appeng.core.AppEng;
import appeng.core.sync.BasePacket;
import appeng.core.sync.BasePacketHandler;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.network.NetworkHandlerHolder;
import appeng.core.sync.network.TargetPoint;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class ServerNetworkHandler
implements NetworkHandler {
    public ServerNetworkHandler() {
        NetworkHandlerHolder.INSTANCE = this;
        ServerPlayNetworking.registerGlobalReceiver((class_2960)BasePacket.CHANNEL, this::handlePacketFromClient);
    }

    @Override
    public void sendToAll(BasePacket message) {
        MinecraftServer server = AppEng.instance().getCurrentServer();
        if (server != null) {
            class_2540 payload = message.getPayload();
            PlayerLookup.all((MinecraftServer)server).forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)BasePacket.CHANNEL, (class_2540)payload));
        }
    }

    @Override
    public void sendTo(BasePacket message, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)BasePacket.CHANNEL, (class_2540)message.getPayload());
    }

    @Override
    public void sendToAllAround(BasePacket message, TargetPoint point) {
        class_2540 payload = message.getPayload();
        PlayerLookup.around((class_3218)((class_3218)point.level), (class_243)new class_243(point.x, point.y, point.z), (double)point.radius).forEach(player -> {
            if (player != point.excluded) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)BasePacket.CHANNEL, (class_2540)payload);
            }
        });
    }

    @Override
    public void sendToDimension(BasePacket message, class_1937 world) {
        class_2540 payload = message.getPayload();
        PlayerLookup.world((class_3218)((class_3218)world)).forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)BasePacket.CHANNEL, (class_2540)payload));
    }

    @Override
    public void sendToServer(BasePacket message) {
        throw new IllegalStateException("Cannot send packets to the server when we're the server!");
    }

    private void handlePacketFromClient(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 payload, PacketSender responseSender) {
        int packetType = payload.readInt();
        BasePacket pack = BasePacketHandler.PacketTypes.getPacket(packetType).parsePacket(payload);
        server.execute(() -> pack.serverPacketData(player));
    }
}

