/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.scene;

import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.compiler.tags.BlockTagCompiler;
import appeng.client.guidebook.compiler.tags.MdxAttrs;
import appeng.client.guidebook.document.block.LytBlockContainer;
import appeng.client.guidebook.scene.CameraSettings;
import appeng.client.guidebook.scene.GuidebookScene;
import appeng.client.guidebook.scene.LytGuidebookScene;
import appeng.client.guidebook.scene.PerspectivePreset;
import appeng.client.guidebook.scene.level.GuidebookLevel;
import appeng.libs.mdast.mdx.model.MdxJsxElementFields;
import appeng.libs.mdast.model.MdAstNode;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;

public class BlockImageTagCompiler
extends BlockTagCompiler {
    public static final String TAG_NAME = "BlockImage";

    @Override
    public Set<String> getTagNames() {
        return Set.of(TAG_NAME);
    }

    @Override
    protected void compile(PageCompiler compiler, LytBlockContainer parent, MdxJsxElementFields el) {
        Pair<class_2960, class_2248> pair = MdxAttrs.getRequiredBlockAndId(compiler, parent, el, "id");
        if (pair == null) {
            return;
        }
        float scale = MdxAttrs.getFloat(compiler, parent, el, "scale", 1.0f);
        PerspectivePreset perspective = MdxAttrs.getEnum(compiler, parent, el, "perspective", PerspectivePreset.ISOMETRIC_NORTH_EAST);
        if (perspective == null) {
            return;
        }
        class_2680 state = ((class_2248)pair.getRight()).method_9564();
        state = MdxAttrs.applyBlockStateProperties(compiler, parent, el, state);
        GuidebookLevel level = new GuidebookLevel();
        CameraSettings cameraSettings = new CameraSettings();
        cameraSettings.setZoom(scale);
        cameraSettings.setPerspectivePreset(perspective);
        GuidebookScene scene = new GuidebookScene(level, cameraSettings);
        level.method_8501(class_2338.field_10980, state);
        scene.centerScene();
        LytGuidebookScene lytScene = new LytGuidebookScene(compiler.getExtensions());
        lytScene.setScene(scene);
        lytScene.setInteractive(false);
        lytScene.setSourceNode((MdAstNode)((Object)el));
        parent.append(lytScene);
    }
}

