/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.gui.style.Blitter;
import appeng.client.gui.widgets.ITooltip;
import appeng.core.localization.GuiText;
import appeng.menu.interfaces.IProgressProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5250;
import net.minecraft.class_6382;
import net.minecraft.class_768;

public class ProgressBar
extends class_339
implements ITooltip {
    private final IProgressProvider source;
    private final Blitter blitter;
    private final Direction layout;
    private final class_768 sourceRect;
    private final class_2561 titleName;
    private class_2561 fullMsg;

    public ProgressBar(IProgressProvider source, Blitter blitter, Direction dir) {
        this(source, blitter, dir, null);
    }

    public ProgressBar(IProgressProvider source, Blitter blitter, Direction dir, class_2561 title) {
        super(0, 0, blitter.getSrcWidth(), blitter.getSrcHeight(), (class_2561)class_2561.method_43473());
        this.source = source;
        this.blitter = blitter.copy();
        this.layout = dir;
        this.titleName = title;
        this.sourceRect = new class_768(blitter.getSrcX(), blitter.getSrcY(), blitter.getSrcWidth(), blitter.getSrcHeight());
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.field_22764) {
            int max = this.source.getMaxProgress();
            int current = this.source.getCurrentProgress();
            if (current > max) {
                current = max;
            }
            int srcX = this.sourceRect.method_3321();
            int srcY = this.sourceRect.method_3322();
            int srcW = this.sourceRect.method_3319();
            int srcH = this.sourceRect.method_3320();
            int destX = this.method_46426();
            int destY = this.method_46427();
            if (this.layout == Direction.VERTICAL) {
                int diff = this.field_22759 - (max > 0 ? this.field_22759 * current / max : 0);
                destY += diff;
                srcY += diff;
                srcH -= diff;
            } else {
                int diff = this.field_22758 - (max > 0 ? this.field_22758 * current / max : 0);
                srcX += diff;
                srcW -= diff;
            }
            this.blitter.src(srcX, srcY, srcW, srcH).dest(destX, destY).blit(guiGraphics);
        }
    }

    public void setFullMsg(class_2561 msg) {
        this.fullMsg = msg;
    }

    @Override
    public List<class_2561> getTooltipMessage() {
        if (this.fullMsg != null) {
            return Collections.singletonList(this.fullMsg);
        }
        class_5250 result = this.titleName != null ? this.titleName : class_2561.method_43473();
        return Arrays.asList(result, class_2561.method_43470((String)(this.source.getCurrentProgress() + " ")).method_10852((class_2561)GuiText.Of.text().method_27661().method_27693(" " + this.source.getMaxProgress())));
    }

    @Override
    public class_768 getTooltipArea() {
        return new class_768(this.method_46426() - 2, this.method_46427() - 2, this.field_22758 + 4, this.field_22759 + 4);
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return true;
    }

    public void method_47399(class_6382 output) {
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

