/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.networking;

import appeng.api.networking.energy.IPassiveEnergyGenerator;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.core.AEConfig;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class CrystalResonanceGeneratorBlockEntity
extends AENetworkBlockEntity {
    private boolean suppressed;

    public CrystalResonanceGeneratorBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setIdlePowerUsage(0.0);
        this.getMainNode().addService(IPassiveEnergyGenerator.class, new IPassiveEnergyGenerator(){

            @Override
            public double getRate() {
                return AEConfig.instance().getCrystalResonanceGeneratorRate();
            }

            @Override
            public boolean isSuppressed() {
                return CrystalResonanceGeneratorBlockEntity.this.suppressed;
            }

            @Override
            public void setSuppressed(boolean suppressed) {
                if (suppressed != CrystalResonanceGeneratorBlockEntity.this.suppressed) {
                    CrystalResonanceGeneratorBlockEntity.this.suppressed = suppressed;
                    CrystalResonanceGeneratorBlockEntity.this.markForUpdate();
                }
            }
        });
    }

    public boolean isSuppressed() {
        return this.suppressed;
    }

    @Override
    protected boolean readFromStream(class_2540 data) {
        super.readFromStream(data);
        this.suppressed = data.readBoolean();
        return false;
    }

    @Override
    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeBoolean(this.suppressed);
    }

    @Override
    protected void saveVisualState(class_2487 data) {
        super.saveVisualState(data);
        data.method_10556("suppressed", this.suppressed);
    }

    @Override
    protected void loadVisualState(class_2487 data) {
        super.loadVisualState(data);
        this.suppressed = data.method_10577("suppressed");
    }

    @Override
    public Set<class_2350> getGridConnectableSides(BlockOrientation orientation) {
        return EnumSet.of(orientation.getSide(RelativeSide.BACK));
    }

    @Override
    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.SMART;
    }
}

