/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.util.SimpleBlockPredicate;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2541;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3746;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class NetherVinesFeature
extends class_3031<class_3111> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> world.method_8320(pos).method_26204() == class_2246.field_10515;
    protected SimpleBlockPredicate replace = (world, pos) -> NetherVinesFeature.isAir((class_3746)world, pos);
    int minHeight = 8;
    int maxHeight = 20;

    public NetherVinesFeature(Codec<class_3111> deserializer) {
        super(deserializer);
    }

    public boolean method_13151(class_5821<class_3111> featurePlaceContext) {
        class_5281 world = featurePlaceContext.method_33652();
        class_2794 chunkGenerator = featurePlaceContext.method_33653();
        class_5819 rand = featurePlaceContext.method_33654();
        class_2338 startPos = featurePlaceContext.method_33655();
        class_3111 config = (class_3111)featurePlaceContext.method_33656();
        while (startPos.method_10264() >= world.method_31607() + 1 && this.replace.matches(world, startPos)) {
            startPos = startPos.method_10074();
        }
        if (!this.placeOn.matches(world, startPos.method_10069(2, 0, 2))) {
            return false;
        }
        for (int i = 0; i < 128; ++i) {
            class_2338 genPos = startPos.method_10069(rand.method_43048(4) - rand.method_43048(4), rand.method_43048(3) - rand.method_43048(3), rand.method_43048(4) - rand.method_43048(4));
            if (!this.replace.matches(world, genPos) || !this.placeOn.matches(world, genPos.method_10084())) continue;
            class_2680 vineState = BOPBlocks.WILLOW_VINE.method_9564();
            ArrayList validDirections = Lists.newArrayList();
            for (class_2350 facing : class_2350.values()) {
                if (facing == class_2350.field_11036 || facing == class_2350.field_11033 || !this.placeOn.matches(world, genPos.method_10093(facing))) continue;
                validDirections.add(facing);
            }
            if (validDirections.isEmpty()) continue;
            class_2350 direction = (class_2350)validDirections.get(rand.method_43048(validDirections.size()));
            vineState = (class_2680)vineState.method_11657((class_2769)class_2541.method_10828((class_2350)direction), (Comparable)Boolean.valueOf(true));
            int targetHeight = this.minHeight + rand.method_43048(this.maxHeight);
            for (int height = 0; height <= targetHeight; ++height) {
                class_2338 offsetPos = genPos.method_10087(height);
                if (!this.replace.matches(world, offsetPos) || !vineState.method_26204().method_9558(vineState, (class_4538)world, offsetPos)) {
                    return false;
                }
                world.method_8652(offsetPos, vineState, 2);
            }
        }
        return true;
    }

    public boolean setBlock(class_5281 world, class_2338 pos, class_2680 state) {
        if (this.replace.matches(world, pos)) {
            super.method_13153((class_1945)world, pos, state);
            return true;
        }
        return false;
    }

    public static boolean isAir(class_3746 level, class_2338 pos) {
        return level.method_16358(pos, class_4970.class_4971::method_26215);
    }
}

