/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.impl.AccessoriesTags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1890.class})
public abstract class EnchantmentHelperMixin {
    @WrapOperation(method={"getEnchantmentLevel(Lnet/minecraft/world/item/enchantment/Enchantment;Lnet/minecraft/world/entity/LivingEntity;)I"}, at={@At(value="INVOKE", target="Ljava/util/Map;values()Ljava/util/Collection;")})
    private static Collection<class_1799> addAccessoriesStacks(Map instance, Operation<Collection<class_1799>> original, @Local(argsOnly=true) class_1887 enchantment, @Local(argsOnly=true) class_1309 entity) {
        ArrayList<class_1799> returnValue = new ArrayList<class_1799>((Collection)original.call(new Object[]{instance}));
        AccessoriesCapability capability = entity.accessoriesCapability();
        if (capability != null) {
            returnValue.addAll(capability.getAllEquipped().stream().map(SlotEntryReference::stack).toList());
        }
        return returnValue;
    }

    @WrapOperation(method={"getRandomItemWith(Lnet/minecraft/world/item/enchantment/Enchantment;Lnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Predicate;)Ljava/util/Map$Entry;"}, at={@At(value="INVOKE", target="Ljava/util/Map;isEmpty()Z")})
    private static boolean wrapMapCheck(Map instance, Operation<Boolean> original, class_1887 enchantment, class_1309 livingEntity, Predicate<class_1799> stackCondition, @Share(value="slotEntries") LocalRef<List<SlotEntryReference>> slotEntries) {
        Boolean bl = (Boolean)original.call(new Object[]{instance});
        if (EnchantmentHelperMixin.enchantmentValidForRedirect(enchantment) && livingEntity.accessoriesCapability() != null) {
            List<SlotEntryReference> allEquippedAccessories = livingEntity.accessoriesCapability().getAllEquipped().stream().filter(entryReference -> {
                class_1799 stack = entryReference.stack();
                int level = class_1890.method_8225((class_1887)enchantment, (class_1799)stack);
                return level > 0 && stackCondition.test(stack);
            }).toList();
            slotEntries.set(allEquippedAccessories);
            bl = bl != false && allEquippedAccessories.isEmpty();
        } else {
            slotEntries.set(List.of());
        }
        return bl;
    }

    @Inject(method={"getRandomItemWith(Lnet/minecraft/world/item/enchantment/Enchantment;Lnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Predicate;)Ljava/util/Map$Entry;"}, at={@At(value="INVOKE", target="Ljava/util/List;isEmpty()Z", shift=At.Shift.BEFORE)}, cancellable=true)
    private static void attemptRedirectToAccessories(class_1887 enchantment, class_1309 livingEntity, Predicate<class_1799> stackCondition, CallbackInfoReturnable<@Nullable Map.Entry<class_1304, class_1799>> cir, @Local(ordinal=0) List<Map.Entry<class_1304, class_1799>> list, @Share(value="slotEntries") LocalRef<List<SlotEntryReference>> slotEntries) {
        if (!EnchantmentHelperMixin.enchantmentValidForRedirect(enchantment)) {
            return;
        }
        List allEquippedAccessories = (List)slotEntries.get();
        if (allEquippedAccessories.isEmpty()) {
            return;
        }
        SlotEntryReference selectedRef = (SlotEntryReference)allEquippedAccessories.get(livingEntity.method_6051().method_43048(allEquippedAccessories.size()));
        list.add(Map.entry(AccessoriesInternals.INTERNAL_SLOT, selectedRef.stack()));
    }

    @Unique
    private static boolean enchantmentValidForRedirect(class_1887 enchantment) {
        return ((class_6880.class_6883)class_7923.field_41176.method_40264((class_5321)class_7923.field_41176.method_29113((Object)enchantment).orElseThrow()).orElseThrow()).method_40220(AccessoriesTags.VALID_FOR_REDIRECTION);
    }
}

