/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.AccessoryNest;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.EquipAction;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.events.AccessoryChangeCallback;
import io.wispforest.accessories.api.events.AllowEntityModificationCallback;
import io.wispforest.accessories.api.events.ContainersChangeCallback;
import io.wispforest.accessories.api.events.OnDeathCallback;
import io.wispforest.accessories.api.events.OnDropCallback;
import io.wispforest.accessories.api.events.SlotStateChange;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.client.AccessoriesMenu;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.impl.AccessoriesCapabilityImpl;
import io.wispforest.accessories.impl.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.impl.AccessoryNestUtils;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import io.wispforest.accessories.impl.PlayerEquipControl;
import io.wispforest.accessories.networking.base.BaseNetworkHandler;
import io.wispforest.accessories.networking.client.SyncContainerData;
import io.wispforest.accessories.networking.client.SyncData;
import io.wispforest.accessories.networking.client.SyncEntireContainer;
import io.wispforest.accessories.utils.AttributeUtils;
import io.wispforest.endec.SerializationContext;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5134;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class AccessoriesEventHandler {
    public static boolean dataReloadOccurred = false;
    public static final class_6862<class_1299<?>> EQUIPMENT_MANAGEABLE = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)Accessories.of("equipment_manageable"));

    public static void onWorldTick(class_1937 level) {
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        AccessoriesEventHandler.revalidatePlayersOnReload(serverLevel.method_8503().method_3760());
    }

    public static void revalidatePlayersOnReload(class_3324 playerList) {
        if (!dataReloadOccurred) {
            return;
        }
        for (class_3222 player : playerList.method_14571()) {
            AccessoriesEventHandler.revalidatePlayer(player);
        }
        dataReloadOccurred = false;
    }

    public static void revalidatePlayer(class_3222 player) {
        AccessoriesCapability capability = AccessoriesCapability.get((class_1309)player);
        if (capability == null) {
            return;
        }
        Collection<SlotType> validSlotTypes = EntitySlotLoader.getEntitySlots((class_1309)player).values();
        for (AccessoriesContainer container : capability.getContainers().values()) {
            SlotType slotType = container.slotType();
            if (slotType != null && validSlotTypes.contains(slotType)) {
                Integer baseSize = ((AccessoriesContainerImpl)container).getBaseSize();
                if (baseSize == null || baseSize.intValue() != slotType.amount()) {
                    container.markChanged();
                    container.update();
                }
                ExpandedSimpleContainer stacks = container.getAccessories();
                ExpandedSimpleContainer cosmeticStacks = container.getCosmeticAccessories();
                for (int i = 0; i < container.getSize(); ++i) {
                    SlotReference reference = container.createReference(i);
                    AccessoriesEventHandler.handleInvalidStacks((class_1263)stacks, reference, player);
                    AccessoriesEventHandler.handleInvalidStacks((class_1263)cosmeticStacks, reference, player);
                }
                continue;
            }
            ExpandedSimpleContainer stacks = container.getAccessories();
            ExpandedSimpleContainer cosmeticStacks = container.getCosmeticAccessories();
            for (int i = 0; i < container.getSize(); ++i) {
                SlotReference reference = container.createReference(i);
                AccessoriesEventHandler.dropAndRemoveStack((class_1263)stacks, reference, player);
                AccessoriesEventHandler.dropAndRemoveStack((class_1263)cosmeticStacks, reference, player);
            }
        }
    }

    private static void handleInvalidStacks(class_1263 container, SlotReference reference, class_3222 player) {
        boolean bl;
        boolean bl2 = bl = !AccessoriesAPI.canInsertIntoSlot(container.method_5438(reference.slot()), reference);
        if (bl) {
            AccessoriesEventHandler.dropAndRemoveStack(container, reference, player);
        }
    }

    private static void dropAndRemoveStack(class_1263 container, SlotReference reference, class_3222 player) {
        class_1799 stack = container.method_5438(reference.slot());
        container.method_5447(reference.slot(), class_1799.field_8037);
        AccessoriesInternals.giveItemToPlayer(player, stack);
    }

    public static void entityLoad(class_1309 entity, class_1937 level) {
        if (!level.method_8608() || !(entity instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)entity;
        AccessoriesCapability capability = AccessoriesCapability.get((class_1309)serverPlayer);
        if (capability == null) {
            return;
        }
        NbtMapCarrier carrier = NbtMapCarrier.of();
        ((AccessoriesHolderImpl)capability.getHolder()).write(carrier, SerializationContext.empty());
        AccessoriesInternals.getNetworkHandler().sendToTrackingAndSelf((class_1297)serverPlayer, new SyncEntireContainer(capability.entity().method_5628(), carrier));
    }

    public static void onTracking(class_1309 entity, class_3222 serverPlayer) {
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability == null) {
            return;
        }
        NbtMapCarrier carrier = NbtMapCarrier.of();
        ((AccessoriesHolderImpl)capability.getHolder()).write(carrier, SerializationContext.empty());
        AccessoriesInternals.getNetworkHandler().sendToPlayer(serverPlayer, new SyncEntireContainer(capability.entity().method_5628(), carrier));
    }

    public static void dataSync(@Nullable class_3324 list, @Nullable class_3222 player) {
        BaseNetworkHandler networkHandler = AccessoriesInternals.getNetworkHandler();
        SyncData syncPacket = SyncData.create();
        if (list != null && !list.method_14571().isEmpty()) {
            AccessoriesEventHandler.revalidatePlayersOnReload(list);
            for (class_3222 playerEntry : list.method_14571()) {
                networkHandler.sendToPlayer(playerEntry, syncPacket);
                AccessoriesCapability capability = AccessoriesCapability.get((class_1309)playerEntry);
                if (capability == null) {
                    return;
                }
                NbtMapCarrier carrier = NbtMapCarrier.of();
                ((AccessoriesHolderImpl)capability.getHolder()).write(carrier, SerializationContext.empty());
                networkHandler.sendToTrackingAndSelf((class_1297)playerEntry, new SyncEntireContainer(capability.entity().method_5628(), carrier));
                class_1703 class_17032 = playerEntry.field_7512;
                if (!(class_17032 instanceof AccessoriesMenu)) continue;
                AccessoriesMenu accessoriesMenu = (AccessoriesMenu)class_17032;
                Accessories.openAccessoriesMenu((class_1657)playerEntry, accessoriesMenu.targetEntity());
            }
        } else if (player != null) {
            networkHandler.sendToPlayer(player, syncPacket);
            AccessoriesEventHandler.revalidatePlayer(player);
            AccessoriesCapability capability = AccessoriesCapability.get((class_1309)player);
            if (capability == null) {
                return;
            }
            NbtMapCarrier carrier = NbtMapCarrier.of();
            ((AccessoriesHolderImpl)capability.getHolder()).write(carrier, SerializationContext.empty());
            networkHandler.sendToPlayer(player, new SyncEntireContainer(capability.entity().method_5628(), carrier));
            class_1703 class_17033 = player.field_7512;
            if (class_17033 instanceof AccessoriesMenu) {
                AccessoriesMenu accessoriesMenu = (AccessoriesMenu)class_17033;
                Accessories.openAccessoriesMenu((class_1657)player, accessoriesMenu.targetEntity());
            }
        }
    }

    public static void onLivingEntityTick(class_1309 entity) {
        List<class_1799> invalidStacks;
        Object dirtyCosmeticStacks;
        if (entity.method_31481()) {
            return;
        }
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability != null) {
            HashMap<String, class_1799> dirtyStacks = new HashMap<String, class_1799>();
            dirtyCosmeticStacks = new HashMap();
            AccessoryAttributeBuilder removedAttributesBuilder = new AccessoryAttributeBuilder();
            AccessoryAttributeBuilder addedAttributesBuilder = new AccessoryAttributeBuilder();
            for (Map.Entry<String, AccessoriesContainer> containerEntry : capability.getContainers().entrySet()) {
                AccessoriesContainer container = containerEntry.getValue();
                SlotType slotType = container.slotType();
                ExpandedSimpleContainer accessories = container.getAccessories();
                ExpandedSimpleContainer cosmetics = container.getCosmeticAccessories();
                for (int i = 0; i < accessories.method_5439(); ++i) {
                    class_1799 lastCosmeticStack;
                    class_1799 currentCosmeticStack;
                    SlotReference slotReference = container.createReference(i);
                    String slotId = slotType.name() + "/" + i;
                    class_1799 currentStack = accessories.method_5438(i);
                    if (!currentStack.method_7960()) {
                        currentStack.method_7917(entity.method_37908(), (class_1297)entity, -1, false);
                        Accessory accessory = AccessoriesAPI.getAccessory(currentStack);
                        if (accessory != null) {
                            accessory.tick(currentStack, slotReference);
                        }
                    }
                    class_1799 lastStack = accessories.getPreviousItem(i);
                    if (entity.method_37908().method_8608() || entity.method_29504()) continue;
                    if (!class_1799.method_7973((class_1799)currentStack, (class_1799)lastStack)) {
                        container.getAccessories().setPreviousItem(i, currentStack.method_7972());
                        dirtyStacks.put(slotId, currentStack.method_7972());
                        if (!lastStack.method_7960()) {
                            removedAttributesBuilder.addFrom(AccessoriesAPI.getAttributeModifiers(lastStack, slotReference));
                        }
                        if (!currentStack.method_7960()) {
                            addedAttributesBuilder.addFrom(AccessoriesAPI.getAttributeModifiers(currentStack, slotReference));
                        }
                        boolean equipmentChange = false;
                        if (!class_1799.method_7984((class_1799)currentStack, (class_1799)lastStack) || accessories.isSlotFlagged(i)) {
                            AccessoriesAPI.getOrDefaultAccessory(lastStack.method_7909()).onUnequip(lastStack, slotReference);
                            AccessoriesAPI.getOrDefaultAccessory(currentStack.method_7909()).onEquip(currentStack, slotReference);
                            if (entity instanceof class_3222) {
                                class_3222 serverPlayer = (class_3222)entity;
                                if (!currentStack.method_7960()) {
                                    Accessories.ACCESSORY_EQUIPPED.trigger(serverPlayer, currentStack, slotReference, false);
                                }
                                if (!lastStack.method_7960()) {
                                    Accessories.ACCESSORY_UNEQUIPPED.trigger(serverPlayer, lastStack, slotReference, false);
                                }
                            }
                            equipmentChange = true;
                        }
                        ((AccessoryChangeCallback)AccessoryChangeCallback.EVENT.invoker()).onChange(lastStack, currentStack, slotReference, equipmentChange ? SlotStateChange.REPLACEMENT : SlotStateChange.MUTATION);
                        AccessoriesEventHandler.recursiveStackChange(slotReference, AccessoryNestUtils.getData(lastStack), AccessoryNestUtils.getData(currentStack));
                    }
                    if (class_1799.method_7973((class_1799)(currentCosmeticStack = cosmetics.method_5438(i)), (class_1799)(lastCosmeticStack = container.getCosmeticAccessories().getPreviousItem(i)))) continue;
                    cosmetics.setPreviousItem(i, currentCosmeticStack.method_7972());
                    ((HashMap)dirtyCosmeticStacks).put(slotId, currentCosmeticStack.method_7972());
                    if (!(entity instanceof class_3222)) continue;
                    class_3222 serverPlayer = (class_3222)entity;
                    if (!currentStack.method_7960()) {
                        Accessories.ACCESSORY_EQUIPPED.trigger(serverPlayer, currentStack, slotReference, true);
                    }
                    if (lastStack.method_7960()) continue;
                    Accessories.ACCESSORY_UNEQUIPPED.trigger(serverPlayer, lastStack, slotReference, true);
                }
            }
            if (entity.method_37908().method_8608()) {
                return;
            }
            AttributeUtils.removeTransientAttributeModifiers(entity, removedAttributesBuilder);
            AttributeUtils.addTransientAttributeModifiers(entity, addedAttributesBuilder);
            Map<AccessoriesContainer, Boolean> updatedContainers = ((AccessoriesCapabilityImpl)capability).getUpdatingInventories();
            capability.updateContainers();
            ((ContainersChangeCallback)ContainersChangeCallback.EVENT.invoker()).onChange(entity, capability, (Map<AccessoriesContainer, Boolean>)ImmutableMap.copyOf(updatedContainers));
            if (!(dirtyStacks.isEmpty() && ((HashMap)dirtyCosmeticStacks).isEmpty() && updatedContainers.isEmpty())) {
                SyncContainerData packet = SyncContainerData.of(entity, updatedContainers.keySet(), dirtyStacks, (Map<String, class_1799>)dirtyCosmeticStacks);
                BaseNetworkHandler networkHandler = AccessoriesInternals.getNetworkHandler();
                networkHandler.sendToTrackingAndSelf((class_1297)entity, packet);
            }
            updatedContainers.clear();
        }
        AccessoriesHolderImpl holder = (AccessoriesHolderImpl)AccessoriesInternals.getHolder(entity);
        if (holder.loadedFromTag && capability == null) {
            dirtyCosmeticStacks = new AccessoriesCapabilityImpl(entity);
        }
        if (!(invalidStacks = holder.invalidStacks).isEmpty()) {
            for (class_1799 invalidStack : invalidStacks) {
                if (entity instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)entity;
                    AccessoriesInternals.giveItemToPlayer(serverPlayer, invalidStack);
                    continue;
                }
                entity.method_5775(invalidStack);
            }
            invalidStacks.clear();
        }
    }

    private static void recursiveStackChange(SlotReference slotReference, @Nullable AccessoryNestContainerContents lastNestData, @Nullable AccessoryNestContainerContents currentNestData) {
        List lastInnerStacks = lastNestData != null ? List.copyOf(lastNestData.getMap(slotReference).entrySet()) : List.of();
        List currentInnerStacks = currentNestData != null ? List.copyOf(currentNestData.getMap(slotReference).entrySet()) : List.of();
        int maxIterationLength = Math.max(lastInnerStacks.size(), currentInnerStacks.size());
        for (int i = 0; i < maxIterationLength; ++i) {
            SlotEntryReference currentRef;
            Map.Entry currentInnerEntry;
            Map.Entry lastInnerEntry = i < lastInnerStacks.size() ? (Map.Entry)lastInnerStacks.get(i) : null;
            Map.Entry entry = currentInnerEntry = i < currentInnerStacks.size() ? (Map.Entry)currentInnerStacks.get(i) : null;
            if (lastInnerEntry == null && currentInnerEntry != null) {
                currentRef = (SlotEntryReference)currentInnerEntry.getKey();
                ((AccessoryChangeCallback)AccessoryChangeCallback.EVENT.invoker()).onChange(class_1799.field_8037, currentRef.stack(), currentRef.reference(), SlotStateChange.REPLACEMENT);
                continue;
            }
            if (currentInnerEntry == null && lastInnerEntry != null) {
                SlotEntryReference lastRef = (SlotEntryReference)lastInnerEntry.getKey();
                ((AccessoryChangeCallback)AccessoryChangeCallback.EVENT.invoker()).onChange(lastRef.stack(), class_1799.field_8037, lastRef.reference(), SlotStateChange.REPLACEMENT);
                continue;
            }
            if (lastInnerEntry == null || currentInnerEntry == null) continue;
            currentRef = (SlotEntryReference)currentInnerEntry.getKey();
            SlotEntryReference lastRef = (SlotEntryReference)lastInnerEntry.getKey();
            SlotReference innerRef = lastRef.reference();
            class_1799 currentInnerStack = currentRef.stack();
            class_1799 lastInnerStack = lastRef.stack();
            ((AccessoryChangeCallback)AccessoryChangeCallback.EVENT.invoker()).onChange(lastInnerStack, currentInnerStack, innerRef, SlotStateChange.REPLACEMENT);
            AccessoriesEventHandler.recursiveStackChange(slotReference, AccessoryNestUtils.getData(lastInnerStack), AccessoryNestUtils.getData(currentInnerStack));
        }
    }

    public static void getTooltipData(@Nullable class_1309 entity, class_1799 stack, List<class_2561> tooltip, class_1836 tooltipType) {
        Accessory accessory = AccessoriesAPI.getOrDefaultAccessory(stack);
        if (accessory != null) {
            if (entity != null && AccessoriesCapability.get(entity) != null) {
                AccessoriesEventHandler.addEntityBasedTooltipData(entity, accessory, stack, tooltip, tooltipType);
            }
            accessory.getExtraTooltip(stack, tooltip, tooltipType);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void addEntityBasedTooltipData(class_1309 entity, Accessory accessory, class_1799 stack, List<class_2561> tooltip, class_1836 tooltipType) {
        void var17_22;
        HashSet<SlotType> validSlotTypes = new HashSet<SlotType>(AccessoriesAPI.getValidSlotTypes(entity, stack));
        Set validUniqueSlots = validSlotTypes.stream().filter(slotType -> UniqueSlotHandling.isUniqueSlot(slotType.name())).collect(Collectors.toSet());
        if (validSlotTypes.isEmpty()) {
            return;
        }
        validSlotTypes.removeAll(validUniqueSlots);
        Set sharedSlotTypes = SlotTypeLoader.getSlotTypes(entity.method_37908()).values().stream().filter(slotType -> !UniqueSlotHandling.isUniqueSlot(slotType.name())).collect(Collectors.toSet());
        class_5250 slotInfoComponent = class_2561.method_43470((String)"");
        class_5250 slotsComponent = class_2561.method_43470((String)"");
        boolean allSlots = false;
        if (validSlotTypes.containsAll(sharedSlotTypes)) {
            slotsComponent.method_10852((class_2561)class_2561.method_43471((String)Accessories.translation("slot.any")));
            allSlots = true;
        } else {
            Set<SlotType> entitySlotTypes = Set.copyOf(EntitySlotLoader.getEntitySlots(entity).values());
            Sets.SetView differenceSlotTypes = Sets.difference(entitySlotTypes, validSlotTypes);
            if (differenceSlotTypes.size() < validSlotTypes.size()) {
                slotsComponent.method_10852((class_2561)class_2561.method_43471((String)Accessories.translation("slot.any")));
                slotsComponent.method_10852((class_2561)class_2561.method_43470((String)" except ").method_27692(class_124.field_1080));
                slotTypesList = List.copyOf(differenceSlotTypes);
                for (i = 0; i < slotTypesList.size(); ++i) {
                    type = slotTypesList.get(i);
                    slotsComponent.method_10852((class_2561)class_2561.method_43471((String)type.translation()).method_27692(class_124.field_1061));
                    if (i + 1 == slotTypesList.size()) continue;
                    slotsComponent.method_10852((class_2561)class_2561.method_43470((String)", ").method_27692(class_124.field_1080));
                }
            } else {
                slotTypesList = List.copyOf(validSlotTypes);
                for (i = 0; i < slotTypesList.size(); ++i) {
                    type = slotTypesList.get(i);
                    slotsComponent.method_10852((class_2561)class_2561.method_43471((String)type.translation()));
                    if (i + 1 == slotTypesList.size()) continue;
                    slotsComponent.method_10852((class_2561)class_2561.method_43470((String)", ").method_27692(class_124.field_1080));
                }
            }
        }
        if (!validUniqueSlots.isEmpty()) {
            List uniqueSlotTypes = List.copyOf(validUniqueSlots);
            for (int i = 0; i < uniqueSlotTypes.size(); ++i) {
                SlotType type = (SlotType)uniqueSlotTypes.get(i);
                slotsComponent.method_10852((class_2561)class_2561.method_43471((String)type.translation()));
                if (i + 1 == uniqueSlotTypes.size()) continue;
                slotsComponent.method_10852((class_2561)class_2561.method_43470((String)", ").method_27692(class_124.field_1080));
            }
            validSlotTypes.addAll(validUniqueSlots);
        }
        String slotTranslationKey = "slot.tooltip." + (validSlotTypes.size() > 1 && !allSlots ? "plural" : "singular");
        slotInfoComponent.method_10852((class_2561)class_2561.method_43471((String)Accessories.translation(slotTranslationKey)).method_27692(class_124.field_1080).method_10852((class_2561)slotsComponent.method_27692(class_124.field_1078)));
        tooltip.add((class_2561)slotInfoComponent);
        HashMap<SlotType, AccessoryAttributeBuilder> slotSpecificModifiers = new HashMap<SlotType, AccessoryAttributeBuilder>();
        AccessoryAttributeBuilder defaultModifiers = null;
        boolean allDuplicates = true;
        for (SlotType slotType2 : validSlotTypes) {
            SlotReference slotReference = SlotReference.of(entity, slotType2.name(), 0);
            AccessoryAttributeBuilder builder = AccessoriesAPI.getAttributeModifiers(stack, slotReference, true);
            slotSpecificModifiers.put(slotType2, builder);
            if (defaultModifiers == null) {
                defaultModifiers = builder;
                continue;
            }
            if (!allDuplicates) continue;
            allDuplicates = defaultModifiers.equals(builder);
        }
        HashMap<SlotType, Object> slotTypeToTooltipInfo = new HashMap<SlotType, Object>();
        if (allDuplicates) {
            if (!defaultModifiers.isEmpty()) {
                ArrayList attributeTooltip = new ArrayList();
                AccessoriesEventHandler.addAttributeTooltip(defaultModifiers.getAttributeModifiers(false), attributeTooltip);
                slotTypeToTooltipInfo.put(null, attributeTooltip);
            }
        } else {
            for (Map.Entry entry : slotSpecificModifiers.entrySet()) {
                SlotType slotType3 = (SlotType)entry.getKey();
                AccessoryAttributeBuilder modifiers = (AccessoryAttributeBuilder)entry.getValue();
                if (modifiers.isEmpty()) continue;
                ArrayList<class_2561> attributeTooltip = new ArrayList<class_2561>();
                AccessoriesEventHandler.addAttributeTooltip(modifiers.getAttributeModifiers(false), attributeTooltip);
                slotTypeToTooltipInfo.put(slotType3, attributeTooltip);
            }
        }
        HashMap<SlotType, List> extraAttributeTooltips = new HashMap<SlotType, List>();
        Object var17_21 = null;
        boolean allDuplicatesExtras = true;
        for (SlotType slotType4 : validSlotTypes) {
            ArrayList<class_2561> extraAttributeTooltip = new ArrayList<class_2561>();
            accessory.getAttributesTooltip(stack, slotType4, extraAttributeTooltip, tooltipType);
            extraAttributeTooltips.put(slotType4, extraAttributeTooltip);
            if (var17_22 == null) {
                ArrayList<class_2561> arrayList = extraAttributeTooltip;
                continue;
            }
            if (!allDuplicatesExtras) continue;
            allDuplicatesExtras = extraAttributeTooltip.equals(var17_22);
        }
        if (allDuplicatesExtras) {
            slotTypeToTooltipInfo.computeIfAbsent(null, s -> new ArrayList()).addAll(var17_22);
        } else {
            extraAttributeTooltips.forEach((slotType, components) -> slotTypeToTooltipInfo.computeIfAbsent((SlotType)slotType, s -> new ArrayList()).addAll(components));
        }
        if (slotTypeToTooltipInfo.containsKey(null)) {
            List anyTooltipInfo = (List)slotTypeToTooltipInfo.get(null);
            if (anyTooltipInfo.size() > 0) {
                tooltip.add(class_5244.field_39003);
                tooltip.add((class_2561)class_2561.method_43471((String)Accessories.translation("tooltip.attributes.any")).method_27692(class_124.field_1080));
                tooltip.addAll(anyTooltipInfo);
            }
            slotTypeToTooltipInfo.remove(null);
        }
        if (!slotTypeToTooltipInfo.isEmpty()) {
            for (Map.Entry entry : slotTypeToTooltipInfo.entrySet()) {
                List tooltipData = (List)entry.getValue();
                if (tooltipData.size() == 0) continue;
                tooltip.add(class_5244.field_39003);
                tooltip.add((class_2561)class_2561.method_43469((String)Accessories.translation("tooltip.attributes.slot"), (Object[])new Object[]{class_2561.method_43471((String)((SlotType)entry.getKey()).translation()).method_27692(class_124.field_1078)}).method_27692(class_124.field_1080));
                tooltip.addAll((Collection)entry.getValue());
            }
        }
    }

    private static void addAttributeTooltip(Multimap<class_1320, class_1322> multimap, List<class_2561> tooltip) {
        if (multimap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : multimap.entries()) {
            class_1322 attributeModifier = (class_1322)entry.getValue();
            double d = attributeModifier.method_6186();
            if (attributeModifier.method_6182() == class_1322.class_1323.field_6330 || attributeModifier.method_6182() == class_1322.class_1323.field_6331) {
                d *= 100.0;
            } else if (((class_1320)entry.getKey()).equals(class_5134.field_23718)) {
                d *= 10.0;
            }
            class_1320 key = (class_1320)entry.getKey();
            if (d > 0.0) {
                tooltip.add((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + attributeModifier.method_6182().method_6191()), (Object[])new Object[]{class_1799.field_8029.format(d), class_2561.method_43471((String)key.method_26830())}).method_27692(class_124.field_1078));
                continue;
            }
            if (!(d < 0.0)) continue;
            tooltip.add((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + attributeModifier.method_6182().method_6191()), (Object[])new Object[]{class_1799.field_8029.format(d *= -1.0), class_2561.method_43471((String)key.method_26830())}).method_27692(class_124.field_1061));
        }
    }

    public static List<class_1799> onDeath(class_1309 entity, class_1282 source) {
        boolean keepInv;
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        ArrayList<class_1799> droppedStacks = new ArrayList<class_1799>();
        class_1928 gamerules = entity.method_37908().method_8450();
        boolean bl = keepInv = ((class_1928.class_4310)gamerules.method_20746(class_1928.field_19389)).method_20753() || ((class_1928.class_4310)gamerules.method_20746(Accessories.RULE_KEEP_ACCESSORY_INVENTORY)).method_20753();
        if (capability != null) {
            for (Map.Entry<String, AccessoriesContainer> containerEntry : capability.getContainers().entrySet()) {
                SlotType slotType = containerEntry.getValue().slotType();
                DropRule slotDropRule = slotType != null ? slotType.dropRule() : DropRule.DEFAULT;
                AccessoriesContainer container = containerEntry.getValue();
                ExpandedSimpleContainer stacks = container.getAccessories();
                ExpandedSimpleContainer cosmeticStacks = container.getCosmeticAccessories();
                for (int i = 0; i < container.getSize(); ++i) {
                    class_1799 cosmeticStack;
                    SlotReference reference = SlotReference.of(entity, container.getSlotName(), i);
                    class_1799 stack = AccessoriesEventHandler.dropStack(slotDropRule, entity, stacks, reference, source, keepInv);
                    if (stack != null) {
                        droppedStacks.add(stack);
                    }
                    if ((cosmeticStack = AccessoriesEventHandler.dropStack(slotDropRule, entity, cosmeticStacks, reference, source, keepInv)) == null) continue;
                    droppedStacks.add(cosmeticStack);
                }
            }
            TriState result = ((OnDeathCallback)OnDeathCallback.EVENT.invoker()).shouldDrop(TriState.DEFAULT, entity, capability, source, droppedStacks);
            if (!result.orElse(true)) {
                return List.of();
            }
        }
        return droppedStacks;
    }

    @Nullable
    private static class_1799 dropStack(DropRule dropRule, class_1309 entity, ExpandedSimpleContainer container, SlotReference reference, class_1282 source, boolean keepInvEnabled) {
        class_1799 stack = container.method_5438(reference.slot());
        Accessory accessory = AccessoriesAPI.getAccessory(stack);
        if (accessory != null && dropRule == DropRule.DEFAULT) {
            dropRule = accessory.getDropRule(stack, reference, source);
        }
        if (accessory instanceof AccessoryNest) {
            AccessoryNest holdable = (AccessoryNest)accessory;
            List<Pair<DropRule, class_1799>> dropRuleToStacks = holdable.getDropRules(stack, reference, source);
            for (int i = 0; i < dropRuleToStacks.size(); ++i) {
                boolean breakInnerStack;
                Pair<DropRule, class_1799> rulePair = dropRuleToStacks.get(i);
                class_1799 innerStack = (class_1799)rulePair.right();
                DropRule result = OnDropCallback.getAlternativeRule((DropRule)((Object)rulePair.left()), innerStack, reference, source);
                boolean bl = breakInnerStack = result == DropRule.DEFAULT && class_1890.method_8221((class_1799)innerStack) || result == DropRule.DESTROY;
                if (!breakInnerStack) continue;
                holdable.setInnerStack(stack, i, class_1799.field_8037);
                container.method_5447(reference.slot(), stack);
            }
        }
        DropRule result = OnDropCallback.getAlternativeRule(dropRule, stack, reference, source);
        boolean dropStack = true;
        if (result == DropRule.DESTROY) {
            container.method_5447(reference.slot(), class_1799.field_8037);
            dropStack = false;
        } else if (result == DropRule.KEEP) {
            dropStack = false;
        } else if (result == DropRule.DEFAULT) {
            if (keepInvEnabled) {
                dropStack = false;
            } else if (class_1890.method_8221((class_1799)stack)) {
                container.method_5447(reference.slot(), class_1799.field_8037);
                dropStack = false;
            }
        }
        container.setPreviousItem(reference.slot(), class_1799.field_8037);
        if (!dropStack) {
            return null;
        }
        container.method_5447(reference.slot(), class_1799.field_8037);
        return stack;
    }

    public static class_1271<class_1799> attemptEquipFromUse(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        AccessoriesCapability capability = AccessoriesCapability.get((class_1309)player);
        if (capability != null && !player.method_7325() && !stack.method_7960()) {
            PlayerEquipControl equipControl = capability.getHolder().equipControl();
            boolean shouldAttemptEquip = false;
            if (equipControl == PlayerEquipControl.MUST_CROUCH && player.method_5715()) {
                shouldAttemptEquip = true;
            } else if (equipControl == PlayerEquipControl.MUST_NOT_CROUCH && !player.method_5715()) {
                shouldAttemptEquip = true;
            }
            if (shouldAttemptEquip) {
                Accessory accessory = AccessoriesAPI.getOrDefaultAccessory(stack);
                Pair<SlotReference, EquipAction> equipReference = capability.canEquipAccessory(stack, true);
                if (equipReference != null && accessory.canEquipFromUse(stack)) {
                    accessory.onEquipFromUse(stack, (SlotReference)equipReference.left());
                    class_1799 newHandStack = stack.method_7972();
                    Optional<class_1799> possibleSwappedStack = ((EquipAction)equipReference.second()).equipStack(newHandStack);
                    if (possibleSwappedStack.isPresent()) {
                        class_1799 swappedStack = possibleSwappedStack.get();
                        if (newHandStack.method_7960()) {
                            newHandStack = swappedStack;
                        } else if (class_1799.method_31577((class_1799)newHandStack, (class_1799)swappedStack) && newHandStack.method_7947() + swappedStack.method_7947() <= newHandStack.method_7914()) {
                            newHandStack.method_7933(swappedStack.method_7947());
                        } else {
                            player.method_7270(swappedStack);
                        }
                    }
                    return class_1271.method_22427((Object)newHandStack);
                }
            }
        }
        return class_1271.method_22430((Object)stack);
    }

    public static class_1269 attemptEquipOnEntity(class_1657 player, class_1268 hand, class_1297 entity) {
        class_1309 targetEntity;
        class_1799 stack;
        block12: {
            block11: {
                stack = player.method_5998(hand);
                if (!(entity instanceof class_1309)) break block11;
                targetEntity = (class_1309)entity;
                if (entity.method_5864().method_20210(EQUIPMENT_MANAGEABLE)) break block12;
            }
            return class_1269.field_5811;
        }
        AccessoriesCapability targetCapability = AccessoriesCapability.get(targetEntity);
        boolean canModify = ((AllowEntityModificationCallback)AllowEntityModificationCallback.EVENT.invoker()).allowModifications(targetEntity, player, null).orElse(false);
        if (canModify && targetCapability != null && !player.method_7325() && player.method_5715()) {
            Accessory accessory = AccessoriesAPI.getOrDefaultAccessory(stack);
            Pair<SlotReference, EquipAction> equipReference = targetCapability.canEquipAccessory(stack, true);
            if (equipReference != null && accessory.canEquipFromUse(stack)) {
                if (!stack.method_7960()) {
                    accessory.onEquipFromUse(stack, (SlotReference)equipReference.left());
                }
                class_1799 newHandStack = stack.method_7972();
                Optional<class_1799> possibleSwappedStack = ((EquipAction)equipReference.second()).equipStack(newHandStack);
                if (possibleSwappedStack.isPresent()) {
                    class_1799 swappedStack = possibleSwappedStack.get();
                    if (newHandStack.method_7960()) {
                        newHandStack = swappedStack;
                    } else if (class_1799.method_31577((class_1799)newHandStack, (class_1799)swappedStack) && newHandStack.method_7947() + swappedStack.method_7947() <= newHandStack.method_7914()) {
                        newHandStack.method_7933(swappedStack.method_7947());
                    } else {
                        player.method_7270(swappedStack);
                    }
                }
                player.method_6122(hand, newHandStack);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }
}

