/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.network;

import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.network.v2.MessageDirection;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import fuzs.puzzleslib.api.network.v2.NetworkHandlerV2;
import fuzs.puzzleslib.impl.core.FabricProxy;
import fuzs.puzzleslib.impl.network.NetworkHandlerImplHelper;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2792;
import net.minecraft.class_2960;

public class NetworkHandlerFabricV2
implements NetworkHandlerV2 {
    private final Map<Class<? extends MessageV2<?>>, MessageData> messages = Maps.newIdentityHashMap();
    private final class_2960 channelIdentifier;
    private final AtomicInteger discriminator = new AtomicInteger();

    public NetworkHandlerFabricV2(class_2960 channelIdentifier) {
        this.channelIdentifier = channelIdentifier;
    }

    @Override
    public <T extends MessageV2<T>> void register(Class<? extends T> clazz, Supplier<T> supplier, MessageDirection direction) {
        this.register(clazz, direction == MessageDirection.TO_CLIENT, NetworkHandlerImplHelper.getDirectMessageDecoder(supplier));
    }

    @Override
    public <T extends MessageV2<T>> NetworkHandlerV2 registerClientbound(Class<T> clazz) {
        this.register(clazz, true, NetworkHandlerImplHelper.getMessageDecoder(clazz));
        return this;
    }

    @Override
    public <T extends MessageV2<T>> NetworkHandlerV2 registerServerbound(Class<T> clazz) {
        this.register(clazz, false, NetworkHandlerImplHelper.getMessageDecoder(clazz));
        return this;
    }

    private <T extends MessageV2<T>> void register(Class<T> clazz, boolean toClient, Function<class_2540, T> decode) {
        class_2960 channelName = this.nextIdentifier();
        this.messages.put(clazz, new MessageData(clazz, channelName, toClient));
        BiConsumer<class_2960, Function> registrar = toClient ? ((FabricProxy)Proxy.INSTANCE)::registerLegacyClientReceiver : ((FabricProxy)Proxy.INSTANCE)::registerLegacyServerReceiver;
        registrar.accept(channelName, decode);
    }

    private class_2960 nextIdentifier() {
        return new class_2960(this.channelIdentifier.method_12836(), this.channelIdentifier.method_12832() + "/" + this.discriminator.getAndIncrement());
    }

    @Override
    public class_2596<class_2792> toServerboundPacket(MessageV2<?> message) {
        if (this.messages.get(message.getClass()).toClient()) {
            throw new IllegalStateException("Attempted sending serverbound message to client side");
        }
        return this.toPacket(ClientPlayNetworking::createC2SPacket, message);
    }

    @Override
    public class_2596<class_2602> toClientboundPacket(MessageV2<?> message) {
        if (!this.messages.get(message.getClass()).toClient()) {
            throw new IllegalStateException("Attempted sending clientbound message to server side");
        }
        return this.toPacket(ServerPlayNetworking::createS2CPacket, message);
    }

    private <T extends class_2547> class_2596<T> toPacket(BiFunction<class_2960, class_2540, class_2596<T>> packetFactory, MessageV2<?> message) {
        class_2960 identifier = this.messages.get(message.getClass()).identifier();
        class_2540 byteBuf = PacketByteBufs.create();
        message.write(byteBuf);
        return packetFactory.apply(identifier, byteBuf);
    }

    private record MessageData(Class<? extends MessageV2<?>> clazz, class_2960 identifier, boolean toClient) {
    }
}

