/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.screen.v2;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.puzzleslib.api.client.core.v1.ClientAbstractions;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_757;
import net.minecraft.class_8002;
import net.minecraft.class_918;

public final class TooltipRenderHelper {
    private TooltipRenderHelper() {
    }

    public static List<class_2561> getTooltipLines(class_1799 itemStack) {
        return TooltipRenderHelper.getTooltipLines(itemStack, (class_1836)(class_310.method_1551().field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070));
    }

    public static List<class_2561> getTooltipLines(class_1799 itemStack, class_1836 tooltipFlag) {
        Objects.requireNonNull(itemStack, "item stack is null");
        Objects.requireNonNull(tooltipFlag, "tooltip flag is null");
        return itemStack.method_7950((class_1657)class_310.method_1551().field_1724, tooltipFlag);
    }

    public static List<class_5684> getTooltip(class_1799 itemStack) {
        return TooltipRenderHelper.getTooltip(itemStack, (class_1836)(class_310.method_1551().field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070));
    }

    public static List<class_5684> getTooltip(class_1799 itemStack, class_1836 tooltipFlag) {
        Objects.requireNonNull(itemStack, "item stack is null");
        Objects.requireNonNull(tooltipFlag, "tooltip flag is null");
        List<class_2561> components = TooltipRenderHelper.getTooltipLines(itemStack, tooltipFlag);
        List<class_5632> imageComponents = itemStack.method_32347().map(List::of).orElse(List.of());
        return TooltipRenderHelper.createClientComponents(components, imageComponents);
    }

    public static void renderTooltip(class_332 guiGraphics, int posX, int posY, class_1799 itemStack) {
        Objects.requireNonNull(itemStack, "item stack is null");
        TooltipRenderHelper.renderTooltipInternal(guiGraphics, posX, posY, TooltipRenderHelper.getTooltip(itemStack));
    }

    public static void renderTooltip(class_332 guiGraphics, int posX, int posY, class_2561 component, class_5632 imageComponent) {
        Objects.requireNonNull(component, "component is null");
        Objects.requireNonNull(imageComponent, "image component is null");
        TooltipRenderHelper.renderTooltip(guiGraphics, posX, posY, List.of(component), imageComponent);
    }

    public static void renderTooltip(class_332 guiGraphics, int posX, int posY, List<class_2561> components, class_5632 imageComponent) {
        Objects.requireNonNull(imageComponent, "image component is null");
        TooltipRenderHelper.renderTooltip(guiGraphics, posX, posY, components, List.of(imageComponent));
    }

    public static void renderTooltip(class_332 guiGraphics, int posX, int posY, List<class_2561> components) {
        TooltipRenderHelper.renderTooltip(guiGraphics, posX, posY, components, List.of());
    }

    public static void renderTooltip(class_332 guiGraphics, int posX, int posY, List<class_2561> components, List<class_5632> imageComponents) {
        TooltipRenderHelper.renderTooltipInternal(guiGraphics, posX, posY, TooltipRenderHelper.createClientComponents(components, imageComponents));
    }

    public static List<class_5684> createClientComponents(List<class_2561> components, List<class_5632> imageComponents) {
        return TooltipRenderHelper.createClientComponents(components, imageComponents, 1);
    }

    public static List<class_5684> createClientComponents(List<class_2561> components, List<class_5632> imageComponents, int insertAt) {
        List clientComponents = components.stream().map(class_2561::method_30937).map(class_5684::method_32662).collect(Collectors.toList());
        List<class_5684> clientImageComponents = imageComponents.stream().map(ClientAbstractions.INSTANCE::createImageComponent).toList();
        if (insertAt == -1) {
            clientComponents.addAll(clientImageComponents);
        } else {
            clientComponents.addAll(Math.min(clientComponents.size(), insertAt), clientImageComponents);
        }
        return ImmutableList.copyOf(clientComponents);
    }

    public static void renderTooltipInternal(class_332 guiGraphics, int posX, int posY, List<class_5684> components) {
        class_5684 clientTooltipComponent2;
        int q;
        if (components.isEmpty()) {
            return;
        }
        int i = 0;
        int j = components.size() == 1 ? -2 : 0;
        class_310 minecraft = class_310.method_1551();
        class_327 font = minecraft.field_1772;
        for (class_5684 component : components) {
            int k = component.method_32664(font);
            if (k > i) {
                i = k;
            }
            j += component.method_32661();
        }
        int l = posX + 12;
        int m = posY - 12;
        guiGraphics.method_51448().method_22903();
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        class_8002.method_47946((class_332)guiGraphics, (int)l, (int)m, (int)i, (int)j, (int)400);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        guiGraphics.method_51448().method_46416(0.0f, 0.0f, 400.0f);
        int p = m;
        for (q = 0; q < components.size(); ++q) {
            clientTooltipComponent2 = components.get(q);
            clientTooltipComponent2.method_32665(font, l, p, guiGraphics.method_51448().method_23760().method_23761(), bufferSource);
            p += clientTooltipComponent2.method_32661() + (q == 0 ? 2 : 0);
        }
        bufferSource.method_22993();
        p = m;
        class_918 itemRenderer = minecraft.method_1480();
        for (q = 0; q < components.size(); ++q) {
            clientTooltipComponent2 = components.get(q);
            clientTooltipComponent2.method_32666(font, l, p, guiGraphics);
            p += clientTooltipComponent2.method_32661() + (q == 0 ? 2 : 0);
        }
        guiGraphics.method_51448().method_22909();
    }
}

