/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import java.util.EnumSet;
import java.util.List;
import net.adventurez.init.SoundInit;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_3989;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5532;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class OrcEntity
extends class_1588 {
    public static final class_2940<Integer> ORK_SIZE = class_2945.method_12791(OrcEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> DOUBLE_HAND_ATTACK = class_2945.method_12791(OrcEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Integer> INVENTORY_ITEM_ID = class_2945.method_12791(OrcEntity.class, (class_2941)class_2943.field_13327);
    public final class_1277 inventory = new class_1277(1);

    public OrcEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(1.0f);
        this.method_46396();
    }

    public static class_5132.class_5133 createOrkAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, 0.225).method_26868(class_5134.field_23718, 0.2).method_26868(class_5134.field_23721, 7.0).method_26868(class_5134.field_23722, 1.0).method_26868(class_5134.field_23717, 38.0).method_26868(class_5134.field_23724, 1.0);
    }

    public void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new OrcEscapeGoal(this, 1.4));
        this.field_6201.method_6277(2, (class_1352)new OrcAttackGoal(this, 1.0, true));
        this.field_6201.method_6277(3, (class_1352)new OrcGroupGoal(this));
        this.field_6201.method_6277(4, (class_1352)new WanderAroundVeryFarGoal(this, 0.9, 0.7f));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(7, (class_1352)new class_1379((class_1314)this, 0.9));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_3989.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1646.class, true));
        this.field_6185.method_6277(4, (class_1352)new class_1399((class_1314)this, new Class[]{OrcEntity.class}));
    }

    public static boolean canSpawn(class_1299<OrcEntity> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return OrcEntity.method_20680(type, (class_5425)world, (class_3730)spawnReason, (class_2338)pos, (class_5819)random) && world.method_8311(pos) || spawnReason == class_3730.field_16469;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ORK_SIZE, (Object)1);
        this.field_6011.method_12784(DOUBLE_HAND_ATTACK, (Object)false);
        this.field_6011.method_12784(INVENTORY_ITEM_ID, (Object)-1);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setSize(tag.method_10550("OrkSize"), false);
        if (tag.method_10573("OrcItem", 10)) {
            this.inventory.method_5447(0, class_1799.method_7915((class_2487)tag.method_10562("OrcItem")));
            this.setItemId(this.inventory.method_5438(0).method_7909());
        }
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("OrkSize", this.getSize());
        if (!this.inventory.method_5438(0).method_7960()) {
            tag.method_10566("OrcItem", (class_2520)this.inventory.method_5438(0).method_7953(new class_2487()));
        }
    }

    public boolean method_5974(double distanceSquared) {
        return this.inventory.method_5438(0).method_7960();
    }

    public int getSize() {
        return (Integer)this.field_6011.method_12789(ORK_SIZE);
    }

    public void setSize(int size, boolean healOrc) {
        this.field_6011.method_12778(ORK_SIZE, (Object)size);
        this.method_23311();
        this.method_18382();
        this.method_5996(class_5134.field_23716).method_6192(16.0 + (double)size * 6.0);
        this.method_5996(class_5134.field_23719).method_6192((double)(0.26f - 0.012f * (float)size));
        this.method_5996(class_5134.field_23721).method_6192((double)size * 3.0 + 2.0);
        if (healOrc) {
            this.method_6033(this.method_6063());
        }
    }

    public void method_5674(class_2940<?> data) {
        if (ORK_SIZE.equals(data)) {
            this.method_18382();
            this.method_36456(this.field_6241);
            this.field_6283 = this.field_6241;
        }
        super.method_5674(data);
    }

    protected float method_6107() {
        return 0.3f * (float)this.getSize();
    }

    public float method_6017() {
        return 1.6f - 0.2f * (float)this.getSize();
    }

    protected class_3414 method_5994() {
        return SoundInit.ORC_IDLE_EVENT;
    }

    protected class_3414 method_6011(class_1282 source) {
        return SoundInit.ORC_HURT_EVENT;
    }

    protected class_3414 method_6002() {
        return SoundInit.ORC_DEATH_EVENT;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(SoundInit.ORC_STEP_EVENT, 1.0f, 1.0f);
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return 0.82f * dimensions.field_18068;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityTag) {
        this.setSize(this.method_6051().method_43048(3) + 1, true);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityTag);
    }

    public class_4048 method_18377(class_4050 pose) {
        return super.method_18377(pose).method_18383(0.55f * (float)this.getSize());
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_37908().method_8409().method_43048(3) == 0 && !((Boolean)this.field_6011.method_12789(DOUBLE_HAND_ATTACK)).booleanValue()) {
            this.field_6011.method_12778(DOUBLE_HAND_ATTACK, (Object)true);
        } else {
            this.field_6011.method_12778(DOUBLE_HAND_ATTACK, (Object)false);
        }
        return this.method_5679(source) ? false : super.method_5643(source, amount);
    }

    public int method_5945() {
        return 4;
    }

    protected void method_16078() {
        super.method_16078();
        if (this.inventory != null && !this.inventory.method_5442()) {
            this.method_5775(this.inventory.method_5438(0));
        }
    }

    public boolean isBigOrc() {
        return this.getSize() == 3;
    }

    private void setItemId(class_1792 item) {
        this.field_6011.method_12778(INVENTORY_ITEM_ID, (Object)class_7923.field_41178.method_10206((Object)item));
    }

    private class OrcEscapeGoal
    extends class_1352 {
        protected final OrcEntity orcEntity;
        protected final double speed;
        protected double targetX;
        protected double targetY;
        protected double targetZ;

        public OrcEscapeGoal(OrcEntity orcEntity2, double speed) {
            this.orcEntity = orcEntity2;
            this.speed = speed;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (this.orcEntity.isBigOrc() || this.orcEntity.inventory.method_5442() || this.orcEntity.method_37908().method_18460((class_1297)this.orcEntity, 16.0) == null) {
                return false;
            }
            return this.findTarget();
        }

        protected boolean findTarget() {
            class_243 vec3d = class_5532.method_31510((class_1314)this.orcEntity, (int)14, (int)4);
            if (vec3d == null) {
                return false;
            }
            this.targetX = vec3d.field_1352;
            this.targetY = vec3d.field_1351;
            this.targetZ = vec3d.field_1350;
            return true;
        }

        public void method_6269() {
            this.orcEntity.method_5942().method_6337(this.targetX, this.targetY, this.targetZ, this.speed);
        }

        public boolean method_6266() {
            if (this.orcEntity.method_37908().method_18460((class_1297)this.orcEntity, 18.0) == null) {
                return false;
            }
            return !this.orcEntity.method_5942().method_6357();
        }
    }

    private class OrcAttackGoal
    extends class_1366 {
        private final OrcEntity orcEntity;

        public OrcAttackGoal(OrcEntity orcEntity2, double speed, boolean pauseWhenMobIdle) {
            super((class_1314)orcEntity2, speed, pauseWhenMobIdle);
            this.orcEntity = orcEntity2;
        }

        protected double method_6289(class_1309 entity) {
            return this.field_6503.method_17681() * 2.0f * this.field_6503.method_17681() + entity.method_17681();
        }

        protected void method_6288(class_1309 target, double squaredDistance) {
            double d = this.method_6289(target);
            if (squaredDistance <= d && this.method_28348() <= 0) {
                this.method_28346();
                this.field_6503.method_6104(class_1268.field_5808);
                this.field_6503.method_6121((class_1297)target);
                if (!this.orcEntity.isBigOrc() && this.orcEntity.inventory.method_5442() && this.orcEntity.method_37908().method_8409().method_43057() <= 0.3f && target instanceof class_1657) {
                    class_1657 playerEntity = (class_1657)target;
                    for (int i = 45; i > 0; --i) {
                        if (playerEntity.method_31548().method_5438(i).method_7960() || !(playerEntity.method_31548().method_5438(i).method_7909() instanceof class_1831) || !(playerEntity.method_37908().method_8409().method_43057() < 0.3f)) continue;
                        this.orcEntity.inventory.method_5447(0, playerEntity.method_31548().method_5438(i));
                        this.orcEntity.setItemId(this.orcEntity.inventory.method_5438(0).method_7909());
                        playerEntity.method_31548().method_5447(i, class_1799.field_8037);
                        break;
                    }
                }
            }
        }
    }

    private class OrcGroupGoal
    extends class_1352 {
        private final OrcEntity orcEntity;
        private int moveDelay;
        private int checkSurroundingDelay;
        private OrcEntity orcLeader;

        public OrcGroupGoal(OrcEntity orcEntity2) {
            this.orcEntity = orcEntity2;
            this.checkSurroundingDelay = this.getSurroundingSearchDelay(orcEntity2);
        }

        private int getSurroundingSearchDelay(OrcEntity orcEntity) {
            return 200 + orcEntity.method_6051().method_43048(200) % 20;
        }

        private boolean isCloseEnoughToOrcLeader() {
            return this.orcEntity.method_5739((class_1297)this.orcLeader) <= 10.0f;
        }

        public boolean method_6264() {
            if (this.orcEntity.getSize() == 3 || this.orcEntity.method_6510()) {
                return false;
            }
            if (this.orcLeader != null && this.isCloseEnoughToOrcLeader()) {
                return false;
            }
            if (this.checkSurroundingDelay > 0) {
                --this.checkSurroundingDelay;
                return false;
            }
            List list = this.orcEntity.method_37908().method_18467(((Object)((Object)this.orcEntity)).getClass(), this.orcEntity.method_5829().method_1009(30.0, 8.0, 30.0));
            if (list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    if (((OrcEntity)((Object)list.get(i))).getSize() != 3) continue;
                    this.orcLeader = (OrcEntity)((Object)list.get(i));
                    return true;
                }
                this.checkSurroundingDelay = this.getSurroundingSearchDelay(this.orcEntity);
            }
            return false;
        }

        public boolean method_6266() {
            if (this.orcLeader != null || this.orcEntity.method_6065() == null) {
                return !this.isCloseEnoughToOrcLeader();
            }
            return false;
        }

        public void method_6269() {
            this.moveDelay = 0;
        }

        public void method_6270() {
            this.checkSurroundingDelay = this.getSurroundingSearchDelay(this.orcEntity);
        }

        public void method_6268() {
            if (--this.moveDelay <= 0) {
                this.moveDelay = 20;
                if (this.orcLeader != null) {
                    this.orcEntity.method_5942().method_6335((class_1297)this.orcLeader, 1.0);
                }
            }
        }
    }

    public class WanderAroundVeryFarGoal
    extends class_1379 {
        protected final float probability;
        private final OrcEntity orcEntity;

        public WanderAroundVeryFarGoal(OrcEntity orcEntity, double speed, float probability) {
            super((class_1314)orcEntity, speed);
            this.probability = probability;
            this.orcEntity = orcEntity;
        }

        @Nullable
        protected class_243 method_6302() {
            if (this.orcEntity.method_5816()) {
                class_243 vec3d = class_5532.method_31510((class_1314)this.orcEntity, (int)15, (int)7);
                return vec3d == null ? super.method_6302() : vec3d;
            }
            return this.orcEntity.method_6051().method_43057() >= this.probability && this.orcEntity.isBigOrc() ? class_5532.method_31510((class_1314)this.orcEntity, (int)30, (int)5) : super.method_6302();
        }
    }
}

