/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.KitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.api.ISortButton;
import net.blay09.mods.cookingforblockheads.api.IngredientPredicateWithCache;
import net.blay09.mods.cookingforblockheads.api.RecipeStatus;
import net.blay09.mods.cookingforblockheads.api.SinkHandler;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.ToasterHandler;
import net.blay09.mods.cookingforblockheads.api.capability.DefaultKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.event.FoodRegistryInitEvent;
import net.blay09.mods.cookingforblockheads.menu.inventory.InventoryCraftBook;
import net.blay09.mods.cookingforblockheads.registry.FoodRecipeType;
import net.blay09.mods.cookingforblockheads.registry.IngredientPredicateWithCacheImpl;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodIngredient;
import net.blay09.mods.cookingforblockheads.registry.recipe.FoodRecipe;
import net.blay09.mods.cookingforblockheads.registry.recipe.GeneralFoodRecipe;
import net.blay09.mods.cookingforblockheads.registry.recipe.SmeltingFood;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import org.jetbrains.annotations.Nullable;

public class CookingRegistry {
    private static final List<class_1860<class_1263>> recipeList = Lists.newArrayList();
    private static final ArrayListMultimap<class_2960, FoodRecipe> foodItems = ArrayListMultimap.create();
    private static final class_2371<class_1799> tools = class_2371.method_10211();
    private static final Map<class_1799, Integer> ovenFuelItems = Maps.newHashMap();
    private static final Map<class_1799, class_1799> ovenRecipes = Maps.newHashMap();
    private static final Map<class_1799, SinkHandler> sinkHandlers = Maps.newHashMap();
    private static final Map<class_1799, ToasterHandler> toastHandlers = Maps.newHashMap();
    private static final class_2371<class_1799> waterItems = class_2371.method_10211();
    private static final class_2371<class_1799> milkItems = class_2371.method_10211();
    private static final List<ISortButton> customSortButtons = Lists.newArrayList();
    private static Collection<class_1799> nonFoodRecipes = Collections.emptyList();
    private static final ToasterHandler dummyBreadToasterHandler = itemStack -> {
        boolean alreadyToasted;
        class_2487 tag = itemStack.method_7969();
        boolean bl = alreadyToasted = tag != null && tag.method_10577("CookingForBlockheadsToasted");
        if (alreadyToasted) {
            if (CookingForBlockheadsConfig.getActive().allowVeryToastedBread) {
                class_1799 veryToasted = new class_1799((class_1935)class_1802.field_8665);
                veryToasted.method_7977((class_2561)class_2561.method_43471((String)"tooltip.cookingforblockheads:very_toasted"));
                return veryToasted;
            }
            return itemStack;
        }
        class_1799 toasted = itemStack.method_7972();
        toasted.method_7977((class_2561)class_2561.method_43469((String)"tooltip.cookingforblockheads:toasted", (Object[])new Object[]{itemStack.method_7964()}));
        toasted.method_7948().method_10556("CookingForBlockheadsToasted", true);
        return toasted;
    };

    public static void initFoodRegistry(class_1863 recipeManager, class_5455 registryAccess) {
        recipeList.clear();
        foodItems.clear();
        FoodRegistryInitEvent init = new FoodRegistryInitEvent();
        Balm.getEvents().fireEvent((Object)init);
        nonFoodRecipes = init.getNonFoodRecipes();
        block0: for (class_1860 recipe : recipeManager.method_8126()) {
            if (!CookingRegistry.isValidRecipeType(recipe)) continue;
            class_1799 output = recipe.method_8110(registryAccess);
            if (output == null) {
                CookingForBlockheads.logger.warn("Recipe " + String.valueOf(recipe.method_8114()) + " returned a null ItemStack in getRecipeOutput - this is bad! The developer of " + recipe.method_8114().method_12836() + " should return an empty ItemStack instead to avoid problems.");
                continue;
            }
            if (output.method_7960()) continue;
            if (output.method_7909().method_19263()) {
                if (CookingRegistry.isWeirdConversionRecipe(recipe, registryAccess)) continue;
                CookingRegistry.addFoodRecipe((class_1860<? extends class_1263>)recipe, registryAccess);
                continue;
            }
            for (class_1799 itemStack : nonFoodRecipes) {
                if (!class_1799.method_7984((class_1799)recipe.method_8110(registryAccess), (class_1799)itemStack)) continue;
                CookingRegistry.addFoodRecipe((class_1860<? extends class_1263>)recipe, registryAccess);
                continue block0;
            }
        }
    }

    private static boolean isValidRecipeType(class_1860<?> recipe) {
        return recipe.method_17716() == class_3956.field_17545 || recipe.method_17716() == class_3956.field_17546;
    }

    public static boolean isWeirdConversionRecipe(class_1860<?> recipe, class_5455 registryAccess) {
        if (recipe.method_8117().size() == 2 && recipe.method_8110(registryAccess).method_7947() == 2) {
            class_1856 first = (class_1856)recipe.method_8117().get(0);
            class_1856 second = (class_1856)recipe.method_8117().get(1);
            return first.method_8093(recipe.method_8110(registryAccess)) && second.method_8093(recipe.method_8110(registryAccess));
        }
        return false;
    }

    public static boolean isNonFoodRecipe(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return false;
        }
        for (class_1799 nonFoodStack : nonFoodRecipes) {
            if (!class_1799.method_7984((class_1799)itemStack, (class_1799)nonFoodStack)) continue;
            return true;
        }
        return false;
    }

    public static void addFoodRecipe(class_1860<? extends class_1263> recipe, class_5455 registryAccess) {
        class_1799 output = recipe.method_8110(registryAccess);
        if (!output.method_7960() && !recipe.method_8117().isEmpty()) {
            FoodRecipe foodRecipe;
            if (recipe instanceof class_1874) {
                foodRecipe = new SmeltingFood(recipe, recipe.method_8110(registryAccess));
            } else if (recipe instanceof class_3955) {
                foodRecipe = new GeneralFoodRecipe(recipe, recipe.method_8110(registryAccess));
            } else {
                return;
            }
            recipeList.add(recipe);
            foodItems.put((Object)Balm.getRegistries().getKey(output.method_7909()), (Object)foodRecipe);
        }
    }

    public static Multimap<class_2960, FoodRecipe> getFoodRecipes() {
        return foodItems;
    }

    public static Collection<FoodRecipe> getFoodRecipes(class_1799 outputItem) {
        return foodItems.get((Object)Balm.getRegistries().getKey(outputItem.method_7909()));
    }

    public static Collection<FoodRecipe> getFoodRecipes(class_2960 outputItem) {
        return foodItems.get((Object)outputItem);
    }

    public static void addToolItem(class_1799 toolItem) {
        tools.add((Object)toolItem);
    }

    public static boolean isToolItem(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return false;
        }
        for (class_1799 toolItem : tools) {
            if (!class_1799.method_7984((class_1799)toolItem, (class_1799)itemStack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isToolItem(class_1856 ingredient) {
        for (class_1799 itemStack : ingredient.method_8105()) {
            if (!CookingRegistry.isToolItem(itemStack)) continue;
            return true;
        }
        return false;
    }

    public static void addOvenFuel(class_1799 itemStack, int fuelTime) {
        ovenFuelItems.put(itemStack, fuelTime);
    }

    public static int getOvenFuelTime(class_1799 itemStack) {
        for (Map.Entry<class_1799, Integer> entry : ovenFuelItems.entrySet()) {
            if (!class_1799.method_7984((class_1799)entry.getKey(), (class_1799)itemStack)) continue;
            return entry.getValue();
        }
        return 0;
    }

    public static void addSmeltingItem(class_1799 source, class_1799 result) {
        ovenRecipes.put(source, result);
    }

    public static class_1799 getSmeltingResult(class_1799 itemStack) {
        for (Map.Entry<class_1799, class_1799> entry : ovenRecipes.entrySet()) {
            if (!class_1799.method_7984((class_1799)entry.getKey(), (class_1799)itemStack)) continue;
            return entry.getValue();
        }
        return class_1799.field_8037;
    }

    public static void addToasterHandler(class_1799 itemStack, ToasterHandler toastHandler) {
        toastHandlers.put(itemStack, toastHandler);
    }

    @Nullable
    public static ToasterHandler getToasterHandler(class_1799 itemStack) {
        for (Map.Entry<class_1799, ToasterHandler> entry : toastHandlers.entrySet()) {
            if (!class_1799.method_7984((class_1799)entry.getKey(), (class_1799)itemStack)) continue;
            return entry.getValue();
        }
        if (itemStack.method_7909() == class_1802.field_8229) {
            return dummyBreadToasterHandler;
        }
        return null;
    }

    public static void addSinkHandler(class_1799 itemStack, SinkHandler sinkHandler) {
        sinkHandlers.put(itemStack, sinkHandler);
    }

    public static class_1799 getSinkOutput(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        for (Map.Entry<class_1799, SinkHandler> entry : sinkHandlers.entrySet()) {
            if (!class_1799.method_7984((class_1799)entry.getKey(), (class_1799)itemStack)) continue;
            return entry.getValue().getSinkOutput(itemStack);
        }
        return class_1799.field_8037;
    }

    @Nullable
    private static SourceItem findAnyItemStack(class_1799 checkStack, List<IKitchenItemProvider> inventories, boolean requireBucket) {
        if (checkStack.method_7960()) {
            return null;
        }
        IngredientPredicateWithCache predicate = IngredientPredicateWithCacheImpl.of((it, count) -> class_1799.method_7984((class_1799)it, (class_1799)checkStack) && count > 0, checkStack);
        for (int i = 0; i < inventories.size(); ++i) {
            IKitchenItemProvider itemProvider = inventories.get(i);
            SourceItem found = itemProvider.findSource(predicate, 1, inventories, requireBucket, true);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static List<SourceItem> findSourceCandidates(FoodIngredient ingredient, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean isNoFilter) {
        SourceItem sourceItem;
        class_1799[] variants;
        ArrayList<SourceItem> sourceList = new ArrayList<SourceItem>();
        ArrayList<SourceItem> fallbackSourceList = new ArrayList<SourceItem>();
        for (class_1799 checkStack : variants = ingredient.getItemStacks()) {
            class_1799 foundStack;
            SourceItem sourceItem2 = CookingRegistry.findAnyItemStack(checkStack, inventories, requireBucket);
            class_1799 class_17992 = foundStack = sourceItem2 != null ? sourceItem2.getSourceStack() : class_1799.field_8037;
            if (foundStack.method_7960()) {
                if (isNoFilter) {
                    sourceItem2 = new SourceItem(null, -1, checkStack);
                    sourceList.add(sourceItem2);
                    continue;
                }
                if (!ingredient.isToolItem()) continue;
                sourceItem2 = new SourceItem(null, -1, checkStack);
                fallbackSourceList.add(sourceItem2);
                continue;
            }
            sourceList.add(sourceItem2);
        }
        if (sourceList.isEmpty()) {
            sourceList.addAll(fallbackSourceList);
        }
        SourceItem sourceItem3 = sourceItem = !sourceList.isEmpty() ? (SourceItem)sourceList.get(0) : null;
        if (sourceItem != null && sourceItem.getSourceProvider() != null) {
            sourceItem.getSourceProvider().markAsUsed(sourceItem, 1, inventories, requireBucket);
        }
        return sourceList;
    }

    public static boolean consumeBucket(List<IKitchenItemProvider> inventories, boolean simulate) {
        class_1799 bucketStack = new class_1799((class_1935)class_1802.field_8550);
        IngredientPredicateWithCache predicate = IngredientPredicateWithCacheImpl.of((it, count) -> class_1799.method_7984((class_1799)it, (class_1799)bucketStack) && count > 0, bucketStack);
        for (int i = 0; i < inventories.size(); ++i) {
            IKitchenItemProvider itemProvider = inventories.get(i);
            SourceItem sourceItem = itemProvider.findSourceAndMarkAsUsed(predicate, 1, inventories, false, simulate);
            if (sourceItem == null) continue;
            return true;
        }
        return false;
    }

    public static RecipeStatus getRecipeStatus(FoodRecipe recipe, List<IKitchenItemProvider> inventories, boolean hasOven) {
        boolean requireBucket = CookingRegistry.doesItemRequireBucketForCrafting(recipe.getOutputItem());
        for (IKitchenItemProvider itemProvider : inventories) {
            itemProvider.resetSimulation();
        }
        List<FoodIngredient> craftMatrix = recipe.getCraftMatrix();
        boolean missingTools = false;
        for (FoodIngredient ingredient : craftMatrix) {
            if (ingredient == null) continue;
            List<SourceItem> sourceList = CookingRegistry.findSourceCandidates(ingredient, inventories, requireBucket, false);
            if (sourceList.isEmpty()) {
                return RecipeStatus.MISSING_INGREDIENTS;
            }
            if (!sourceList.stream().allMatch(it -> it.getSourceProvider() == null)) continue;
            missingTools = true;
        }
        if (recipe.getType() == FoodRecipeType.SMELTING && !hasOven) {
            return RecipeStatus.MISSING_TOOLS;
        }
        return missingTools ? RecipeStatus.MISSING_TOOLS : RecipeStatus.AVAILABLE;
    }

    public static List<IKitchenItemProvider> getItemProviders(@Nullable KitchenMultiBlock multiBlock, class_1661 inventory) {
        return multiBlock != null ? multiBlock.getItemProviders(inventory) : Lists.newArrayList((Object[])new IKitchenItemProvider[]{new DefaultKitchenItemProvider((class_1263)inventory)});
    }

    @Nullable
    public static <T extends class_1860<?>> T findFoodRecipe(InventoryCraftBook craftMatrix, class_1937 level, class_3956<T> recipeType, class_1792 expectedItem) {
        for (class_1860<class_1263> recipe : recipeList) {
            if (recipe.method_17716() != recipeType || !recipe.method_8115((class_1263)craftMatrix, level) || recipe.method_8110(level.method_30349()).method_7909() != expectedItem) continue;
            return (T)recipe;
        }
        return null;
    }

    public static void addWaterItem(class_1799 waterItem) {
        waterItems.add((Object)waterItem);
    }

    public static void addMilkItem(class_1799 milkItem) {
        milkItems.add((Object)milkItem);
    }

    public static void addSortButton(ISortButton button) {
        customSortButtons.add(button);
    }

    public static class_2371<class_1799> getWaterItems() {
        return waterItems;
    }

    public static class_2371<class_1799> getMilkItems() {
        return milkItems;
    }

    public static List<ISortButton> getSortButtons() {
        return customSortButtons;
    }

    public static boolean doesItemRequireBucketForCrafting(class_1799 outputItem) {
        class_1799 containerItem = Balm.getHooks().getCraftingRemainingItem(outputItem);
        if (!containerItem.method_7960() && containerItem.method_7909() == class_1802.field_8550) {
            return true;
        }
        class_2960 registryName = Balm.getRegistries().getKey(outputItem.method_7909());
        return registryName != null && registryName.method_12832().contains("bucket");
    }
}

