/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import java.util.function.Consumer;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.UpgradeablePreservation;
import net.blay09.mods.cookingforblockheads.tile.CowJarBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.FridgeBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.MilkJarBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.OvenBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.SinkBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.ToasterBlockEntity;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

public class CookingForBlockheadsWailaUtils {
    public static final class_2960 MILK_JAR_UID = new class_2960("cookingforblockheads", "milk_jar");
    public static final class_2960 TOASTER_UID = new class_2960("cookingforblockheads", "toaster");
    public static final class_2960 OVEN_UID = new class_2960("cookingforblockheads", "oven");
    public static final class_2960 FRIDGE_UID = new class_2960("cookingforblockheads", "fridge");
    public static final class_2960 PRESERVATION_CHAMBER_UID = new class_2960("cookingforblockheads", "preservation_chamber");
    public static final class_2960 SINK_UID = new class_2960("cookingforblockheads", "sink");

    public static void appendMilkJarTooltip(class_2586 blockEntity, class_1657 player, Consumer<class_2561> tooltipConsumer) {
        CowJarBlockEntity cowJar;
        if (blockEntity instanceof CowJarBlockEntity && (cowJar = (CowJarBlockEntity)blockEntity).method_5797() != null) {
            tooltipConsumer.accept(cowJar.method_5797());
        }
        if (blockEntity instanceof MilkJarBlockEntity) {
            MilkJarBlockEntity milkJar = (MilkJarBlockEntity)blockEntity;
            FluidTank fluidTank = milkJar.getFluidTank();
            tooltipConsumer.accept((class_2561)class_2561.method_43469((String)"waila.cookingforblockheads:milk_stored", (Object[])new Object[]{fluidTank.getAmount(), fluidTank.getCapacity()}));
        }
    }

    public static void appendToasterTooltip(class_2586 blockEntity, class_1657 player, Consumer<class_2561> tooltipConsumer) {
        ToasterBlockEntity toaster;
        if (blockEntity instanceof ToasterBlockEntity && (toaster = (ToasterBlockEntity)blockEntity).isActive()) {
            tooltipConsumer.accept((class_2561)class_2561.method_43469((String)"waila.cookingforblockheads:toast_progress", (Object[])new Object[]{(int)(toaster.getToastProgress() * 100.0f)}));
        }
    }

    public static void appendOvenTooltip(class_2586 blockEntity, class_1657 player, Consumer<class_2561> tooltipConsumer) {
        OvenBlockEntity oven;
        if (blockEntity instanceof OvenBlockEntity && (oven = (OvenBlockEntity)blockEntity).hasPowerUpgrade()) {
            tooltipConsumer.accept((class_2561)class_2561.method_43471((String)"waila.cookingforblockheads:heating_unit"));
        }
    }

    public static void appendFridgeTooltip(class_2586 blockEntity, class_1657 player, Consumer<class_2561> tooltipConsumer) {
        FridgeBlockEntity fridge;
        if (blockEntity instanceof FridgeBlockEntity && (fridge = (FridgeBlockEntity)blockEntity).hasIceUpgrade()) {
            tooltipConsumer.accept((class_2561)class_2561.method_43471((String)"waila.cookingforblockheads:ice_unit"));
        }
    }

    public static void appendPreservationChamberTooltip(class_2586 blockEntity, class_1657 player, Consumer<class_2561> tooltipConsumer) {
        UpgradeablePreservation upgradeable;
        if (blockEntity instanceof UpgradeablePreservation && (upgradeable = (UpgradeablePreservation)blockEntity).hasPreservationUpgrade()) {
            tooltipConsumer.accept((class_2561)class_2561.method_43471((String)"waila.cookingforblockheads:preservation_chamber"));
        }
    }

    public static void appendSinkTooltip(class_2586 blockEntity, class_1657 player, Consumer<class_2561> tooltipConsumer) {
        if (blockEntity instanceof SinkBlockEntity) {
            SinkBlockEntity sink = (SinkBlockEntity)blockEntity;
            if (CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                FluidTank fluidTank = sink.getFluidTank();
                tooltipConsumer.accept((class_2561)class_2561.method_43469((String)"waila.cookingforblockheads:water_stored", (Object[])new Object[]{fluidTank.getAmount(), fluidTank.getCapacity()}));
            }
        }
    }

    private CookingForBlockheadsWailaUtils() {
    }

    @FunctionalInterface
    public static interface TooltipAppender {
        public void appendTooltip(class_2586 var1, class_1657 var2, Consumer<class_2561> var3);
    }
}

