/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.api.capability;

import java.util.Arrays;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.AbstractKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IngredientPredicate;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.IngredientPredicateWithCacheImpl;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class DefaultKitchenItemProvider
extends AbstractKitchenItemProvider {
    private class_1263 container;
    private int[] usedStackSize;

    public DefaultKitchenItemProvider() {
    }

    public DefaultKitchenItemProvider(class_1263 container) {
        this.container = container;
        this.usedStackSize = new int[container.method_5439()];
    }

    public void setContainer(class_1263 container) {
        this.container = container;
        this.usedStackSize = new int[container.method_5439()];
    }

    @Override
    public void resetSimulation() {
        Arrays.fill(this.usedStackSize, 0);
    }

    @Override
    public int getSimulatedUseCount(int slot) {
        return this.usedStackSize[slot];
    }

    @Override
    public class_1799 useItemStack(int slot, int amount, boolean simulate, List<IKitchenItemProvider> inventories, boolean requireBucket) {
        if (slot == -1) {
            return class_1799.field_8037;
        }
        class_1799 itemStack = this.container.method_5438(slot);
        if (itemStack.method_7947() - (simulate ? this.usedStackSize[slot] : 0) >= amount) {
            class_1799 result = ContainerUtils.extractItem((class_1263)this.container, (int)slot, (int)amount, (boolean)simulate);
            if (simulate && !result.method_7960()) {
                int n = slot;
                this.usedStackSize[n] = this.usedStackSize[n] + result.method_7947();
            }
            return result;
        }
        return class_1799.field_8037;
    }

    @Override
    public class_1799 returnItemStack(class_1799 itemStack, SourceItem sourceItem) {
        class_1799 restStack = ContainerUtils.insertItem((class_1263)this.container, (int)sourceItem.getSourceSlot(), (class_1799)itemStack, (boolean)false);
        if (!restStack.method_7960()) {
            restStack = ContainerUtils.insertItemStacked((class_1263)this.container, (class_1799)itemStack, (boolean)false);
        }
        return restStack;
    }

    @Override
    public int getSlots() {
        return this.container.method_5439();
    }

    @Override
    public class_1799 getStackInSlot(int slot) {
        return this.container.method_5438(slot);
    }

    @Override
    @Nullable
    public SourceItem findSource(IngredientPredicate predicate, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean simulate) {
        IngredientPredicate modifiedPredicate = predicate;
        if (this.hasPreservationUpgrade()) {
            modifiedPredicate = IngredientPredicateWithCacheImpl.and(predicate, (it, count) -> count > 1 || !Balm.getHooks().getCraftingRemainingItem(it).method_7960() || CookingRegistry.isToolItem(it));
        }
        return super.findSource(modifiedPredicate, maxAmount, inventories, requireBucket, simulate);
    }

    @Override
    @Nullable
    public SourceItem findSourceAndMarkAsUsed(IngredientPredicate predicate, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean simulate) {
        IngredientPredicate modifiedPredicate = predicate;
        if (this.hasPreservationUpgrade()) {
            modifiedPredicate = IngredientPredicateWithCacheImpl.and(predicate, (it, count) -> count > 1 || !Balm.getHooks().getCraftingRemainingItem(it).method_7960() || CookingRegistry.isToolItem(it));
        }
        return super.findSourceAndMarkAsUsed(modifiedPredicate, maxAmount, inventories, requireBucket, simulate);
    }

    public boolean hasPreservationUpgrade() {
        return false;
    }
}

