/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.planets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamresourceful.resourcefullib.common.lib.Constants;
import com.teamresourceful.resourcefullib.common.networking.PacketHelper;
import earth.terrarium.adastra.AdAstra;
import earth.terrarium.adastra.api.planets.Planet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AdAstraData
extends class_4309 {
    private static final Map<class_5321<class_1937>, Planet> PLANETS = new HashMap<class_5321<class_1937>, Planet>();
    private static final Map<class_5321<class_1937>, class_5321<class_1937>> DIMENSIONS_TO_PLANETS = new HashMap<class_5321<class_1937>, class_5321<class_1937>>();

    public AdAstraData() {
        super(Constants.GSON, "planets");
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        PLANETS.clear();
        DIMENSIONS_TO_PLANETS.clear();
        object.forEach((key, value) -> {
            JsonObject json = class_3518.method_15295((JsonElement)value, (String)"planets");
            Planet planet = (Planet)Planet.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, arg_0 -> ((Logger)AdAstra.LOGGER).error(arg_0));
            PLANETS.put(planet.dimension(), planet);
            DIMENSIONS_TO_PLANETS.put(planet.dimension(), planet.dimension());
            for (class_5321<class_1937> dimension : planet.additionalLaunchDimensions()) {
                DIMENSIONS_TO_PLANETS.put(dimension, planet.dimension());
            }
        });
    }

    public static void encodePlanets(class_2540 buf) {
        PacketHelper.writeWithYabn((class_2540)buf, (Codec)Planet.CODEC.listOf(), AdAstraData.planets().values().stream().toList(), (boolean)true).get().mapRight(DataResult.PartialResult::message).ifRight(arg_0 -> ((Logger)AdAstra.LOGGER).error(arg_0));
    }

    public static Collection<Planet> decodePlanets(class_2540 buf) {
        return PacketHelper.readWithYabn((class_2540)buf, (Codec)Planet.CODEC.listOf(), (boolean)true).get().mapRight(DataResult.PartialResult::message).ifRight(arg_0 -> ((Logger)AdAstra.LOGGER).error(arg_0)).left().orElse(Collections.emptyList());
    }

    public static class_5321<class_1937> getPlanetLocation(class_5321<class_1937> dimension) {
        return DIMENSIONS_TO_PLANETS.get(dimension);
    }

    @Nullable
    public static Planet getPlanet(class_5321<class_1937> location) {
        return PLANETS.get(location);
    }

    public static boolean isPlanet(class_5321<class_1937> location) {
        return PLANETS.containsKey(location);
    }

    public static boolean isSpace(class_5321<class_1937> location) {
        return AdAstraData.isPlanet(location) && PLANETS.get(location).isSpace();
    }

    public static boolean canLaunchFrom(class_5321<class_1937> dimension) {
        return DIMENSIONS_TO_PLANETS.containsKey(dimension);
    }

    public static Map<class_5321<class_1937>, Planet> planets() {
        return PLANETS;
    }

    public static Set<class_2960> solarSystems() {
        return PLANETS.values().stream().map(Planet::solarSystem).collect(Collectors.toUnmodifiableSet());
    }

    public static void setPlanets(Map<class_5321<class_1937>, Planet> planets) {
        PLANETS.clear();
        PLANETS.putAll(planets);
    }
}

