/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structure;

import com.aetherteam.aether.world.structure.AetherStructureTypes;
import com.aetherteam.aether.world.structurepiece.LargeAercloudChunk;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_4651;
import net.minecraft.class_5819;
import net.minecraft.class_6626;
import net.minecraft.class_7151;

public class LargeAercloudStructure
extends class_3195 {
    public static final Codec<LargeAercloudStructure> CODEC = RecordCodecBuilder.create(p_229075_ -> p_229075_.group((App)LargeAercloudStructure.method_42697((RecordCodecBuilder.Instance)p_229075_), (App)class_4651.field_24937.fieldOf("blocks").forGetter(structure -> structure.blocks), (App)Codec.INT.fieldOf("size").forGetter(structure -> structure.size), (App)Codec.INT.fieldOf("rangeY").forGetter(o -> o.rangeY)).apply((Applicative)p_229075_, LargeAercloudStructure::new));
    private final class_4651 blocks;
    private final int size;
    private final int rangeY;

    public LargeAercloudStructure(class_3195.class_7302 settings, class_4651 blocks, int size, int rangeY) {
        super(settings);
        this.blocks = blocks;
        this.size = size;
        this.rangeY = rangeY;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        return class_3195.method_41612((class_3195.class_7149)context, (class_2902.class_2903)class_2902.class_2903.field_13194, builder -> LargeAercloudStructure.generatePieces(builder, context, this.blocks, this.size, this.rangeY));
    }

    private static void generatePieces(class_6626 builder, class_3195.class_7149 context, class_4651 blocks, int size, int rangeY) {
        LinkedHashMap<class_1923, Set> chunks = new LinkedHashMap<class_1923, Set>();
        LinkedHashSet<class_2338> positions = new LinkedHashSet<class_2338>();
        class_2919 random = context.comp_566();
        boolean direction = random.method_43056();
        int initialY = context.comp_569().method_31607() + context.comp_566().method_43048(rangeY);
        int x = context.comp_568().method_8326();
        int y = initialY;
        int z = context.comp_568().method_8328();
        int xTendency = random.method_43048(3) - 1;
        int zTendency = random.method_43048(3) - 1;
        for (int amount = 0; amount < 64; ++amount) {
            y += random.method_43048(10) == 0 ? random.method_43048(3) - 1 : 0;
            z += direction ? random.method_43048(3) - 1 + zTendency : -(random.method_43048(3) - 1 + zTendency);
            for (int x1 = x += random.method_43048(3) - 1 + xTendency; x1 < x + random.method_43048(4) + 3 * size; ++x1) {
                for (int y1 = y; y1 < y + random.method_43048(1) + 2; ++y1) {
                    for (int z1 = z; z1 < z + random.method_43048(4) + 3 * size; ++z1) {
                        class_2338 newPosition = new class_2338(x1, y1, z1);
                        if (Math.abs(x1 - x) + Math.abs(y1 - y) + Math.abs(z1 - z) >= 4 * size + random.method_43048(2)) continue;
                        positions.add(newPosition);
                        chunks.putIfAbsent(new class_1923(newPosition), new HashSet());
                    }
                }
            }
        }
        chunks.forEach((chunkPos, blockPosSet) -> {
            LinkedHashSet<class_2338> withinChunk = new LinkedHashSet<class_2338>(positions);
            withinChunk.removeIf(pos -> !new class_1923(pos).equals(chunkPos));
            blockPosSet.addAll(withinChunk);
        });
        int finalY = y;
        class_2350 orientation = class_2350.class_2353.field_11062.method_10183((class_5819)context.comp_566());
        chunks.forEach((chunkPos, blockPosSet) -> {
            class_3341 boundingBox = new class_3341(chunkPos.method_8326(), Math.max(initialY - 16, 0), chunkPos.method_8328(), chunkPos.method_8327(), finalY + 16, chunkPos.method_8329());
            builder.method_35462((class_3443)new LargeAercloudChunk((Set<class_2338>)blockPosSet, blocks, boundingBox, orientation));
        });
    }

    public class_7151<?> method_41618() {
        return (class_7151)AetherStructureTypes.LARGE_AERCLOUD.get();
    }
}

