/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe.serializer;

import com.aetherteam.aether.recipe.recipes.block.AbstractBiomeParameterRecipe;
import com.aetherteam.nitrogen.recipe.BlockPropertyPair;
import com.aetherteam.nitrogen.recipe.BlockStateIngredient;
import com.aetherteam.nitrogen.recipe.BlockStateRecipeUtil;
import com.aetherteam.nitrogen.recipe.serializer.BlockStateRecipeSerializer;
import com.google.gson.JsonObject;
import net.minecraft.class_1959;
import net.minecraft.class_2158;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class BiomeParameterRecipeSerializer<T extends AbstractBiomeParameterRecipe>
extends BlockStateRecipeSerializer<T> {
    private final CookieBaker<T> factory;

    public BiomeParameterRecipeSerializer(CookieBaker<T> factory, BlockStateRecipeSerializer.CookieBaker<T> superFactory) {
        super(superFactory);
        this.factory = factory;
    }

    public T fromJson(class_2960 id, JsonObject json) {
        Pair biomeRecipeData = BlockStateRecipeUtil.biomeRecipeDataFromJson((JsonObject)json);
        class_5321 biomeKey = (class_5321)biomeRecipeData.getLeft();
        class_6862 biomeTag = (class_6862)biomeRecipeData.getRight();
        AbstractBiomeParameterRecipe recipe = (AbstractBiomeParameterRecipe)super.fromJson(id, json);
        return this.factory.create(id, (class_5321<class_1959>)biomeKey, (class_6862<class_1959>)biomeTag, recipe.getIngredient(), recipe.getResult(), recipe.getFunction());
    }

    @Nullable
    public T fromNetwork(class_2960 id, class_2540 buffer) {
        class_5321 biomeKey = BlockStateRecipeUtil.readBiomeKey((class_2540)buffer);
        class_6862 biomeTag = BlockStateRecipeUtil.readBiomeTag((class_2540)buffer);
        BlockStateIngredient ingredient = BlockStateIngredient.fromNetwork((class_2540)buffer);
        BlockPropertyPair result = BlockStateRecipeUtil.readPair((class_2540)buffer);
        class_2158.class_2159 function = BlockStateRecipeUtil.readFunction((class_2540)buffer);
        return this.factory.create(id, (class_5321<class_1959>)biomeKey, (class_6862<class_1959>)biomeTag, ingredient, result, function);
    }

    public void toNetwork(class_2540 buffer, T recipe) {
        BlockStateRecipeUtil.writeBiomeKey((class_2540)buffer, ((AbstractBiomeParameterRecipe)((Object)recipe)).getBiomeKey());
        BlockStateRecipeUtil.writeBiomeTag((class_2540)buffer, ((AbstractBiomeParameterRecipe)((Object)recipe)).getBiomeTag());
        super.toNetwork(buffer, recipe);
    }

    public static interface CookieBaker<T extends AbstractBiomeParameterRecipe> {
        public T create(class_2960 var1, @Nullable class_5321<class_1959> var2, @Nullable class_6862<class_1959> var3, BlockStateIngredient var4, BlockPropertyPair var5, @Nullable class_2158.class_2159 var6);
    }
}

