/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.miscellaneous;

import com.aetherteam.aether.api.registers.MoaType;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.mixin.mixins.common.accessor.BaseSpawnerAccessor;
import com.google.common.collect.Iterables;
import io.github.fabricators_of_create.porting_lib.util.RegistryObject;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3468;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class MoaEggItem
extends class_1792 {
    private static final Map<Supplier<? extends MoaType>, MoaEggItem> BY_ID = new IdentityHashMap<Supplier<? extends MoaType>, MoaEggItem>();
    private final Supplier<? extends MoaType> moaType;
    private final class_2960 moaTypeId;
    private final int color;

    public MoaEggItem(RegistryObject<? extends MoaType> moaType, int shellColor, class_1792.class_1793 properties) {
        this((Supplier<? extends MoaType>)moaType, moaType.getId(), shellColor, properties);
    }

    public MoaEggItem(Supplier<? extends MoaType> moaType, class_2960 moaTypeId, int shellColor, class_1792.class_1793 properties) {
        super(properties);
        this.moaType = moaType;
        this.moaTypeId = moaTypeId;
        this.color = shellColor;
        BY_ID.put(moaType, this);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1799 itemStack = context.method_8041();
        class_1657 player = context.method_8036();
        if (player != null && player.method_7337()) {
            class_2586 blockEntity;
            class_1937 level = context.method_8045();
            if (!(level instanceof class_3218)) {
                return class_1269.field_5812;
            }
            class_3218 serverLevel = (class_3218)level;
            class_2338 blockPos = context.method_8037();
            class_2350 direction = context.method_8038();
            class_2680 blockState = level.method_8320(blockPos);
            if (blockState.method_27852(class_2246.field_10260) && (blockEntity = level.method_8321(blockPos)) instanceof class_2636) {
                class_2636 spawnerBlockEntity = (class_2636)blockEntity;
                BaseSpawnerAccessor baseSpawnerAccessor = (BaseSpawnerAccessor)spawnerBlockEntity.method_11390();
                class_1299 entityType = (class_1299)AetherEntityTypes.MOA.get();
                spawnerBlockEntity.method_46408(entityType, level.method_8409());
                baseSpawnerAccessor.aether$getNextSpawnData().method_38093().method_10582("MoaType", this.getMoaTypeId().toString());
                baseSpawnerAccessor.aether$getNextSpawnData().method_38093().method_10556("PlayerGrown", true);
                blockEntity.method_5431();
                level.method_8413(blockPos, blockState, blockState, 3);
                itemStack.method_7934(1);
                return class_1269.field_21466;
            }
            class_2338 relativePos = blockState.method_26220((class_1922)level, blockPos).method_1110() ? blockPos : blockPos.method_10093(direction);
            class_1799 spawnStack = this.getStackWithTags(itemStack, false, this.getMoaType(), false, true);
            class_1297 entity = ((class_1299)AetherEntityTypes.MOA.get()).method_5894(serverLevel, spawnStack, player, relativePos, class_3730.field_16465, true, !Objects.equals(blockPos, relativePos) && direction == class_2350.field_11036);
            if (entity != null) {
                level.method_33596((class_1297)player, class_5712.field_28738, blockPos);
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5814;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 heldStack = player.method_5998(hand);
        if (player.method_7337()) {
            class_3965 hitResult = MoaEggItem.method_7872((class_1937)level, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1345);
            if (hitResult.method_17783() != class_239.class_240.field_1332) {
                return class_1271.method_22430((Object)heldStack);
            }
            if (!(level instanceof class_3218)) {
                return class_1271.method_22431((Object)heldStack);
            }
            class_3218 serverLevel = (class_3218)level;
            class_2338 blockpos = hitResult.method_17777();
            if (!(level.method_8320(blockpos).method_26204() instanceof class_2404)) {
                return class_1271.method_22430((Object)heldStack);
            }
            if (level.method_8505(player, blockpos) && player.method_7343(blockpos, hitResult.method_17780(), heldStack)) {
                class_1799 spawnStack = this.getStackWithTags(heldStack, false, this.getMoaType(), false, true);
                class_1297 entity = ((class_1299)AetherEntityTypes.MOA.get()).method_5894(serverLevel, spawnStack, player, blockpos, class_3730.field_16465, false, false);
                if (entity == null) {
                    return class_1271.method_22430((Object)heldStack);
                }
                player.method_7259(class_3468.field_15372.method_14956((Object)this));
                level.method_33596((class_1297)player, class_5712.field_28738, blockpos);
                return class_1271.method_22428((Object)heldStack);
            }
            return class_1271.method_22431((Object)heldStack);
        }
        return class_1271.method_22431((Object)heldStack);
    }

    public class_1799 getStackWithTags(class_1799 stack, boolean isBaby, MoaType moaType, boolean isHungry, boolean isPlayerGrown) {
        class_1799 itemStack = stack.method_7972();
        class_2487 tag = itemStack.method_7948();
        tag.method_10556("IsBaby", isBaby);
        tag.method_10582("MoaType", moaType.toString());
        tag.method_10556("Hungry", isHungry);
        tag.method_10556("PlayerGrown", isPlayerGrown);
        return itemStack;
    }

    @Environment(value=EnvType.CLIENT)
    public int getColor() {
        return this.color;
    }

    public MoaType getMoaType() {
        return this.moaType.get();
    }

    public class_2960 getMoaTypeId() {
        return this.moaTypeId;
    }

    @Nullable
    public static MoaEggItem byId(MoaType moaType) {
        if (moaType != null) {
            for (Supplier<? extends MoaType> holder : BY_ID.keySet()) {
                if (!moaType.getId().equals((Object)holder.get().getId())) continue;
                return BY_ID.get(holder);
            }
        }
        return null;
    }

    public static Iterable<MoaEggItem> moaEggs() {
        return Iterables.unmodifiableIterable(BY_ID.values());
    }
}

