/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.hooks;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.capability.AetherCapabilities;
import com.aetherteam.aether.capability.accessory.MobAccessory;
import com.aetherteam.aether.capability.item.DroppedItem;
import com.aetherteam.aether.capability.lightning.LightningTracker;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.ai.goal.BeeGrowBerryBushGoal;
import com.aetherteam.aether.entity.ai.goal.FoxEatBerryBushGoal;
import com.aetherteam.aether.entity.monster.Swet;
import com.aetherteam.aether.entity.monster.dungeon.boss.Slider;
import com.aetherteam.aether.entity.monster.dungeon.boss.ValkyrieQueen;
import com.aetherteam.aether.entity.passive.FlyingCow;
import com.aetherteam.aether.entity.passive.MountableAnimal;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.accessories.AccessoryItem;
import com.aetherteam.aether.item.accessories.cape.CapeItem;
import com.aetherteam.aether.item.accessories.gloves.GlovesItem;
import com.aetherteam.aether.item.accessories.miscellaneous.ShieldOfRepulsionItem;
import com.aetherteam.aether.item.accessories.pendant.PendantItem;
import com.aetherteam.aether.item.miscellaneous.bucket.SkyrootBucketItem;
import com.aetherteam.aether.utils.FabricUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1429;
import net.minecraft.class_1430;
import net.minecraft.class_1531;
import net.minecraft.class_1536;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_174;
import net.minecraft.class_1740;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3966;
import net.minecraft.class_4019;
import net.minecraft.class_4466;
import net.minecraft.class_5328;
import net.minecraft.class_5418;
import net.minecraft.class_5761;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class EntityHooks {
    public static void addGoals(class_1297 entity) {
        if (entity.getClass() == class_4466.class) {
            class_4466 bee = (class_4466)entity;
            bee.method_35163().method_6277(7, (class_1352)new BeeGrowBerryBushGoal(bee));
        } else if (entity.getClass() == class_4019.class) {
            class_4019 fox = (class_4019)entity;
            fox.field_6201.method_6277(10, (class_1352)new FoxEatBerryBushGoal(fox, 1.2f, 12, 1));
        }
    }

    public static boolean canMobSpawnWithAccessories(class_1297 entity) {
        class_1299 entityType = entity.method_5864();
        return entity instanceof class_1308 && (entityType == class_1299.field_6051 || entityType == class_1299.field_6054 || entityType == class_1299.field_6071 || entityType == class_1299.field_6137 || entityType == class_1299.field_6098 || entityType == class_1299.field_22281);
    }

    public static void spawnWithAccessories(class_1297 entity, class_1266 difficulty) {
        class_1308 mob;
        if (entity instanceof class_1308 && (mob = (class_1308)entity).method_37908() instanceof class_3218) {
            class_5819 random = mob.method_6051();
            class_1299 entityType = mob.method_5864();
            String[] allSlots = new String[]{"hands", "necklace", "aether_gloves", "aether_pendant"};
            String[] gloveSlots = new String[]{"hands", "aether_gloves"};
            if (entityType == class_1299.field_22281) {
                class_5418 abstractPiglin;
                if (mob instanceof class_5418 && (abstractPiglin = (class_5418)mob).method_30236()) {
                    for (String identifier : allSlots) {
                        if (!(random.method_43057() < 0.1f)) continue;
                        EntityHooks.equipAccessory(mob, identifier, class_1740.field_7895);
                    }
                }
            } else {
                class_1738 armorItem;
                String[] stringArray;
                class_1792 class_17922;
                boolean fullyArmored = true;
                for (class_1304 equipmentslot : class_1304.values()) {
                    class_1799 itemStack;
                    if (equipmentslot.method_5925() != class_1304.class_1305.field_6178 || !(itemStack = mob.method_6118(equipmentslot)).method_7960()) continue;
                    fullyArmored = false;
                    break;
                }
                if (fullyArmored && random.method_43048(4) == 1 && (class_17922 = mob.method_6118(class_1304.field_6174).method_7909()) instanceof class_1738 && (stringArray = (armorItem = (class_1738)class_17922).method_7686()) instanceof class_1740) {
                    class_1740 armorMaterials = (class_1740)stringArray;
                    for (String identifier : gloveSlots) {
                        EntityHooks.equipAccessory(mob, identifier, armorMaterials);
                    }
                }
            }
            EntityHooks.enchantAccessories(mob, difficulty, allSlots);
        }
    }

    private static void equipAccessory(class_1308 mob, String identifier, class_1740 armorMaterials) {
        SlotType slotType;
        AccessoriesCapability handler = mob.accessoriesCapability();
        if (handler != null && (slotType = SlotTypeLoader.getSlotType((class_1309)mob, (String)identifier)) != null) {
            AccessoriesContainer container = handler.getContainer(slotType);
            boolean empty = true;
            if (container != null) {
                class_1792 item;
                ExpandedSimpleContainer stackHandler = container.getAccessories();
                for (class_1799 slotResult : stackHandler.field_5828) {
                    if (slotResult.method_7960()) continue;
                    empty = false;
                }
                if (empty && (item = EntityHooks.getEquipmentForSlot(identifier, armorMaterials)) != null) {
                    stackHandler.method_5447(0, new class_1799((class_1935)item));
                }
            }
        }
    }

    @Nullable
    private static class_1792 getEquipmentForSlot(String identifier, class_1740 armorMaterials) {
        if (identifier.equals((Boolean)AetherConfig.COMMON.use_curios_menu.get() != false ? "hands" : "aether_gloves")) {
            switch (armorMaterials) {
                case field_7897: {
                    return (class_1792)AetherItems.LEATHER_GLOVES.get();
                }
                case field_7895: {
                    return (class_1792)AetherItems.GOLDEN_GLOVES.get();
                }
                case field_7887: {
                    return (class_1792)AetherItems.CHAINMAIL_GLOVES.get();
                }
                case field_7892: {
                    return (class_1792)AetherItems.IRON_GLOVES.get();
                }
                case field_7889: {
                    return (class_1792)AetherItems.DIAMOND_GLOVES.get();
                }
            }
        } else if (identifier.equals((Boolean)AetherConfig.COMMON.use_curios_menu.get() != false ? "necklace" : "aether_pendant")) {
            switch (armorMaterials) {
                case field_7895: {
                    return (class_1792)AetherItems.GOLDEN_PENDANT.get();
                }
                case field_7892: {
                    return (class_1792)AetherItems.IRON_PENDANT.get();
                }
            }
        }
        return null;
    }

    private static void enchantAccessories(class_1308 mob, class_1266 difficulty, String[] allowedSlots) {
        class_5819 random = mob.method_6051();
        float chanceMultiplier = difficulty.method_5458();
        for (String identifier : allowedSlots) {
            ExpandedSimpleContainer stackHandler;
            class_1799 itemStack;
            AccessoriesContainer container;
            SlotType slotType;
            AccessoriesCapability handler = mob.accessoriesCapability();
            if (handler == null || (slotType = SlotTypeLoader.getSlotType((class_1309)mob, (String)identifier)) == null || (container = handler.getContainer(slotType)) == null || (itemStack = (stackHandler = container.getAccessories()).method_5438(0)).method_7960() || !(random.method_43057() < 0.5f * chanceMultiplier)) continue;
            stackHandler.method_5447(0, class_1890.method_8233((class_5819)random, (class_1799)itemStack, (int)((int)(5.0f + chanceMultiplier * (float)random.method_43048(18))), (boolean)false));
        }
    }

    public static boolean dismountPrevention(class_1297 rider, class_1297 mount, boolean dismounting) {
        if (dismounting && rider.method_5715()) {
            Swet swet;
            return mount instanceof MountableAnimal && !mount.method_24828() && !FabricUtils.isInFluidType(mount) && !mount.method_5765() || mount instanceof Swet && !(swet = (Swet)mount).isFriendly();
        }
        return false;
    }

    public static void launchMount(class_1657 player) {
        class_1297 mount = player.method_5854();
        if (player.method_5765() && mount != null && mount.method_37908().method_29546(mount.method_5829()).anyMatch(state -> state.method_27852((class_2248)AetherBlocks.BLUE_AERCLOUD.get())) && player.method_37908().method_8608()) {
            mount.method_18800(mount.method_18798().method_10216(), 2.0, mount.method_18798().method_10215());
        }
    }

    public static void skyrootBucketMilking(class_1297 target, class_1657 player, class_1268 hand) {
        class_1799 heldStack;
        if ((target instanceof class_1430 || target instanceof FlyingCow) && !((class_1429)target).method_6109() && (heldStack = player.method_5998(hand)).method_31574((class_1792)AetherItems.SKYROOT_BUCKET.get())) {
            if (target instanceof FlyingCow) {
                player.method_5783((class_3414)AetherSoundEvents.ENTITY_FLYING_COW_MILK.get(), 1.0f, 1.0f);
            } else {
                player.method_5783(class_3417.field_14691, 1.0f, 1.0f);
            }
            class_1799 filledBucket = class_5328.method_30012((class_1799)heldStack, (class_1657)player, (class_1799)((class_1792)AetherItems.SKYROOT_MILK_BUCKET.get()).method_7854());
            player.method_6104(hand);
            player.method_6122(hand, filledBucket);
        }
    }

    public static Optional<class_1269> pickupBucketable(class_1297 target, class_1657 player, class_1268 hand) {
        class_1799 heldStack = player.method_5998(hand);
        Optional<class_1269> interactionResult = Optional.empty();
        if (heldStack.method_31574((class_1792)AetherItems.SKYROOT_WATER_BUCKET.get()) && target instanceof class_5761) {
            class_1309 livingEntity;
            class_5761 bucketable = (class_5761)target;
            if (target instanceof class_1309 && (livingEntity = (class_1309)target).method_5805()) {
                class_1799 bucketStack = bucketable.method_6452();
                if (!(bucketStack = SkyrootBucketItem.swapBucketType(bucketStack)).method_7960()) {
                    target.method_5783(bucketable.method_35171(), 1.0f, 1.0f);
                    bucketable.method_6455(bucketStack);
                    class_1799 filledStack = class_5328.method_30270((class_1799)heldStack, (class_1657)player, (class_1799)bucketStack, (boolean)false);
                    player.method_6122(hand, filledStack);
                    class_1937 level = livingEntity.method_37908();
                    if (!level.method_8608()) {
                        class_174.field_1208.method_8932((class_3222)player, bucketStack);
                    }
                    target.method_31472();
                    interactionResult = Optional.of(class_1269.method_29236((boolean)level.method_8608()));
                } else {
                    interactionResult = Optional.of(class_1269.field_5814);
                }
            }
        }
        return interactionResult;
    }

    public static Optional<class_1269> interactWithArmorStand(class_1297 target, class_1657 player, class_1799 stack, class_243 pos, class_1268 hand) {
        if (target instanceof class_1531) {
            class_1531 armorStand = (class_1531)target;
            if (armorStand.method_37908().method_8608()) {
                return Optional.of(class_1269.field_5812);
            }
            if (!stack.method_7960()) {
                if (stack.method_31573(AetherTags.Items.ACCESSORIES)) {
                    ExpandedSimpleContainer stackHandler;
                    AccessoriesContainer stacksHandler;
                    SlotType slotType;
                    String identifier = "";
                    if (stack.method_7909() instanceof GlovesItem) {
                        identifier = (Boolean)AetherConfig.COMMON.use_curios_menu.get() != false ? "hands" : "aether_gloves";
                    } else if (stack.method_7909() instanceof PendantItem) {
                        identifier = (Boolean)AetherConfig.COMMON.use_curios_menu.get() != false ? "necklace" : "aether_pendant";
                    } else if (stack.method_7909() instanceof CapeItem) {
                        identifier = (Boolean)AetherConfig.COMMON.use_curios_menu.get() != false ? "back" : "aether_cape";
                    } else if (stack.method_7909() instanceof ShieldOfRepulsionItem) {
                        identifier = (Boolean)AetherConfig.COMMON.use_curios_menu.get() != false ? "body" : "aether_shield";
                    }
                    AccessoriesCapability handler = armorStand.accessoriesCapability();
                    if (handler != null && (slotType = SlotTypeLoader.getSlotType((class_1309)armorStand, (String)identifier)) != null && (stacksHandler = handler.getContainer(slotType)) != null && 0 < (stackHandler = stacksHandler.getCosmeticAccessories()).method_5439()) {
                        SlotReference slotContext;
                        AccessoryItem accessoryItem;
                        class_1799 itemStack = stackHandler.method_5438(0);
                        class_1792 class_17922 = stack.method_7909();
                        if (class_17922 instanceof AccessoryItem && (accessoryItem = (AccessoryItem)class_17922).canEquip(stack, slotContext = stacksHandler.createReference(0))) {
                            stackHandler.method_5447(0, stack.method_7972());
                            if (accessoryItem instanceof GlovesItem) {
                                GlovesItem glovesItem = (GlovesItem)accessoryItem;
                                armorStand.method_37908().method_8396(null, armorStand.method_24515(), glovesItem.getEquipSound(stack, slotContext).event(), armorStand.method_5634(), 1.0f, 1.0f);
                            } else if (accessoryItem instanceof PendantItem) {
                                PendantItem pendantItem = (PendantItem)accessoryItem;
                                armorStand.method_37908().method_8396(null, armorStand.method_24515(), pendantItem.getEquipSound(stack, slotContext).event(), armorStand.method_5634(), 1.0f, 1.0f);
                            } else {
                                armorStand.method_37908().method_8396(null, armorStand.method_24515(), class_3417.field_14883, armorStand.method_5634(), 1.0f, 1.0f);
                            }
                            if (identifier.equals("hands") || identifier.equals("aether_gloves")) {
                                armorStand.method_6913(true);
                            }
                            if (!player.method_7337()) {
                                int count = stack.method_7947();
                                stack.method_7934(count);
                            }
                            if (!itemStack.method_7960()) {
                                player.method_6122(hand, itemStack);
                            }
                            return Optional.of(class_1269.field_5812);
                        }
                    }
                }
            } else {
                class_1799 itemStack;
                ExpandedSimpleContainer stackHandler;
                AccessoriesContainer stacksHandler;
                SlotType slotType;
                AccessoriesCapability handler;
                String identifier = EntityHooks.slotToUnequip(armorStand, pos);
                if (!identifier.isEmpty() && (handler = armorStand.accessoriesCapability()) != null && (slotType = SlotTypeLoader.getSlotType((class_1309)armorStand, (String)identifier)) != null && (stacksHandler = handler.getContainer(slotType)) != null && 0 < (stackHandler = stacksHandler.getCosmeticAccessories()).method_5439() && !(itemStack = stackHandler.method_5438(0)).method_7960()) {
                    player.method_6122(hand, itemStack);
                    stackHandler.method_5447(0, class_1799.field_8037);
                    return Optional.of(class_1269.field_5812);
                }
            }
        }
        return Optional.empty();
    }

    private static String slotToUnequip(class_1531 armorStand, class_243 pos) {
        String shieldIdentifier;
        boolean isSmall = armorStand.method_6914();
        class_2350.class_2351 axis = armorStand.method_5735().method_10166();
        double x = isSmall ? pos.field_1352 * 2.0 : pos.field_1352;
        double z = isSmall ? pos.field_1350 * 2.0 : pos.field_1350;
        double front = axis == class_2350.class_2351.field_11048 ? z : x;
        double vertical = isSmall ? pos.field_1351 * 2.0 : pos.field_1351;
        String glovesIdentifier = (Boolean)AetherConfig.COMMON.use_curios_menu.get() != false ? "hands" : "aether_gloves";
        String pendantIdentifier = (Boolean)AetherConfig.COMMON.use_curios_menu.get() != false ? "necklace" : "aether_pendant";
        String capeIdentifier = (Boolean)AetherConfig.COMMON.use_curios_menu.get() != false ? "back" : "aether_cape";
        String string = shieldIdentifier = (Boolean)AetherConfig.COMMON.use_curios_menu.get() != false ? "body" : "aether_shield";
        if (!EntityHooks.getItemByIdentifier(armorStand, glovesIdentifier).method_7960()) {
            double d = Math.abs(front);
            double d2 = isSmall ? 0.15 : 0.2;
            if (d >= d2) {
                double d3 = isSmall ? 0.65 : 0.75;
                if (vertical >= d3 && vertical < 1.15) {
                    return glovesIdentifier;
                }
            }
        }
        if (!EntityHooks.getItemByIdentifier(armorStand, pendantIdentifier).method_7960()) {
            double d = isSmall ? 1.2 : 1.3;
            if (vertical >= d) {
                double d4 = isSmall ? 0.8 : 0.6;
                if (vertical < 0.9 + d4) {
                    return pendantIdentifier;
                }
            }
        }
        if (!EntityHooks.getItemByIdentifier(armorStand, capeIdentifier).method_7960()) {
            double d = isSmall ? 1.0 : 1.1;
            if (vertical >= d) {
                double d5 = isSmall ? 1.7 : 1.4;
                if (vertical < d5) {
                    return capeIdentifier;
                }
            }
        }
        if (!EntityHooks.getItemByIdentifier(armorStand, shieldIdentifier).method_7960()) {
            double d = isSmall ? 0.9 : 1.0;
            if (vertical >= d) {
                double d6 = isSmall ? 1.5 : 1.2;
                if (vertical < d6) {
                    return shieldIdentifier;
                }
            }
        }
        return "";
    }

    private static class_1799 getItemByIdentifier(class_1531 armorStand, String identifier) {
        ExpandedSimpleContainer stackHandler;
        SlotType slotType;
        AccessoriesContainer stacksHandler;
        AccessoriesCapability handler = armorStand.accessoriesCapability();
        if (handler != null && (stacksHandler = handler.getContainer(slotType = SlotTypeLoader.getSlotType((class_1309)armorStand, (String)identifier))) != null && 0 < (stackHandler = stacksHandler.getCosmeticAccessories()).method_5439()) {
            return stackHandler.method_5438(0);
        }
        return class_1799.field_8037;
    }

    public static boolean preventEntityHooked(class_1297 projectileEntity, class_239 rayTraceResult) {
        if (rayTraceResult instanceof class_3966) {
            class_3966 entityHitResult = (class_3966)rayTraceResult;
            return entityHitResult.method_17782().method_5864().method_20210(AetherTags.Entities.UNHOOKABLE) && projectileEntity instanceof class_1536;
        }
        return false;
    }

    public static boolean preventSliderShieldBlock(class_1282 source) {
        return source.method_5529() instanceof Slider;
    }

    public static boolean lightningHitKeys(class_1297 entity) {
        if (entity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)entity;
            return itemEntity.method_6983().method_31573(AetherTags.Items.DUNGEON_KEYS);
        }
        return false;
    }

    public static boolean thunderCrystalHitItems(class_1297 entity, class_1538 lightning) {
        Optional<LightningTracker> lightningTrackerOptional;
        if (entity instanceof class_1542 && (lightningTrackerOptional = LightningTracker.get(lightning)).isPresent()) {
            LightningTracker lightningTracker = lightningTrackerOptional.get();
            return lightningTracker.getOwner() instanceof ValkyrieQueen;
        }
        return false;
    }

    public static void trackDrops(class_1309 entity, Collection<class_1542> itemDrops) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            itemDrops.forEach(itemEntity -> DroppedItem.get(itemEntity).ifPresent(droppedItem -> droppedItem.setOwner((class_1297)player)));
        }
    }

    public static List<class_1799> handleEntityAccessoryDrops(class_1309 entity, List<class_1799> itemStacks, boolean recentlyHit, int looting) {
        if (entity instanceof class_1308) {
            String[] allSlots;
            class_1308 mob = (class_1308)entity;
            for (String identifier : allSlots = new String[]{"hands", "necklace", "aether_gloves", "aether_pendant"}) {
                boolean flag;
                if (itemStacks.isEmpty()) continue;
                class_1799 itemStack = itemStacks.get(0);
                float f = ((MobAccessory)AetherCapabilities.MOB_ACCESSORY_CAPABILITY.maybeGet((Object)mob).orElseThrow()).getEquipmentDropChance(identifier);
                boolean bl = flag = f > 1.0f;
                if (!itemStack.method_7960()) {
                    itemStacks.removeIf(stack -> class_1799.method_31577((class_1799)stack, (class_1799)itemStack));
                }
                if (itemStack.method_7960() || class_1890.method_8221((class_1799)itemStack) || !recentlyHit || !(Math.max(mob.method_6051().method_43057() - (float)looting * 0.01f, 0.0f) < f)) continue;
                if (!flag && itemStack.method_7963()) {
                    itemStack.method_7974(itemStack.method_7936() - mob.method_6051().method_43048(1 + mob.method_6051().method_43048(Math.max(itemStack.method_7936() - 3, 1))));
                }
                itemStacks.add(itemStack);
            }
        }
        return itemStacks;
    }

    public static int modifyExperience(class_1309 entity, int experience) {
        class_1308 mob;
        Optional<MobAccessory> accessoryMobLazy;
        if (entity instanceof class_1308 && (accessoryMobLazy = MobAccessory.get(mob = (class_1308)entity)).isPresent()) {
            MobAccessory accessoryMob = accessoryMobLazy.get();
            AccessoriesCapability handler = mob.accessoriesCapability();
            if (handler != null && experience > 0) {
                String[] allSlots;
                for (String identifier : allSlots = new String[]{"hands", "necklace", "aether_gloves", "aether_pendant"}) {
                    class_1799 stack;
                    AccessoriesContainer accessoriesContainer = handler.getContainer(new SlotTypeReference(identifier));
                    if (accessoriesContainer == null || (stack = accessoriesContainer.getAccessories().method_5438(0)).method_7960() || !(accessoryMob.getEquipmentDropChance(identifier) <= 1.0f)) continue;
                    experience += 1 + mob.method_6051().method_43048(3);
                }
            }
        }
        return experience;
    }

    public static boolean preventInebriation(class_1309 livingEntity, class_1293 appliedInstance) {
        return livingEntity.method_6059((class_1291)AetherEffects.REMEDY.get()) && appliedInstance.method_5579() == AetherEffects.INEBRIATION.get();
    }
}

