/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.hooks;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.portal.AetherPortalForcer;
import com.aetherteam.aether.block.portal.AetherPortalShape;
import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.capability.time.AetherTime;
import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.aetherteam.aether.mixin.mixins.common.accessor.LevelAccessor;
import com.aetherteam.aether.mixin.mixins.common.accessor.ServerGamePacketListenerImplAccessor;
import com.aetherteam.aether.mixin.mixins.common.accessor.ServerLevelAccessor;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.clientbound.AetherTravelPacket;
import com.aetherteam.aether.network.packet.clientbound.LeavingAetherPacket;
import com.aetherteam.aether.world.AetherLevelData;
import com.aetherteam.aether.world.LevelUtil;
import com.aetherteam.nitrogen.network.BasePacket;
import com.aetherteam.nitrogen.network.PacketRelay;
import io.github.fabricators_of_create.porting_lib.entity.ITeleporter;
import java.util.Optional;
import me.pepperbell.simplenetworking.SimpleChannel;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5268;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class DimensionHooks {
    public static boolean playerLeavingAether;
    public static boolean displayAetherTravel;
    public static int teleportationTimer;

    public static void startInAether(class_1657 player) {
        AetherPlayer.getOptional(player).ifPresent(aetherPlayer -> {
            if (((Boolean)AetherConfig.SERVER.spawn_in_aether.get()).booleanValue()) {
                class_3222 serverPlayer;
                MinecraftServer server;
                class_3218 aetherLevel;
                class_1657 patt2766$temp;
                if (aetherPlayer.canSpawnInAether() && (patt2766$temp = aetherPlayer.getPlayer()) instanceof class_3222 && (aetherLevel = (server = (serverPlayer = (class_3222)patt2766$temp).method_37908().method_8503()).method_3847(AetherDimensions.AETHER_LEVEL)) != null && serverPlayer.method_37908().method_27983() != AetherDimensions.AETHER_LEVEL && aetherPlayer.getPlayer().changeDimension(aetherLevel, (ITeleporter)new AetherPortalForcer(aetherLevel, false, true)) != null) {
                    serverPlayer.method_26284(AetherDimensions.AETHER_LEVEL, serverPlayer.method_24515(), serverPlayer.method_36454(), true, false);
                    aetherPlayer.setCanSpawnInAether(false);
                }
            } else {
                aetherPlayer.setCanSpawnInAether(false);
            }
        });
    }

    public static boolean createPortal(class_1657 player, class_1937 level, class_2338 pos, @Nullable class_2350 direction, class_1799 stack, class_1268 hand) {
        if (direction != null) {
            Optional<AetherPortalShape> optional;
            class_2338 relativePos = pos.method_10093(direction);
            if (stack.method_31573(AetherTags.Items.AETHER_PORTAL_ACTIVATION_ITEMS) && (level.method_27983() == LevelUtil.returnDimension() || level.method_27983() == LevelUtil.destinationDimension()) && (optional = AetherPortalShape.findEmptyAetherPortalShape((class_1936)level, relativePos, class_2350.class_2351.field_11048)).isPresent()) {
                optional.get().createPortalBlocks();
                player.method_5783(class_3417.field_14834, 1.0f, 1.0f);
                player.method_6104(hand);
                if (!player.method_7337()) {
                    if (stack.method_7947() > 1) {
                        stack.method_7934(1);
                        player.method_7270(stack.getRecipeRemainder());
                    } else if (stack.method_7963()) {
                        stack.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
                    } else {
                        player.method_6122(hand, stack.getRecipeRemainder());
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static boolean detectWaterInFrame(class_1936 levelAccessor, class_2338 pos, class_2680 blockState, class_3610 fluidState) {
        if (levelAccessor instanceof class_1937) {
            Optional<AetherPortalShape> optional;
            class_1937 level = (class_1937)levelAccessor;
            if (fluidState.method_39360((class_3611)class_3612.field_15910) && fluidState.method_15759().method_26204() == blockState.method_26204() && (level.method_27983() == LevelUtil.returnDimension() || level.method_27983() == LevelUtil.destinationDimension()) && !((Boolean)AetherConfig.SERVER.disable_aether_portal.get()).booleanValue() && (optional = AetherPortalShape.findEmptyAetherPortalShape((class_1936)level, pos, class_2350.class_2351.field_11048)).isPresent()) {
                optional.get().createPortalBlocks();
                return true;
            }
        }
        return false;
    }

    public static void tickTime(class_1937 level) {
        if (level.method_8597().comp_655().equals((Object)AetherDimensions.AETHER_DIMENSION_TYPE.method_29177()) && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)serverLevel;
            LevelAccessor levelAccessor = (LevelAccessor)level;
            long i = levelAccessor.aether$getLevelData().method_188() + 1L;
            serverLevelAccessor.aether$getServerLevelData().method_29034(i);
            if (serverLevelAccessor.aether$getServerLevelData().method_146().method_8355(class_1928.field_19396)) {
                AetherTime.get(level).ifPresent(cap -> serverLevel.method_29199(cap.tickTime(level)));
            }
        }
    }

    public static void checkEternalDayConfig(class_1937 level) {
        if (!level.method_8608()) {
            AetherTime.get(level).ifPresent(aetherTime -> {
                boolean eternalDay = aetherTime.getEternalDay();
                if (((Boolean)AetherConfig.SERVER.disable_eternal_day.get()).booleanValue() && eternalDay) {
                    aetherTime.setEternalDay(false);
                    aetherTime.updateEternalDay();
                }
            });
        }
    }

    public static void dimensionTravel(class_1297 entity, class_5321<class_1937> dimension) {
        class_1657 player;
        if (entity instanceof class_1657 && !(player = (class_1657)entity).method_37908().method_8608()) {
            AetherPlayer.getOptional(player).ifPresent(aetherPlayer -> {
                if (!(((Boolean)AetherConfig.SERVER.spawn_in_aether.get()).booleanValue() && aetherPlayer.canSpawnInAether() || !entity.method_37908().method_23753(entity.method_24515()).method_40220(AetherTags.Biomes.DISPLAY_TRAVEL_TEXT))) {
                    if (entity.method_37908().method_27983() == LevelUtil.destinationDimension() && dimension == LevelUtil.returnDimension()) {
                        displayAetherTravel = true;
                        playerLeavingAether = true;
                        PacketRelay.sendToAll((SimpleChannel)AetherPacketHandler.INSTANCE, (BasePacket)new AetherTravelPacket(true));
                        PacketRelay.sendToAll((SimpleChannel)AetherPacketHandler.INSTANCE, (BasePacket)new LeavingAetherPacket(true));
                    } else if (entity.method_37908().method_27983() == LevelUtil.returnDimension() && dimension == LevelUtil.destinationDimension()) {
                        displayAetherTravel = true;
                        playerLeavingAether = false;
                        PacketRelay.sendToAll((SimpleChannel)AetherPacketHandler.INSTANCE, (BasePacket)new AetherTravelPacket(true));
                        PacketRelay.sendToAll((SimpleChannel)AetherPacketHandler.INSTANCE, (BasePacket)new LeavingAetherPacket(false));
                    } else {
                        displayAetherTravel = false;
                        PacketRelay.sendToAll((SimpleChannel)AetherPacketHandler.INSTANCE, (BasePacket)new AetherTravelPacket(false));
                    }
                }
            });
        }
    }

    public static void travelling(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (teleportationTimer > 0) {
                ServerGamePacketListenerImplAccessor serverGamePacketListenerImplAccessor = (ServerGamePacketListenerImplAccessor)serverPlayer.field_13987;
                serverGamePacketListenerImplAccessor.aether$setAboveGroundTickCount(0);
                serverGamePacketListenerImplAccessor.aether$setAboveGroundVehicleTickCount(0);
                --teleportationTimer;
            }
            if (teleportationTimer < 0 || serverPlayer.field_36331) {
                teleportationTimer = 0;
            }
        }
    }

    public static void initializeLevelData(MinecraftServer server, class_3218 serverLevel) {
        if (serverLevel.method_8597().comp_655().equals((Object)AetherDimensions.AETHER_DIMENSION_TYPE.method_29177())) {
            AetherTime.get((class_1937)serverLevel).ifPresent(cap -> {
                AetherLevelData levelData = new AetherLevelData(server.method_27728(), server.method_27728().method_27859(), cap.getDayTime());
                ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)serverLevel;
                LevelAccessor levelAccessor = (LevelAccessor)serverLevel;
                serverLevelAccessor.aether$setServerLevelData((class_5268)levelData);
                levelAccessor.aether$setLevelData((class_5269)levelData);
            });
        }
    }

    @Nullable
    public static Long finishSleep(class_1936 level, long newTime) {
        if (level instanceof class_3218 && level.method_8597().comp_655().equals((Object)AetherDimensions.AETHER_DIMENSION_TYPE.method_29177())) {
            ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)level;
            serverLevelAccessor.aether$getServerLevelData().method_164(0);
            serverLevelAccessor.aether$getServerLevelData().method_157(false);
            serverLevelAccessor.aether$getServerLevelData().method_173(0);
            serverLevelAccessor.aether$getServerLevelData().method_147(false);
            long time = newTime + 48000L;
            return time - time % 72000L;
        }
        return null;
    }

    public static boolean isEternalDay(class_1657 player) {
        Optional<AetherTime> aetherTimeOptional;
        if (player.method_37908().method_8597().comp_655().equals((Object)AetherDimensions.AETHER_DIMENSION_TYPE.method_29177()) && (aetherTimeOptional = AetherTime.get(player.method_37908())).isPresent()) {
            AetherTime aetherTime = aetherTimeOptional.get();
            return aetherTime.getEternalDay();
        }
        return false;
    }
}

