/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.passive;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.api.AetherMoaTypes;
import com.aetherteam.aether.api.registers.MoaType;
import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.EntityUtil;
import com.aetherteam.aether.entity.WingedBird;
import com.aetherteam.aether.entity.ai.goal.ContinuousMeleeAttackGoal;
import com.aetherteam.aether.entity.ai.goal.FallingRandomStrollGoal;
import com.aetherteam.aether.entity.ai.goal.MoaFollowGoal;
import com.aetherteam.aether.entity.ai.navigator.FallPathNavigation;
import com.aetherteam.aether.entity.monster.AechorPlant;
import com.aetherteam.aether.entity.monster.Swet;
import com.aetherteam.aether.entity.passive.MountableAnimal;
import com.aetherteam.aether.event.AetherEventDispatch;
import com.aetherteam.aether.event.EggLayEvent;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.miscellaneous.MoaEggItem;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.clientbound.MoaInteractPacket;
import com.aetherteam.aether.perk.data.ServerPerkData;
import com.aetherteam.aether.perk.types.MoaData;
import com.aetherteam.nitrogen.capability.INBTSynchable;
import com.aetherteam.nitrogen.network.BasePacket;
import com.aetherteam.nitrogen.network.PacketRelay;
import io.github.fabricators_of_create.porting_lib.attributes.PortingLibAttributes;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import me.pepperbell.simplenetworking.SimpleChannel;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1324;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public class Moa
extends MountableAnimal
implements WingedBird {
    private static final class_2940<Optional<UUID>> DATA_MOA_UUID_ID = class_2945.method_12791(Moa.class, (class_2941)class_2943.field_13313);
    private static final class_2940<String> DATA_MOA_TYPE_ID = class_2945.method_12791(Moa.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Optional<UUID>> DATA_RIDER_UUID = class_2945.method_12791(Moa.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Optional<UUID>> DATA_LAST_RIDER_UUID = class_2945.method_12791(Moa.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Integer> DATA_REMAINING_JUMPS_ID = class_2945.method_12791(Moa.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> DATA_HUNGRY_ID = class_2945.method_12791(Moa.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DATA_AMOUNT_FED_ID = class_2945.method_12791(Moa.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> DATA_PLAYER_GROWN_ID = class_2945.method_12791(Moa.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_SITTING_ID = class_2945.method_12791(Moa.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Optional<UUID>> DATA_FOLLOWING_ID = class_2945.method_12791(Moa.class, (class_2941)class_2943.field_13313);
    private float wingRotation;
    private float prevWingRotation;
    private float destPos;
    private float prevDestPos;
    private int jumpCooldown;
    private int flapCooldown;
    private int eggTime = this.getEggTime();

    public Moa(class_1299<? extends Moa> type, class_1937 level) {
        super(type, level);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_3, -1.0f);
        this.method_5941(class_7.field_36432, -1.0f);
        this.method_5941(class_7.field_33534, -1.0f);
        this.method_5941(class_7.field_5, -1.0f);
        this.method_5941(class_7.field_17, -1.0f);
        this.method_5941(class_7.field_14, -1.0f);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 0.65));
        this.field_6201.method_6277(2, (class_1352)new MoaFollowGoal(this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new ContinuousMeleeAttackGoal((class_1314)this, 1.0, true));
        this.field_6201.method_6277(4, (class_1352)new FallingRandomStrollGoal((class_1314)this, 0.35));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, Swet.class, false, livingEntity -> {
            Swet swet;
            return this.getFollowing() == null && this.isPlayerGrown() && !this.method_6109() && livingEntity instanceof Swet && !(swet = (Swet)livingEntity).isFriendly();
        }));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, AechorPlant.class, false, livingEntity -> this.getFollowing() == null && this.isPlayerGrown() && !this.method_6109()));
    }

    protected class_1408 method_5965(class_1937 level) {
        return new FallPathNavigation((class_1308)this, level);
    }

    public static class_5132.class_5133 createMobAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 35.0).method_26868(class_5134.field_23719, 1.0).method_26868(class_5134.field_23717, 16.0).method_26868(class_5134.field_23721, 5.0);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(DATA_MOA_UUID_ID, Optional.empty());
        this.method_5841().method_12784(DATA_MOA_TYPE_ID, (Object)"");
        this.method_5841().method_12784(DATA_RIDER_UUID, Optional.empty());
        this.method_5841().method_12784(DATA_LAST_RIDER_UUID, Optional.empty());
        this.method_5841().method_12784(DATA_REMAINING_JUMPS_ID, (Object)0);
        this.method_5841().method_12784(DATA_HUNGRY_ID, (Object)false);
        this.method_5841().method_12784(DATA_AMOUNT_FED_ID, (Object)0);
        this.method_5841().method_12784(DATA_PLAYER_GROWN_ID, (Object)false);
        this.method_5841().method_12784(DATA_SITTING_ID, (Object)false);
        this.method_5841().method_12784(DATA_FOLLOWING_ID, Optional.empty());
    }

    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 tag) {
        this.generateMoaUUID();
        if (tag != null) {
            MoaType moaType;
            if (tag.method_10545("IsBaby")) {
                this.method_7217(tag.method_10577("IsBaby"));
            }
            if (tag.method_10545("MoaType") && (moaType = AetherMoaTypes.get(tag.method_10558("MoaType"))) != null) {
                this.setMoaType(moaType);
            }
            if (tag.method_10545("Hungry")) {
                this.setHungry(tag.method_10577("Hungry"));
            }
            if (tag.method_10545("PlayerGrown")) {
                this.setPlayerGrown(tag.method_10577("PlayerGrown"));
            }
        }
        if (spawnData == null) {
            spawnData = new class_1296.class_4697(false);
        }
        if (this.getMoaType() == null) {
            this.setMoaType(AetherMoaTypes.getWeightedChance(this.method_6051()));
        }
        return super.method_5943(level, difficulty, reason, spawnData, tag);
    }

    public void method_5674(class_2940<?> dataAccessor) {
        if (DATA_SITTING_ID.equals(dataAccessor)) {
            this.method_18382();
        }
        super.method_5674(dataAccessor);
    }

    public void method_6007() {
        super.method_6007();
        this.animateWings();
    }

    @Override
    public void method_5773() {
        class_1309 class_13092;
        super.method_5773();
        class_1324 gravity = this.method_5996(PortingLibAttributes.ENTITY_GRAVITY);
        if (gravity != null) {
            double max = this.method_5782() ? -0.5 : -0.1;
            double fallSpeed = Math.max(gravity.method_6194() * -1.25, max);
            if (this.method_18798().method_10214() < fallSpeed && !this.playerTriedToCrouch()) {
                this.method_18800(this.method_18798().method_10216(), fallSpeed, this.method_18798().method_10215());
                this.field_6007 = true;
                this.setEntityOnGround(false);
            }
        }
        if (this.method_24828()) {
            this.setRemainingJumps(this.getMaxJumps());
        }
        if (this.getJumpCooldown() > 0) {
            this.setJumpCooldown(this.getJumpCooldown() - 1);
            this.setPlayerJumped(false);
        } else if (this.getJumpCooldown() == 0) {
            this.setMountJumping(false);
        }
        if (!this.method_37908().method_8608() && this.method_5805()) {
            if (this.method_6051().method_43048(900) == 0 && this.field_6213 == 0) {
                this.method_6025(1.0f);
            }
            if (!this.method_6109() && this.method_5685().isEmpty() && --this.eggTime <= 0) {
                EggLayEvent eggLayEvent;
                MoaType moaType = this.getMoaType();
                if (moaType != null && !(eggLayEvent = AetherEventDispatch.onLayEgg((class_1297)this, (class_3414)AetherSoundEvents.ENTITY_MOA_EGG.get(), 1.0f, (this.method_6051().method_43057() - this.method_6051().method_43057()) * 0.2f + 1.0f, this.getMoaType().getEgg())).isCanceled()) {
                    if (eggLayEvent.getSound() != null) {
                        this.method_5783(eggLayEvent.getSound(), eggLayEvent.getVolume(), eggLayEvent.getPitch());
                    }
                    if (eggLayEvent.getItem() != null) {
                        this.method_5706((class_1935)eggLayEvent.getItem());
                    }
                }
                this.eggTime = this.getEggTime();
            }
        }
        if (this.method_6109()) {
            if (!this.isHungry()) {
                if (!this.method_37908().method_8608() && this.method_6051().method_43048(2000) == 0) {
                    this.setHungry(true);
                }
            } else if (this.method_6051().method_43048(10) == 0) {
                this.method_37908().method_8406((class_2394)class_2398.field_11231, this.method_23317() + (this.method_6051().method_43058() - 0.5) * (double)this.method_17681(), this.method_23318() + 1.0, this.method_23321() + (this.method_6051().method_43058() - 0.5) * (double)this.method_17681(), 0.0, 0.0, 0.0);
            }
        } else {
            this.setHungry(false);
            this.setAmountFed(0);
        }
        if ((class_13092 = this.method_5642()) instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (this.getRider() == null) {
                this.setRider(player.method_5667());
            }
        } else if (this.getRider() != null) {
            this.setRider(null);
        }
        if (this.getFlapCooldown() > 0) {
            this.setFlapCooldown(this.getFlapCooldown() - 1);
        } else if (this.getFlapCooldown() == 0 && !this.method_24828()) {
            this.method_37908().method_43129(null, (class_1297)this, (class_3414)AetherSoundEvents.ENTITY_MOA_FLAP.get(), class_3419.field_15254, 0.15f, class_3532.method_15363((float)this.method_6051().method_43057(), (float)0.7f, (float)1.0f) + class_3532.method_15363((float)this.method_6051().method_43057(), (float)0.0f, (float)0.3f));
            this.setFlapCooldown(15);
        }
        this.method_45318();
    }

    protected void method_5627(class_1297 passenger) {
        if (passenger instanceof class_1657) {
            class_1657 player = (class_1657)passenger;
            this.generateMoaUUID();
            if (this.getLastRider() == null || this.getLastRider() != player.method_5667()) {
                this.setLastRider(player.method_5667());
            }
            if (!player.method_37908().method_8608()) {
                AetherPlayer.getOptional(player).ifPresent(aetherPlayer -> aetherPlayer.setSynched(INBTSynchable.Direction.CLIENT, "setLastRiddenMoa", this.getMoaUUID()));
                Map<UUID, MoaData> userSkinsData = ServerPerkData.MOA_SKIN_INSTANCE.getServerPerkData(player.method_5682());
                if (userSkinsData.containsKey(this.getLastRider())) {
                    ServerPerkData.MOA_SKIN_INSTANCE.applyPerkWithVerification(player.method_5682(), this.getLastRider(), new MoaData(this.getMoaUUID(), userSkinsData.get(this.getLastRider()).moaSkin()));
                }
            }
        }
        super.method_5627(passenger);
    }

    @Override
    public void method_6091(class_243 vector) {
        if (!this.isSitting()) {
            super.method_6091(vector);
        } else if (this.method_5805()) {
            class_1309 entity = this.method_5642();
            if (this.method_5782() && this.method_6725() && entity != null) {
                EntityUtil.copyRotations((class_1297)this, (class_1297)entity);
                if (this.method_5787()) {
                    this.travelWithInput(new class_243(0.0, vector.method_10214(), 0.0));
                    this.field_6210 = 0;
                } else {
                    this.method_29242(false);
                    this.method_18799(class_243.field_1353);
                }
            } else {
                this.travelWithInput(new class_243(0.0, vector.method_10214(), 0.0));
            }
        }
    }

    @Override
    public void onJump(class_1308 mob) {
        super.onJump(mob);
        this.setJumpCooldown(10);
        if (!this.method_24828()) {
            this.setRemainingJumps(this.getRemainingJumps() - 1);
            this.spawnExplosionParticle();
        }
        this.setFlapCooldown(0);
    }

    @Override
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (this.isPlayerGrown() && itemStack.method_31574((class_1792)AetherItems.NATURE_STAFF.get())) {
            if (player.method_5715()) {
                if (this.getFollowing() == null) {
                    this.setFollowing(player.method_5667());
                } else {
                    this.setFollowing(null);
                }
            } else {
                itemStack.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
                this.setSitting(!this.isSitting());
                this.spawnExplosionParticle();
            }
            return class_1269.method_29236((boolean)this.method_37908().method_8608());
        }
        if (!this.method_37908().method_8608() && this.isPlayerGrown() && this.method_6109() && this.isHungry() && this.getAmountFed() < 3 && itemStack.method_31573(AetherTags.Items.MOA_FOOD_ITEMS)) {
            if (!player.method_31549().field_7477) {
                itemStack.method_7934(1);
            }
            this.setAmountFed(this.getAmountFed() + 1);
            switch (this.getAmountFed()) {
                case 0: {
                    this.method_5614(-24000);
                    break;
                }
                case 1: {
                    this.method_5614(-16000);
                    break;
                }
                case 2: {
                    this.method_5614(-8000);
                    break;
                }
                case 3: {
                    this.method_7217(false);
                }
            }
            if (this.getAmountFed() > 3 && !this.method_6109()) {
                this.method_7217(false);
            }
            this.setHungry(false);
            PacketRelay.sendToAll((SimpleChannel)AetherPacketHandler.INSTANCE, (BasePacket)new MoaInteractPacket(player.method_5628(), hand == class_1268.field_5808));
            return class_1269.field_21466;
        }
        if (this.isPlayerGrown() && !this.method_6109() && this.method_6032() < this.method_6063() && itemStack.method_31573(AetherTags.Items.MOA_FOOD_ITEMS)) {
            if (!player.method_31549().field_7477) {
                itemStack.method_7934(1);
            }
            this.method_6025(5.0f);
            return class_1269.method_29236((boolean)this.method_37908().method_8608());
        }
        return super.method_5992(player, hand);
    }

    public void spawnExplosionParticle() {
        for (int i = 0; i < 20; ++i) {
            EntityUtil.spawnMovementExplosionParticles((class_1297)this);
        }
    }

    public void generateMoaUUID() {
        if (this.getMoaUUID() == null) {
            this.setMoaUUID(UUID.randomUUID());
        }
    }

    @Nullable
    public UUID getMoaUUID() {
        return ((Optional)this.method_5841().method_12789(DATA_MOA_UUID_ID)).orElse(null);
    }

    private void setMoaUUID(@Nullable UUID uuid) {
        this.method_5841().method_12778(DATA_MOA_UUID_ID, Optional.ofNullable(uuid));
    }

    @Nullable
    public MoaType getMoaType() {
        return AetherMoaTypes.get((String)this.method_5841().method_12789(DATA_MOA_TYPE_ID));
    }

    public void setMoaType(MoaType moaType) {
        this.method_5841().method_12778(DATA_MOA_TYPE_ID, (Object)moaType.toString());
    }

    @Nullable
    public UUID getRider() {
        return ((Optional)this.method_5841().method_12789(DATA_RIDER_UUID)).orElse(null);
    }

    public void setRider(@Nullable UUID uuid) {
        this.method_5841().method_12778(DATA_RIDER_UUID, Optional.ofNullable(uuid));
    }

    @Nullable
    public UUID getLastRider() {
        return ((Optional)this.method_5841().method_12789(DATA_LAST_RIDER_UUID)).orElse(null);
    }

    public void setLastRider(@Nullable UUID uuid) {
        this.method_5841().method_12778(DATA_LAST_RIDER_UUID, Optional.ofNullable(uuid));
    }

    public int getRemainingJumps() {
        return (Integer)this.method_5841().method_12789(DATA_REMAINING_JUMPS_ID);
    }

    public void setRemainingJumps(int remainingJumps) {
        this.method_5841().method_12778(DATA_REMAINING_JUMPS_ID, (Object)remainingJumps);
    }

    public boolean isHungry() {
        return (Boolean)this.method_5841().method_12789(DATA_HUNGRY_ID);
    }

    public void setHungry(boolean hungry) {
        this.method_5841().method_12778(DATA_HUNGRY_ID, (Object)hungry);
    }

    public int getAmountFed() {
        return (Integer)this.method_5841().method_12789(DATA_AMOUNT_FED_ID);
    }

    public void setAmountFed(int amountFed) {
        this.method_5841().method_12778(DATA_AMOUNT_FED_ID, (Object)amountFed);
    }

    public boolean isPlayerGrown() {
        return (Boolean)this.method_5841().method_12789(DATA_PLAYER_GROWN_ID);
    }

    public void setPlayerGrown(boolean playerGrown) {
        this.method_5841().method_12778(DATA_PLAYER_GROWN_ID, (Object)playerGrown);
    }

    public boolean isSitting() {
        return (Boolean)this.method_5841().method_12789(DATA_SITTING_ID);
    }

    public void setSitting(boolean isSitting) {
        this.method_5841().method_12778(DATA_SITTING_ID, (Object)isSitting);
    }

    @Nullable
    public UUID getFollowing() {
        return ((Optional)this.method_5841().method_12789(DATA_FOLLOWING_ID)).orElse(null);
    }

    public void setFollowing(@Nullable UUID uuid) {
        this.method_5841().method_12778(DATA_FOLLOWING_ID, Optional.ofNullable(uuid));
    }

    @Override
    public float getWingRotation() {
        return this.wingRotation;
    }

    @Override
    public void setWingRotation(float rotation) {
        this.wingRotation = rotation;
    }

    @Override
    public float getPrevWingRotation() {
        return this.prevWingRotation;
    }

    @Override
    public void setPrevWingRotation(float rotation) {
        this.prevWingRotation = rotation;
    }

    @Override
    public float getWingDestPos() {
        return this.destPos;
    }

    @Override
    public void setWingDestPos(float pos) {
        this.destPos = pos;
    }

    @Override
    public float getPrevWingDestPos() {
        return this.prevDestPos;
    }

    @Override
    public void setPrevWingDestPos(float pos) {
        this.prevDestPos = pos;
    }

    public int getJumpCooldown() {
        return this.jumpCooldown;
    }

    public void setJumpCooldown(int jumpCooldown) {
        this.jumpCooldown = jumpCooldown;
    }

    public int getFlapCooldown() {
        return this.flapCooldown;
    }

    public void setFlapCooldown(int flapCooldown) {
        this.flapCooldown = flapCooldown;
    }

    protected class_3414 method_5994() {
        return (class_3414)AetherSoundEvents.ENTITY_MOA_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return (class_3414)AetherSoundEvents.ENTITY_MOA_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)AetherSoundEvents.ENTITY_MOA_DEATH.get();
    }

    @Override
    protected class_3414 getSaddledSound() {
        return (class_3414)AetherSoundEvents.ENTITY_MOA_SADDLE.get();
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783((class_3414)AetherSoundEvents.ENTITY_MOA_STEP.get(), 0.15f, 1.0f);
    }

    public int getMaxJumps() {
        MoaType moaType = this.getMoaType();
        return moaType != null ? moaType.getMaxJumps() : ((MoaType)AetherMoaTypes.BLUE.get()).getMaxJumps();
    }

    public int getEggTime() {
        return this.field_5974.method_43048(6000) + 6000;
    }

    public boolean method_6481(class_1799 stack) {
        return false;
    }

    public boolean method_6049(class_1293 effect) {
        return (effect.method_5579() != AetherEffects.INEBRIATION.get() || !this.isPlayerGrown()) && super.method_6049(effect);
    }

    public float method_6029() {
        if (this.method_5782() && this.method_6725()) {
            return this.getSteeringSpeed();
        }
        MoaType moaType = this.getMoaType();
        return moaType != null ? (float)(this.method_26825(class_5134.field_23719) * (double)moaType.getSpeed()) : 0.155f;
    }

    @Override
    public boolean canJump() {
        return this.getRemainingJumps() > 0 && this.getJumpCooldown() == 0;
    }

    @Override
    public boolean method_6765() {
        return super.method_6765() && this.isPlayerGrown();
    }

    @Override
    public double getMountJumpStrength() {
        return this.method_24828() ? 0.95 : 0.9;
    }

    @Override
    public float getSteeringSpeed() {
        MoaType moaType = this.getMoaType();
        return moaType != null ? (float)(this.method_26825(class_5134.field_23719) * (double)moaType.getSpeed()) : 0.155f;
    }

    @Override
    public float method_49484() {
        if (this.method_5782() && this.method_6725()) {
            return this.getSteeringSpeed() * 0.45f;
        }
        return this.getSteeringSpeed() * 0.025f;
    }

    public int method_5850() {
        return this.method_24828() ? super.method_5850() : 14;
    }

    public double method_5621() {
        return this.isSitting() ? 0.25 : 1.25;
    }

    public float method_17825() {
        return 1.0f;
    }

    public class_4048 method_18377(class_4050 pose) {
        class_4048 dimensions = super.method_18377(pose);
        if (this.isSitting()) {
            dimensions = dimensions.method_19539(1.0f, 0.5f);
        }
        if (this.method_6109()) {
            dimensions = dimensions.method_19539(1.0f, 0.5f);
        }
        return dimensions;
    }

    @Nullable
    public class_1296 method_5613(class_3218 level, class_1296 entity) {
        return null;
    }

    public boolean method_19184() {
        return false;
    }

    public void method_5614(int age) {
        if (age % -8000 == 0 || age == 0 && this.getAmountFed() >= 3) {
            super.method_5614(age);
        }
    }

    @Nullable
    public class_1799 method_31480() {
        MoaEggItem moaEggItem = MoaEggItem.byId(this.getMoaType());
        return moaEggItem == null ? null : new class_1799((class_1935)moaEggItem);
    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10545("MoaUUID")) {
            this.setMoaUUID(tag.method_25926("MoaUUID"));
        }
        if (tag.method_10545("IsBaby")) {
            this.method_7217(tag.method_10577("IsBaby"));
        }
        MoaType moaType = AetherMoaTypes.get(tag.method_10558("MoaType"));
        if (tag.method_10545("MoaType") && moaType != null) {
            this.setMoaType(moaType);
        } else {
            this.setMoaType(AetherMoaTypes.getWeightedChance(this.method_6051()));
        }
        if (tag.method_25928("Rider")) {
            this.setRider(tag.method_25926("Rider"));
        }
        if (tag.method_25928("LastRider")) {
            this.setLastRider(tag.method_25926("LastRider"));
        }
        if (tag.method_10545("RemainingJumps")) {
            this.setRemainingJumps(tag.method_10550("RemainingJumps"));
        }
        if (tag.method_10545("Hungry")) {
            this.setHungry(tag.method_10577("Hungry"));
        }
        if (tag.method_10545("AmountFed")) {
            this.setAmountFed(tag.method_10550("AmountFed"));
        }
        if (tag.method_10545("PlayerGrown")) {
            this.setPlayerGrown(tag.method_10577("PlayerGrown"));
        }
        if (tag.method_10545("Sitting")) {
            this.setSitting(tag.method_10577("Sitting"));
        }
        if (tag.method_10545("Following")) {
            this.setFollowing(tag.method_25926("Following"));
        }
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        if (this.getMoaUUID() != null) {
            tag.method_25927("MoaUUID", this.getMoaUUID());
        }
        tag.method_10556("IsBaby", this.method_6109());
        tag.method_10582("MoaType", Objects.requireNonNullElse(this.getMoaType(), AetherMoaTypes.BLUE).toString());
        if (this.getRider() != null) {
            tag.method_25927("Rider", this.getRider());
        }
        if (this.getLastRider() != null) {
            tag.method_25927("LastRider", this.getLastRider());
        }
        tag.method_10569("RemainingJumps", this.getRemainingJumps());
        tag.method_10556("Hungry", this.isHungry());
        tag.method_10569("AmountFed", this.getAmountFed());
        tag.method_10556("PlayerGrown", this.isPlayerGrown());
        tag.method_10556("Sitting", this.isSitting());
        if (this.getFollowing() != null) {
            tag.method_25927("Following", this.getFollowing());
        }
    }
}

