/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.event.listeners;

import com.aetherteam.aether.client.event.hooks.GuiHooks;
import com.aetherteam.aether.client.gui.component.inventory.AccessoryButton;
import com.aetherteam.aether.client.gui.screen.inventory.AccessoriesScreen;
import com.aetherteam.aether.event.hooks.ItemHooks;
import io.github.fabricators_of_create.porting_lib.event.client.KeyInputCallback;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1259;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_345;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_7845;

public class GuiListener {
    public static void onGuiInitialize(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        List buttons = Screens.getButtons((class_437)screen);
        if (GuiHooks.isAccessoryButtonEnabled()) {
            class_3545<Integer, Integer> offsets = AccessoriesScreen.getButtonOffset(screen);
            AccessoryButton inventoryAccessoryButton = GuiHooks.setupAccessoryButton(screen, offsets);
            if (inventoryAccessoryButton != null) {
                buttons.add(inventoryAccessoryButton);
            }
        } else {
            class_7845 layout = GuiHooks.setupPerksButtons(screen);
            if (layout != null) {
                layout.method_48206(buttons::add);
            }
        }
    }

    public static void onGuiDraw(class_437 screen, class_332 guiGraphics, int mouseX, int mouseY, float tickDelta) {
        if (!FabricLoader.getInstance().isModLoaded("tipsmod")) {
            GuiHooks.drawTrivia(screen, guiGraphics);
        }
        GuiHooks.drawAetherTravelMessage(screen, guiGraphics);
    }

    public static void onClientTick(class_310 minecraft) {
        GuiHooks.handlePatreonRefreshRebound();
    }

    public static void onKeyPress(int key, int scancode, int action, int mods) {
        GuiHooks.openAccessoryMenu();
        GuiHooks.closeContainerMenu(key, action);
    }

    public static int onRenderBossBar(class_332 guiGraphics, int x, int y, class_1259 bossEvent, int increment) {
        UUID bossUUID = bossEvent.method_5407();
        if (GuiHooks.isAetherBossBar(bossUUID)) {
            GuiHooks.drawBossHealthBar(guiGraphics, x, y, (class_345)bossEvent);
            return increment + 13;
        }
        return increment;
    }

    public static void onTooltipAdd(class_1799 itemStack, class_1836 tooltipFlag, List<class_2561> itemTooltips) {
        ItemHooks.addDungeonTooltips(itemTooltips, itemStack, tooltipFlag);
    }

    public static void init() {
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            GuiListener.onGuiInitialize(client, screen, scaledWidth, scaledHeight);
            ScreenEvents.afterRender((class_437)screen).register(GuiListener::onGuiDraw);
        });
        ClientTickEvents.END_CLIENT_TICK.register(GuiListener::onClientTick);
        KeyInputCallback.EVENT.register(GuiListener::onKeyPress);
        ItemTooltipCallback.EVENT.register(GuiListener::onTooltipAdd);
    }
}

