/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.client.AetherAtlases;
import com.aetherteam.aether.client.AetherColorResolvers;
import com.aetherteam.aether.client.AetherKeys;
import com.aetherteam.aether.client.AetherRecipeCategories;
import com.aetherteam.aether.client.event.listeners.AudioListener;
import com.aetherteam.aether.client.event.listeners.DimensionClientListener;
import com.aetherteam.aether.client.event.listeners.GuiListener;
import com.aetherteam.aether.client.event.listeners.HandRenderListener;
import com.aetherteam.aether.client.event.listeners.LevelClientListener;
import com.aetherteam.aether.client.event.listeners.MenuListener;
import com.aetherteam.aether.client.event.listeners.WorldPreviewListener;
import com.aetherteam.aether.client.event.listeners.abilities.AccessoryAbilityClientListener;
import com.aetherteam.aether.client.event.listeners.capability.AetherPlayerClientListener;
import com.aetherteam.aether.client.gui.screen.inventory.AccessoriesScreen;
import com.aetherteam.aether.client.gui.screen.inventory.AltarScreen;
import com.aetherteam.aether.client.gui.screen.inventory.FreezerScreen;
import com.aetherteam.aether.client.gui.screen.inventory.IncubatorScreen;
import com.aetherteam.aether.client.gui.screen.inventory.LoreBookScreen;
import com.aetherteam.aether.client.gui.screen.inventory.SunAltarScreen;
import com.aetherteam.aether.client.particle.AetherParticleTypes;
import com.aetherteam.aether.client.renderer.AetherModelLoadingPlugin;
import com.aetherteam.aether.client.renderer.AetherOverlays;
import com.aetherteam.aether.client.renderer.AetherRenderers;
import com.aetherteam.aether.client.renderer.level.AetherRenderEffects;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.inventory.menu.AetherMenuTypes;
import com.aetherteam.aether.inventory.menu.LoreBookMenu;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.perk.CustomizationsOptions;
import com.aetherteam.cumulus.CumulusConfig;
import com.aetherteam.nitrogen.event.listeners.TooltipListeners;
import com.google.common.reflect.Reflection;
import io.github.fabricators_of_create.porting_lib.client_events.event.client.RegisterEntitySpectatorShadersCallback;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_437;
import net.minecraft.class_5272;
import net.minecraft.class_7417;

public class AetherClient
implements ClientModInitializer {
    private static boolean refreshPacks = false;

    public void onInitializeClient() {
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> AetherClient.disableCumulusButton());
        Reflection.initialize((Class[])new Class[]{CustomizationsOptions.class});
        AetherAtlases.registerTreasureChestAtlases();
        AetherAtlases.registerWoodTypeAtlases();
        AetherParticleTypes.registerParticleFactories();
        AetherKeys.registerKeyMappings();
        AetherRenderEffects.registerRenderEffects();
        AetherRenderers.init();
        AetherClient.registerGuiFactories();
        AetherClient.registerItemModelProperties();
        AetherClient.registerTooltipOverrides();
        AetherClient.registerLoreOverrides();
        AetherClient.autoApplyPacks();
        ModelLoadingPlugin.register((ModelLoadingPlugin)new AetherModelLoadingPlugin());
        AetherPacketHandler.INSTANCE.initClientListener();
        this.initEvents();
        RegisterEntitySpectatorShadersCallback.EVENT.register(AetherClient::registerSpectatorShaders);
        ClientLifecycleEvents.CLIENT_STARTED.register(this::loadComplete);
    }

    public void initEvents() {
        AccessoryAbilityClientListener.init();
        AetherPlayerClientListener.init();
        DimensionClientListener.init();
        WorldPreviewListener.init();
        LevelClientListener.init();
        HandRenderListener.init();
        AudioListener.init();
        MenuListener.init();
        GuiListener.init();
        GuiListener.init();
        AetherColorResolvers.init();
        AetherRecipeCategories.registerRecipeCategories();
        AetherOverlays.registerOverlays();
    }

    public static void disableCumulusButton() {
        if (((Boolean)AetherConfig.CLIENT.should_disable_cumulus_button.get()).booleanValue()) {
            CumulusConfig.CLIENT.enable_menu_list_button.set((Object)false);
            CumulusConfig.CLIENT.enable_menu_list_button.save();
            AetherConfig.CLIENT.should_disable_cumulus_button.set((Object)false);
            AetherConfig.CLIENT.should_disable_cumulus_button.save();
        }
    }

    public static void registerGuiFactories() {
        class_3929.method_17542((class_3917)((class_3917)AetherMenuTypes.ACCESSORIES.get()), AccessoriesScreen::new);
        class_3929.method_17542((class_3917)((class_3917)AetherMenuTypes.BOOK_OF_LORE.get()), LoreBookScreen::new);
        class_3929.method_17542((class_3917)((class_3917)AetherMenuTypes.ALTAR.get()), AltarScreen::new);
        class_3929.method_17542((class_3917)((class_3917)AetherMenuTypes.FREEZER.get()), FreezerScreen::new);
        class_3929.method_17542((class_3917)((class_3917)AetherMenuTypes.INCUBATOR.get()), IncubatorScreen::new);
    }

    public static void registerItemModelProperties() {
        class_5272.method_27879((class_1792)((class_1792)AetherItems.PHOENIX_BOW.get()), (class_2960)new class_2960("pulling"), (stack, world, living, i) -> living != null && living.method_6115() && living.method_6030() == stack ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)((class_1792)AetherItems.PHOENIX_BOW.get()), (class_2960)new class_2960("pull"), (stack, world, living, i) -> living != null ? (living.method_6030() != stack ? 0.0f : (float)(stack.method_7935() - living.method_6014()) / 20.0f) : 0.0f);
        class_5272.method_27879((class_1792)((class_1792)AetherItems.CANDY_CANE_SWORD.get()), (class_2960)new class_2960("aether", "named"), (stack, world, living, i) -> stack.method_7964().getString().equalsIgnoreCase("green candy cane sword") ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)((class_1792)AetherItems.HAMMER_OF_KINGBDOGZ.get()), (class_2960)new class_2960("aether", "named"), (stack, world, living, i) -> stack.method_7964().getString().equalsIgnoreCase("hammer of jeb") ? 1.0f : 0.0f);
    }

    public static void registerTooltipOverrides() {
        TooltipListeners.PREDICATES.put(AetherItems.BLUE_GUMMY_SWET, (player, stack, components, component) -> {
            class_2588 contents;
            class_7417 patt6027$temp;
            if (((Boolean)AetherConfig.SERVER.healing_gummy_swets.get()).booleanValue() && (patt6027$temp = component.method_10851()) instanceof class_2588 && (contents = (class_2588)patt6027$temp).method_11022().endsWith(".1")) {
                return class_2561.method_43471((String)(contents.method_11022() + ".health"));
            }
            return component;
        });
        TooltipListeners.PREDICATES.put(AetherItems.GOLDEN_GUMMY_SWET, (player, stack, components, component) -> {
            class_2588 contents;
            class_7417 patt6470$temp;
            if (((Boolean)AetherConfig.SERVER.healing_gummy_swets.get()).booleanValue() && (patt6470$temp = component.method_10851()) instanceof class_2588 && (contents = (class_2588)patt6470$temp).method_11022().endsWith(".1")) {
                return class_2561.method_43471((String)(contents.method_11022() + ".health"));
            }
            return component;
        });
        TooltipListeners.PREDICATES.put(AetherItems.LIFE_SHARD, (player, stack, components, component) -> {
            class_2588 contents;
            class_7417 patt6857$temp = component.method_10851();
            if (patt6857$temp instanceof class_2588 && (contents = (class_2588)patt6857$temp).method_11022().endsWith(".1")) {
                return class_2561.method_43469((String)contents.method_11022(), (Object[])new Object[]{AetherConfig.SERVER.maximum_life_shards.get()});
            }
            return component;
        });
    }

    public static void registerLoreOverrides() {
        LoreBookMenu.addLoreEntryOverride(stack -> stack.method_31574((class_1792)AetherItems.HAMMER_OF_KINGBDOGZ.get()) && stack.method_7964().getString().equalsIgnoreCase("hammer of jeb"), "lore.item.aether.hammer_of_jeb");
        LoreBookMenu.addLoreEntryOverride(stack -> class_1799.method_31577((class_1799)stack, (class_1799)AetherItems.createSwetBannerItemStack()), "lore.item.aether.swet_banner");
    }

    public static void autoApplyPacks() {
        if (FabricLoader.getInstance().isModLoaded("tipsmod")) {
            if (((Boolean)AetherConfig.CLIENT.enable_trivia.get()).booleanValue()) {
                class_310.method_1551().method_1520().method_49427("builtin/aether_tips");
            } else {
                class_310.method_1551().method_1520().method_49428("builtin/aether_tips");
            }
            refreshPacks = true;
        }
    }

    public static void registerSpectatorShaders(Map<class_1299<?>, class_2960> shaders) {
        shaders.put((class_1299)AetherEntityTypes.SUN_SPIRIT.get(), new class_2960("aether", "shaders/post/sun_spirit.json"));
    }

    public void loadComplete(class_310 client) {
        if (refreshPacks) {
            class_310.method_1551().method_1521();
            refreshPacks = false;
        }
    }

    public static void setToSunAltarScreen(class_2561 name, int timeScale) {
        class_310.method_1551().method_1507((class_437)new SunAltarScreen(name, timeScale));
    }
}

