/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block;

import com.aetherteam.aether.event.FreezeEvent;
import com.aetherteam.nitrogen.recipe.BlockStateRecipeUtil;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2158;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public interface FreezingBehavior<T> {
    public static final int FLAG_SHELL = 3;
    public static final int FLAG_VOLUME = 19;

    default public int freezeBlocks(class_1937 level, class_2338 origin, T source, float radius) {
        float radiusSq = radius * radius;
        int blocksFrozen = 0;
        for (int x = (int)radius; x >= 0; --x) {
            boolean firstXZ = true;
            for (int z = (int)radius; z >= 0; --z) {
                int xzLengthSq = x * x + z * z;
                if ((float)xzLengthSq > radiusSq) continue;
                blocksFrozen += this.quarters(level, origin, x, 0, z, source, firstXZ ? 3 : 19);
                firstXZ = false;
                boolean firstY = true;
                for (int y = (int)radius; y >= 0; --y) {
                    if ((float)(xzLengthSq + y * y) > radiusSq) continue;
                    int placementFlag = firstY ? 3 : 19;
                    blocksFrozen += this.quarters(level, origin, x, y, z, source, placementFlag);
                    blocksFrozen += this.quarters(level, origin, x, -y, z, source, placementFlag);
                    firstY = false;
                }
            }
        }
        return this.freezeFromRecipe(level, origin, origin, source, 3) + blocksFrozen;
    }

    private int quarters(class_1937 level, class_2338 origin, int dX, int dY, int dZ, T source, int flag) {
        return this.freezeFromRecipe(level, origin.method_10069(dX, dY, dZ), origin, source, flag) + this.freezeFromRecipe(level, origin.method_10069(-dZ, dY, dX), origin, source, flag) + this.freezeFromRecipe(level, origin.method_10069(-dX, dY, -dZ), origin, source, flag) + this.freezeFromRecipe(level, origin.method_10069(dZ, dY, -dX), origin, source, flag);
    }

    public int freezeFromRecipe(class_1937 var1, class_2338 var2, class_2338 var3, T var4, int var5);

    default public int freezeBlockAt(class_1937 level, class_2338 pos, class_2338 origin, class_2680 oldBlockState, class_2680 newBlockState, @Nullable class_2158.class_2159 function, T source, int flag) {
        FreezeEvent event = this.onFreeze((class_1936)level, pos, origin, oldBlockState, newBlockState, source);
        if (!event.isCanceled()) {
            level.method_8652(pos, newBlockState, flag);
            if (newBlockState.method_26229()) {
                level.method_39279(pos, newBlockState.method_26204(), class_3532.method_15395((class_5819)level.method_8409(), (int)60, (int)120));
            }
            BlockStateRecipeUtil.executeFunction((class_1937)level, (class_2338)pos, (class_2158.class_2159)function);
            return 1;
        }
        return 0;
    }

    public FreezeEvent onFreeze(class_1936 var1, class_2338 var2, class_2338 var3, class_2680 var4, class_2680 var5, T var6);
}

