/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherGameEvents;
import com.aetherteam.aether.advancement.AetherAdvancementTriggers;
import com.aetherteam.aether.api.AetherAdvancementSoundOverrides;
import com.aetherteam.aether.api.AetherMenus;
import com.aetherteam.aether.api.AetherMoaTypes;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.block.AetherCauldronInteractions;
import com.aetherteam.aether.block.dispenser.AetherDispenseBehaviors;
import com.aetherteam.aether.block.dispenser.DispenseDartBehavior;
import com.aetherteam.aether.block.dispenser.DispenseSkyrootBoatBehavior;
import com.aetherteam.aether.block.dispenser.DispenseUsableItemBehavior;
import com.aetherteam.aether.blockentity.AetherBlockEntityTypes;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.CombinedPackResources;
import com.aetherteam.aether.client.TriviaGenerator;
import com.aetherteam.aether.client.particle.AetherParticleTypes;
import com.aetherteam.aether.command.AetherCommands;
import com.aetherteam.aether.command.SunAltarWhitelist;
import com.aetherteam.aether.data.ReloadListeners;
import com.aetherteam.aether.data.resources.AetherMobCategory;
import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.ai.AetherBlockPathTypes;
import com.aetherteam.aether.event.listeners.DimensionListener;
import com.aetherteam.aether.event.listeners.EntityListener;
import com.aetherteam.aether.event.listeners.ItemListener;
import com.aetherteam.aether.event.listeners.PerkListener;
import com.aetherteam.aether.event.listeners.RecipeListener;
import com.aetherteam.aether.event.listeners.abilities.AccessoryAbilityListener;
import com.aetherteam.aether.event.listeners.abilities.ArmorAbilityListener;
import com.aetherteam.aether.event.listeners.abilities.ToolAbilityListener;
import com.aetherteam.aether.event.listeners.abilities.WeaponAbilityListener;
import com.aetherteam.aether.event.listeners.capability.AetherPlayerListener;
import com.aetherteam.aether.event.listeners.capability.AetherTimeListener;
import com.aetherteam.aether.inventory.AetherRecipeBookTypes;
import com.aetherteam.aether.inventory.menu.AetherMenuTypes;
import com.aetherteam.aether.item.AetherCreativeTabs;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.loot.conditions.AetherLootConditions;
import com.aetherteam.aether.loot.functions.AetherLootFunctions;
import com.aetherteam.aether.loot.modifiers.AetherLootModifiers;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.perk.types.MoaSkins;
import com.aetherteam.aether.recipe.AetherRecipeSerializers;
import com.aetherteam.aether.recipe.AetherRecipeTypes;
import com.aetherteam.aether.world.AetherPoi;
import com.aetherteam.aether.world.feature.AetherFeatures;
import com.aetherteam.aether.world.foliageplacer.AetherFoliagePlacerTypes;
import com.aetherteam.aether.world.placementmodifier.AetherPlacementModifiers;
import com.aetherteam.aether.world.processor.AetherStructureProcessors;
import com.aetherteam.aether.world.structure.AetherStructureTypes;
import com.aetherteam.aether.world.structurepiece.AetherStructurePieceTypes;
import com.aetherteam.aether.world.treedecorator.AetherTreeDecoratorTypes;
import com.aetherteam.aether.world.trunkplacer.AetherTrunkPlacerTypes;
import com.google.common.reflect.Reflection;
import com.mojang.logging.LogUtils;
import io.github.fabricators_of_create.porting_lib.config.ConfigRegistry;
import io.github.fabricators_of_create.porting_lib.config.ConfigType;
import io.github.fabricators_of_create.porting_lib.config.ModConfigSpec;
import io.github.fabricators_of_create.porting_lib.event.common.AddPackFindersEvent;
import io.github.fabricators_of_create.porting_lib.resources.PathPackResources;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import io.github.fabricators_of_create.porting_lib.util.LazyRegistrar;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2357;
import net.minecraft.class_2561;
import net.minecraft.class_3264;
import net.minecraft.class_3272;
import net.minecraft.class_3288;
import net.minecraft.class_3956;
import net.minecraft.class_3962;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5352;
import net.minecraft.class_5620;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import org.slf4j.Logger;

public class Aether
implements ModInitializer {
    public static final String MODID = "aether";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Path DIRECTORY = FabricLoader.getInstance().getConfigDir().resolve("aether");
    public static final TriviaGenerator TRIVIA_READER = new TriviaGenerator();

    public void onInitialize() {
        LazyRegistrar[] registers;
        AddPackFindersEvent.EVENT.register(this::packSetup);
        for (LazyRegistrar register : registers = new LazyRegistrar[]{AetherBlocks.BLOCKS, AetherItems.ITEMS, AetherEntityTypes.ENTITY_TYPES, AetherBlockEntityTypes.BLOCK_ENTITY_TYPES, AetherMenuTypes.MENU_TYPES, AetherEffects.EFFECTS, AetherParticleTypes.PARTICLES, AetherFeatures.FEATURES, AetherFoliagePlacerTypes.FOLIAGE_PLACERS, AetherTrunkPlacerTypes.TRUNK_PLACERS, AetherTreeDecoratorTypes.TREE_DECORATORS, AetherStructureTypes.STRUCTURE_TYPES, AetherStructurePieceTypes.STRUCTURE_PIECE_TYPES, AetherStructureProcessors.STRUCTURE_PROCESSOR_TYPES, AetherRecipeTypes.RECIPE_TYPES, AetherRecipeSerializers.RECIPE_SERIALIZERS, AetherLootFunctions.LOOT_FUNCTION_TYPES, AetherLootConditions.LOOT_CONDITION_TYPES, AetherLootModifiers.GLOBAL_LOOT_MODIFIERS, AetherSoundEvents.SOUNDS, AetherGameEvents.GAME_EVENTS, AetherAdvancementSoundOverrides.ADVANCEMENT_SOUND_OVERRIDES, AetherMoaTypes.MOA_TYPES, AetherCreativeTabs.CREATIVE_MODE_TABS}) {
            register.register();
        }
        this.commonSetup();
        AetherEntityTypes.init();
        EnvExecutor.unsafeRunForDist(() -> () -> {
            AetherMenus.MENUS.register();
            return true;
        }, () -> () -> false);
        AetherBlocks.registerWoodTypes();
        DIRECTORY.toFile().mkdirs();
        ConfigRegistry.registerConfig((String)MODID, (ConfigType)ConfigType.SERVER, (ModConfigSpec)AetherConfig.SERVER_SPEC);
        ConfigRegistry.registerConfig((String)MODID, (ConfigType)ConfigType.COMMON, (ModConfigSpec)AetherConfig.COMMON_SPEC);
        ConfigRegistry.registerConfig((String)MODID, (ConfigType)ConfigType.CLIENT, (ModConfigSpec)AetherConfig.CLIENT_SPEC);
        this.initEvents();
        AetherRecipeBookTypes.init();
        ReloadListeners.reloadListenerSetup();
    }

    public void initEvents() {
        ItemListener.init();
        PerkListener.init();
        EntityListener.init();
        RecipeListener.init();
        DimensionListener.init();
        AetherTimeListener.init();
        ToolAbilityListener.init();
        AetherPlayerListener.init();
        ArmorAbilityListener.init();
        WeaponAbilityListener.init();
        AccessoryAbilityListener.init();
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40202).register(AetherCreativeTabs::buildCreativeModeTabs);
        CommandRegistrationCallback.EVENT.register(AetherCommands::registerCommands);
    }

    public void commonSetup() {
        AetherPacketHandler.register();
        AetherPacketHandler.INSTANCE.initServerListener();
        Reflection.initialize((Class[])new Class[]{SunAltarWhitelist.class});
        Reflection.initialize((Class[])new Class[]{AetherPlacementModifiers.class});
        Reflection.initialize((Class[])new Class[]{AetherRecipeBookTypes.class});
        Reflection.initialize((Class[])new Class[]{AetherBlockPathTypes.class});
        Reflection.initialize((Class[])new Class[]{AetherMobCategory.class});
        Reflection.initialize((Class[])new Class[]{AetherPoi.class});
        AetherAdvancementTriggers.init();
        MoaSkins.registerMoaSkins();
        AetherBlocks.registerFuels();
        AetherBlocks.registerPots();
        AetherBlocks.registerFlammability();
        AetherBlocks.registerFluidInteractions();
        AetherItems.setupBucketReplacements();
        this.registerDispenserBehaviors();
        this.registerCauldronInteractions();
        this.registerComposting();
    }

    public void packSetup(AddPackFindersEvent event) {
        this.setupReleasePack(event);
        this.setupBetaPack(event);
        this.setupCTMFixPack(event);
        this.setupTipsPack(event);
        this.setupColorblindPack(event);
        this.setupTooltipsPack(event);
        this.setupAccessoriesPack(event);
        this.setupCuriosOverridePack(event);
        this.setupTemporaryFreezingPack(event);
        this.setupRuinedPortalPack(event);
    }

    private void setupReleasePack(AddPackFindersEvent event) {
        if (event.getPackType() == class_3264.field_14188) {
            Path resourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/classic_125").orElseThrow();
            PathPackResources pack = new PathPackResources("aether:" + String.valueOf(resourcePath), false, resourcePath);
            this.createCombinedPack(event, resourcePath, pack, "builtin/aether_125_art", "pack.aether.125.title", "pack.aether.125.description");
        }
    }

    private void setupBetaPack(AddPackFindersEvent event) {
        if (event.getPackType() == class_3264.field_14188) {
            Path resourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/classic_b173").orElseThrow();
            PathPackResources pack = new PathPackResources("aether:" + String.valueOf(resourcePath), false, resourcePath);
            this.createCombinedPack(event, resourcePath, pack, "builtin/aether_b173_art", "pack.aether.b173.title", "pack.aether.b173.description");
        }
    }

    private void createCombinedPack(AddPackFindersEvent event, Path sourcePath, PathPackResources pack, String name, String title, String description) {
        Path baseResourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/classic_base").orElseThrow();
        PathPackResources basePack = new PathPackResources("aether:" + String.valueOf(baseResourcePath), false, baseResourcePath);
        List<PathPackResources> mergedPacks = List.of(pack, basePack);
        class_3288.class_7680 resourcesSupplier = string -> new CombinedPackResources(name, new class_3272((class_2561)class_2561.method_43471((String)description), class_155.method_16673().method_48017(class_3264.field_14188)), mergedPacks, sourcePath);
        class_3288.class_7679 info = class_3288.method_45274((String)name, (class_3288.class_7680)resourcesSupplier);
        if (info != null) {
            event.addRepositorySource(source -> source.accept(class_3288.method_14456((String)name, (class_2561)class_2561.method_43471((String)title), (boolean)false, (class_3288.class_7680)resourcesSupplier, (class_3288.class_7679)info, (class_3264)class_3264.field_14188, (class_3288.class_3289)class_3288.class_3289.field_14280, (boolean)false, (class_5352)class_5352.field_25348)));
        }
    }

    private void setupCTMFixPack(AddPackFindersEvent event) {
        if (event.getPackType() == class_3264.field_14188 && FabricLoader.getInstance().isModLoaded("ctm")) {
            Path resourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/ctm_fix").orElseThrow();
            PathPackResources pack = new PathPackResources("aether:" + String.valueOf(resourcePath), true, resourcePath);
            class_3272 metadata = new class_3272((class_2561)class_2561.method_43471((String)"pack.aether.ctm.description"), class_155.method_16673().method_48017(class_3264.field_14188));
            event.addRepositorySource(source -> source.accept(class_3288.method_14456((String)"builtin/aether_ctm_fix", (class_2561)class_2561.method_43471((String)"pack.aether.ctm.title"), (boolean)true, string -> pack, (class_3288.class_7679)new class_3288.class_7679(metadata.method_14423(), metadata.method_14424(), class_7699.method_45397()), (class_3264)class_3264.field_14188, (class_3288.class_3289)class_3288.class_3289.field_14280, (boolean)false, (class_5352)class_5352.field_25348)));
        }
    }

    private void setupTipsPack(AddPackFindersEvent event) {
        if (event.getPackType() == class_3264.field_14188 && FabricLoader.getInstance().isModLoaded("tipsmod")) {
            Path resourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/tips").orElseThrow();
            PathPackResources pack = new PathPackResources("aether:" + String.valueOf(resourcePath), true, resourcePath);
            class_3272 metadata = new class_3272((class_2561)class_2561.method_43471((String)"pack.aether.tips.description"), class_155.method_16673().method_48017(class_3264.field_14188));
            event.addRepositorySource(source -> source.accept(class_3288.method_14456((String)"builtin/aether_tips", (class_2561)class_2561.method_43471((String)"pack.aether.tips.title"), (boolean)false, string -> pack, (class_3288.class_7679)new class_3288.class_7679(metadata.method_14423(), metadata.method_14424(), class_7699.method_45397()), (class_3264)class_3264.field_14188, (class_3288.class_3289)class_3288.class_3289.field_14280, (boolean)false, (class_5352)class_5352.field_25348)));
        }
    }

    private void setupColorblindPack(AddPackFindersEvent event) {
        if (event.getPackType() == class_3264.field_14188) {
            Path resourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/colorblind").orElseThrow();
            PathPackResources pack = new PathPackResources("aether:" + String.valueOf(resourcePath), true, resourcePath);
            class_3272 metadata = new class_3272((class_2561)class_2561.method_43471((String)"pack.aether.colorblind.description"), class_155.method_16673().method_48017(class_3264.field_14188));
            event.addRepositorySource(source -> source.accept(class_3288.method_14456((String)"builtin/aether_colorblind", (class_2561)class_2561.method_43471((String)"pack.aether.colorblind.title"), (boolean)false, string -> pack, (class_3288.class_7679)new class_3288.class_7679(metadata.method_14423(), metadata.method_14424(), class_7699.method_45397()), (class_3264)class_3264.field_14188, (class_3288.class_3289)class_3288.class_3289.field_14280, (boolean)false, (class_5352)class_5352.field_25348)));
        }
    }

    private void setupTooltipsPack(AddPackFindersEvent event) {
        if (event.getPackType() == class_3264.field_14188) {
            Path resourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/tooltips").orElseThrow();
            PathPackResources pack = new PathPackResources("aether:" + String.valueOf(resourcePath), true, resourcePath);
            class_3272 metadata = new class_3272((class_2561)class_2561.method_43471((String)"pack.aether.tooltips.description"), class_155.method_16673().method_48017(class_3264.field_14188));
            event.addRepositorySource(source -> source.accept(class_3288.method_14456((String)"builtin/aether_tooltips", (class_2561)class_2561.method_43471((String)"pack.aether.tooltips.title"), (boolean)FabricLoader.getInstance().isModLoaded("aether_genesis"), string -> pack, (class_3288.class_7679)new class_3288.class_7679(metadata.method_14423(), metadata.method_14424(), class_7699.method_45397()), (class_3264)class_3264.field_14188, (class_3288.class_3289)class_3288.class_3289.field_14280, (boolean)false, (class_5352)class_5352.field_25348)));
        }
    }

    private void setupAccessoriesPack(AddPackFindersEvent event) {
        if (event.getPackType() == class_3264.field_14190 && !((Boolean)AetherConfig.COMMON.use_curios_menu.get()).booleanValue()) {
            Path resourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/accessories").orElseThrow();
            PathPackResources pack = new PathPackResources("aether:" + String.valueOf(resourcePath), true, resourcePath);
            class_3272 metadata = new class_3272((class_2561)class_2561.method_43471((String)"pack.aether.accessories.description"), class_155.method_16673().method_48017(class_3264.field_14190));
            event.addRepositorySource(source -> source.accept(class_3288.method_14456((String)"builtin/aether_accessories", (class_2561)class_2561.method_43471((String)"pack.aether.accessories.title"), (boolean)true, string -> pack, (class_3288.class_7679)new class_3288.class_7679(metadata.method_14423(), metadata.method_14424(), class_7699.method_45397()), (class_3264)class_3264.field_14190, (class_3288.class_3289)class_3288.class_3289.field_14280, (boolean)false, (class_5352)class_5352.field_25348)));
        }
    }

    private void setupCuriosOverridePack(AddPackFindersEvent event) {
        if (event.getPackType() == class_3264.field_14190 && ((Boolean)AetherConfig.COMMON.use_curios_menu.get()).booleanValue()) {
            Path resourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/curios_override").orElseThrow();
            PathPackResources pack = new PathPackResources("aether:" + String.valueOf(resourcePath), true, resourcePath);
            class_3272 metadata = new class_3272((class_2561)class_2561.method_43471((String)"pack.aether.curios.description"), class_155.method_16673().method_48017(class_3264.field_14190));
            event.addRepositorySource(source -> source.accept(class_3288.method_14456((String)"builtin/aether_curios_override", (class_2561)class_2561.method_43471((String)"pack.aether.curios.title"), (boolean)true, string -> pack, (class_3288.class_7679)new class_3288.class_7679(metadata.method_14423(), metadata.method_14424(), class_7699.method_45397()), (class_3264)class_3264.field_14190, (class_3288.class_3289)class_3288.class_3289.field_14280, (boolean)false, (class_5352)class_5352.field_25348)));
        }
    }

    private void setupTemporaryFreezingPack(AddPackFindersEvent event) {
        if (event.getPackType() == class_3264.field_14190) {
            Path resourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/temporary_freezing").orElseThrow();
            PathPackResources pack = new PathPackResources("aether:" + String.valueOf(resourcePath), true, resourcePath);
            class_3272 metadata = new class_3272((class_2561)class_2561.method_43471((String)"pack.aether.freezing.description"), class_155.method_16673().method_48017(class_3264.field_14190));
            event.addRepositorySource(source -> source.accept(class_3288.method_14456((String)"builtin/aether_temporary_freezing", (class_2561)class_2561.method_43471((String)"pack.aether.freezing.title"), (boolean)false, string -> pack, (class_3288.class_7679)new class_3288.class_7679(metadata.method_14423(), metadata.method_14424(), class_7699.method_45397()), (class_3264)class_3264.field_14190, (class_3288.class_3289)class_3288.class_3289.field_14280, (boolean)false, (class_5352)Aether.create(Aether.decorateWithSource("pack.source.builtin"), (Boolean)AetherConfig.COMMON.add_temporary_freezing_automatically.get()))));
        }
    }

    private void setupRuinedPortalPack(AddPackFindersEvent event) {
        if (event.getPackType() == class_3264.field_14190) {
            Path resourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/ruined_portal").orElseThrow();
            PathPackResources pack = new PathPackResources("aether:" + String.valueOf(resourcePath), true, resourcePath);
            class_3272 metadata = new class_3272((class_2561)class_2561.method_43471((String)"pack.aether.ruined_portal.description"), class_155.method_16673().method_48017(class_3264.field_14190));
            event.addRepositorySource(source -> source.accept(class_3288.method_14456((String)"builtin/aether_ruined_portal", (class_2561)class_2561.method_43471((String)"pack.aether.ruined_portal.title"), (boolean)false, string -> pack, (class_3288.class_7679)new class_3288.class_7679(metadata.method_14423(), metadata.method_14424(), class_7699.method_45397()), (class_3264)class_3264.field_14190, (class_3288.class_3289)class_3288.class_3289.field_14280, (boolean)false, (class_5352)Aether.create(Aether.decorateWithSource("pack.source.builtin"), (Boolean)AetherConfig.COMMON.add_ruined_portal_automatically.get()))));
        }
    }

    static class_5352 create(final UnaryOperator<class_2561> decorator, final boolean shouldAddAutomatically) {
        return new class_5352(){

            public class_2561 method_45282(class_2561 component) {
                return (class_2561)decorator.apply(component);
            }

            public boolean method_45279() {
                return shouldAddAutomatically;
            }
        };
    }

    private static UnaryOperator<class_2561> decorateWithSource(String translationKey) {
        class_5250 component = class_2561.method_43471((String)translationKey);
        return arg_0 -> Aether.lambda$decorateWithSource$22((class_2561)component, arg_0);
    }

    private void registerDispenserBehaviors() {
        class_2315.method_10009((class_1935)((class_1935)AetherItems.GOLDEN_DART.get()), (class_2357)new DispenseDartBehavior((Supplier<? extends class_1792>)AetherItems.GOLDEN_DART));
        class_2315.method_10009((class_1935)((class_1935)AetherItems.POISON_DART.get()), (class_2357)new DispenseDartBehavior((Supplier<? extends class_1792>)AetherItems.POISON_DART));
        class_2315.method_10009((class_1935)((class_1935)AetherItems.ENCHANTED_DART.get()), (class_2357)new DispenseDartBehavior((Supplier<? extends class_1792>)AetherItems.ENCHANTED_DART));
        class_2315.method_10009((class_1935)((class_1935)AetherItems.LIGHTNING_KNIFE.get()), (class_2357)AetherDispenseBehaviors.DISPENSE_LIGHTNING_KNIFE_BEHAVIOR);
        class_2315.method_10009((class_1935)((class_1935)AetherItems.HAMMER_OF_KINGBDOGZ.get()), (class_2357)AetherDispenseBehaviors.DISPENSE_KINGBDOGZ_HAMMER_BEHAVIOR);
        class_2315.method_10009((class_1935)((class_1935)AetherItems.SKYROOT_WATER_BUCKET.get()), (class_2357)AetherDispenseBehaviors.SKYROOT_BUCKET_DISPENSE_BEHAVIOR);
        class_2315.method_10009((class_1935)((class_1935)AetherItems.SKYROOT_BUCKET.get()), (class_2357)AetherDispenseBehaviors.SKYROOT_BUCKET_PICKUP_BEHAVIOR);
        class_2315.method_10009((class_1935)((class_1935)AetherItems.AMBROSIUM_SHARD.get()), new DispenseUsableItemBehavior((class_3956)AetherRecipeTypes.AMBROSIUM_ENCHANTING.get()));
        class_2315.method_10009((class_1935)((class_1935)AetherItems.SWET_BALL.get()), new DispenseUsableItemBehavior((class_3956)AetherRecipeTypes.SWET_BALL_CONVERSION.get()));
        class_2315.method_10009((class_1935)((class_1935)AetherItems.SKYROOT_BOAT.get()), (class_2357)new DispenseSkyrootBoatBehavior());
        class_2315.method_10009((class_1935)((class_1935)AetherItems.SKYROOT_CHEST_BOAT.get()), (class_2357)new DispenseSkyrootBoatBehavior(true));
    }

    private void registerCauldronInteractions() {
        class_5620.field_27775.put((class_1792)AetherItems.SKYROOT_WATER_BUCKET.get(), AetherCauldronInteractions.FILL_WATER);
        class_5620.field_27776.put((class_1792)AetherItems.SKYROOT_WATER_BUCKET.get(), AetherCauldronInteractions.FILL_WATER);
        class_5620.field_27777.put((class_1792)AetherItems.SKYROOT_WATER_BUCKET.get(), AetherCauldronInteractions.FILL_WATER);
        class_5620.field_28011.put((class_1792)AetherItems.SKYROOT_WATER_BUCKET.get(), AetherCauldronInteractions.FILL_WATER);
        class_5620.field_27775.put((class_1792)AetherItems.SKYROOT_POWDER_SNOW_BUCKET.get(), AetherCauldronInteractions.FILL_POWDER_SNOW);
        class_5620.field_27776.put((class_1792)AetherItems.SKYROOT_POWDER_SNOW_BUCKET.get(), AetherCauldronInteractions.FILL_POWDER_SNOW);
        class_5620.field_27777.put((class_1792)AetherItems.SKYROOT_POWDER_SNOW_BUCKET.get(), AetherCauldronInteractions.FILL_POWDER_SNOW);
        class_5620.field_28011.put((class_1792)AetherItems.SKYROOT_POWDER_SNOW_BUCKET.get(), AetherCauldronInteractions.FILL_POWDER_SNOW);
        class_5620.field_27776.put((class_1792)AetherItems.SKYROOT_BUCKET.get(), AetherCauldronInteractions.EMPTY_WATER);
        class_5620.field_28011.put((class_1792)AetherItems.SKYROOT_BUCKET.get(), AetherCauldronInteractions.EMPTY_POWDER_SNOW);
        class_5620.field_27776.put((class_1792)AetherItems.LEATHER_GLOVES.get(), class_5620.field_27782);
        class_5620.field_27776.put((class_1792)AetherItems.RED_CAPE.get(), AetherCauldronInteractions.CAPE);
        class_5620.field_27776.put((class_1792)AetherItems.BLUE_CAPE.get(), AetherCauldronInteractions.CAPE);
        class_5620.field_27776.put((class_1792)AetherItems.YELLOW_CAPE.get(), AetherCauldronInteractions.CAPE);
    }

    private void registerComposting() {
        this.addCompost(0.3f, (class_1935)((class_2248)AetherBlocks.SKYROOT_LEAVES.get()).method_8389());
        this.addCompost(0.3f, (class_1935)AetherBlocks.SKYROOT_SAPLING.get());
        this.addCompost(0.3f, (class_1935)AetherBlocks.GOLDEN_OAK_LEAVES.get());
        this.addCompost(0.3f, (class_1935)AetherBlocks.GOLDEN_OAK_SAPLING.get());
        this.addCompost(0.3f, (class_1935)AetherBlocks.CRYSTAL_LEAVES.get());
        this.addCompost(0.3f, (class_1935)AetherBlocks.CRYSTAL_FRUIT_LEAVES.get());
        this.addCompost(0.3f, (class_1935)AetherBlocks.HOLIDAY_LEAVES.get());
        this.addCompost(0.3f, (class_1935)AetherBlocks.DECORATED_HOLIDAY_LEAVES.get());
        this.addCompost(0.3f, (class_1935)AetherItems.BLUE_BERRY.get());
        this.addCompost(0.5f, (class_1935)AetherItems.ENCHANTED_BERRY.get());
        this.addCompost(0.5f, (class_1935)AetherBlocks.BERRY_BUSH.get());
        this.addCompost(0.5f, (class_1935)AetherBlocks.BERRY_BUSH_STEM.get());
        this.addCompost(0.65f, (class_1935)AetherBlocks.WHITE_FLOWER.get());
        this.addCompost(0.65f, (class_1935)AetherBlocks.PURPLE_FLOWER.get());
        this.addCompost(0.65f, (class_1935)AetherItems.WHITE_APPLE.get());
    }

    private void addCompost(float chance, class_1935 item) {
        class_3962.field_17566.put((Object)item.method_8389(), chance);
    }

    private static /* synthetic */ class_2561 lambda$decorateWithSource$22(class_2561 component, class_2561 name) {
        return class_2561.method_43469((String)"pack.nameAndSource", (Object[])new Object[]{name, component}).method_27692(class_124.field_1080);
    }
}

