/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.stats;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.stats.BaseMaterialStats;
import slimeknights.tconstruct.library.materials.stats.IRepairableMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class SkullStats
extends BaseMaterialStats
implements IRepairableMaterialStats {
    public static final MaterialStatsId ID = new MaterialStatsId(TConstruct.getResource("skull"));
    public static final SkullStats DEFAULT = new SkullStats(1, 0);
    private static final List<class_2561> DESCRIPTION = ImmutableList.of((Object)ToolStats.DURABILITY.getDescription(), (Object)ToolStats.ARMOR.getDescription());
    private final int durability;
    private final int armor;

    public SkullStats(class_2540 buffer) {
        this.durability = buffer.readInt();
        this.armor = buffer.readInt();
    }

    @Override
    public void encode(class_2540 buffer) {
        buffer.writeInt(this.durability);
        buffer.writeInt(this.armor);
    }

    @Override
    public MaterialStatsId getIdentifier() {
        return ID;
    }

    @Override
    public List<class_2561> getLocalizedInfo() {
        return Arrays.asList(ToolStats.DURABILITY.formatValue(this.durability), ToolStats.ARMOR.formatValue(this.armor));
    }

    @Override
    public List<class_2561> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    @Override
    public int getDurability() {
        return this.durability;
    }

    public int getArmor() {
        return this.armor;
    }

    public SkullStats(int durability, int armor) {
        this.durability = durability;
        this.armor = armor;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SkullStats)) {
            return false;
        }
        SkullStats other = (SkullStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getDurability() != other.getDurability()) {
            return false;
        }
        return this.getArmor() == other.getArmor();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SkullStats;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getDurability();
        result = result * 59 + this.getArmor();
        return result;
    }

    public String toString() {
        return "SkullStats(durability=" + this.getDurability() + ", armor=" + this.getArmor() + ")";
    }
}

